<tr class="product_row">
    <td>
        <?php echo e($product->product_name, false); ?>

        <br/>
        <?php echo e($product->sub_sku, false); ?>


        <?php if( session()->get('business.enable_lot_number') == 1 || session()->get('business.enable_product_expiry') == 1): ?>
        <?php
            $lot_enabled = session()->get('business.enable_lot_number');
            $exp_enabled = session()->get('business.enable_product_expiry');
            $lot_no_line_id = '';
            if(!empty($product->lot_no_line_id)){
                $lot_no_line_id = $product->lot_no_line_id;
            }
        ?>

        <?php if($product->enable_stock == 1): ?>
            <br>
            <small class="text-muted" style="white-space: nowrap;"><?php echo app('translator')->get('report.current_stock'); ?>: <span class="qty_available_text"><?php echo e($product->formatted_qty_available, false); ?></span> <?php echo e($product->unit, false); ?></small>
        <?php endif; ?>
        <?php if(!empty($product->lot_numbers)): ?>
            <select class="form-control lot_number" name="products[<?php echo e($row_index, false); ?>][lot_no_line_id]">
                <option value=""><?php echo app('translator')->get('lang_v1.lot_n_expiry'); ?></option>
                <?php $__currentLoopData = $product->lot_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lot_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $selected = "";
                        if($lot_number->purchase_line_id == $lot_no_line_id){
                            $selected = "selected";

                            $max_qty_rule = $lot_number->qty_available;
                            $max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_number->qty_formated, 'unit' => $product->unit  ]);
                        }

                        $expiry_text = '';
                        if($exp_enabled == 1 && !empty($lot_number->exp_date)){
                            if( \Carbon::now()->gt(\Carbon::createFromFormat('Y-m-d', $lot_number->exp_date)) ){
                                $expiry_text = '(' . __('report.expired') . ')';
                            }
                        }
                    ?>
                    <option value="<?php echo e($lot_number->purchase_line_id, false); ?>" data-qty_available="<?php echo e($lot_number->qty_available, false); ?>" data-msg-max="<?php echo app('translator')->get('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_number->qty_formated, 'unit' => $product->unit  ]); ?>" <?php echo e($selected, false); ?>><?php if(!empty($lot_number->lot_number) && $lot_enabled == 1): ?><?php echo e($lot_number->lot_number, false); ?> <?php endif; ?> <?php if($lot_enabled == 1 && $exp_enabled == 1): ?> - <?php endif; ?> <?php if($exp_enabled == 1 && !empty($lot_number->exp_date)): ?> <?php echo app('translator')->get('product.exp_date'); ?>: <?php echo e(\Carbon::createFromTimestamp(strtotime($lot_number->exp_date))->format(session('business.date_format')), false); ?> <?php endif; ?> <?php echo e($expiry_text, false); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php endif; ?>
    <?php endif; ?>
    </td>
    <td>
        <input type="text" name="products[<?php echo e($row_index, false); ?>][current_stock]" id="current_stock" class="form-control input_number" value="<?php echo e(number_format($product->qty_available, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>">
    </td>
    <td>
        <input type="text" class="form-control input_number counted_stock" name="products[<?php echo e($row_index, false); ?>][counted_stock]" id="counted_stock">
    </td>
    <td>
        
        <?php if(!empty($product->transaction_sell_lines_id)): ?>
            <input type="hidden" name="products[<?php echo e($row_index, false); ?>][transaction_sell_lines_id]" class="form-control" value="<?php echo e($product->transaction_sell_lines_id, false); ?>">
        <?php endif; ?>

        <input type="hidden" name="products[<?php echo e($row_index, false); ?>][product_id]" class="form-control product_id" value="<?php echo e($product->product_id, false); ?>">

        <input type="hidden" value="<?php echo e($product->variation_id, false); ?>" 
            name="products[<?php echo e($row_index, false); ?>][variation_id]">

        <input type="hidden" value="<?php echo e($product->enable_stock, false); ?>" 
            name="products[<?php echo e($row_index, false); ?>][enable_stock]">
        
        <?php if(empty($product->quantity_ordered)): ?>
            <?php
                $product->quantity_ordered = 1;
            ?>
        <?php endif; ?>

        <input type="text" class="form-control product_quantity input_number" value="<?php echo e(number_format($product->quantity_ordered, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>" name="products[<?php echo e($row_index, false); ?>][quantity]" 
        <?php if($product->unit_allow_decimal == 1): ?> data-decimal=1 <?php else: ?> data-rule-abs_digit="true" data-msg-abs_digit="<?php echo app('translator')->get('lang_v1.decimal_value_not_allowed'); ?>" data-decimal=0 <?php endif; ?>
        data-rule-required="true" data-msg-required="<?php echo app('translator')->get('validation.custom-messages.this_field_is_required'); ?>" <?php if($product->enable_stock): ?> data-rule-max-value="<?php echo e($product->qty_available, false); ?>" data-msg-max-value="<?php echo app('translator')->get('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ]); ?>"
        data-qty_available="<?php echo e($product->qty_available, false); ?>" 
        data-msg_max_default="<?php echo app('translator')->get('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ]); ?>"
         <?php endif; ?> >
        <?php echo e($product->unit, false); ?>

    </td>
    <td class="show_price_with_permission">
        <input type="text" name="products[<?php echo e($row_index, false); ?>][unit_price]" class="form-control product_unit_price input_number" value="<?php echo e(number_format($product->default_sell_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>">
    </td>
    <td class="show_price_with_permission">
        <input type="text" readonly name="products[<?php echo e($row_index, false); ?>][price]" class="form-control product_line_total" value="<?php echo e(number_format($product->quantity_ordered*$product->default_sell_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>">
    </td>
    <td class="text-center">
        <i class="fa fa-trash remove_product_row cursor-pointer" aria-hidden="true"></i>
    </td>
</tr>
<script>
    $(document).ready(function() {
        $(".product_row").each(function() {
            let row = $(this);
            let currentStockInput = row.find("#current_stock");
            let countedStockInput = row.find("#counted_stock");
            let quantityInput = row.find(".product_quantity");
    
            // Make current_stock and quantity read-only
            currentStockInput.prop("readonly", true);
            quantityInput.prop("readonly", true); 
    
            // Update quantity when counted_stock changes
            countedStockInput.on("change", function() {
                let currentStock = Number(currentStockInput.val().replace(/,/g, '')) || 0;
                let countedStock = Number(countedStockInput.val().replace(/,/g, '')) || 0;
                let difference = currentStock - countedStock;
                quantityInput.val(difference);
    
                // Update the row and total when counted stock changes
                update_table_row(row);
            });
        });
    });
    
    // Function to update the total of all table rows
    function update_table_total() {
        var table_total = 0;
        
        $('table#stock_adjustment_product_table tbody tr').each(function() {
            var this_total = parseFloat(__read_number($(this).find('input.product_line_total'))) || 0;
            table_total += this_total;
        });
    
        $('input#total_amount').val(__number_f(table_total)); // Update total amount input
        $('span#total_adjustment').text(__number_f(table_total)); // Display total adjustment
    }
    
    // Function to update a single row
    function update_table_row(tr) {
        var quantity = parseFloat(__read_number(tr.find('input.product_quantity'))) || 0;
        var unit_price = parseFloat(__read_number(tr.find('input.product_unit_price'))) || 0;
        var row_total = quantity * unit_price; // Calculate row total
    
        tr.find('input.product_line_total').val(__number_f(row_total)); // Update row total
    
        update_table_total(); // Update table total
    }
    
    // Attach event listener to update row calculations when counted_stock or unit_price changes
    $(document).on('change', 'input.counted_stock, input.product_unit_price', function() {
        var tr = $(this).closest('tr'); // Get the row of the changed input
        update_table_row(tr); // Recalculate the row
    });

</script>
<?php /**PATH /home/palmsyst/pos.joschem.co.ke/resources/views/stock_adjustment/partials/product_table_row.blade.php ENDPATH**/ ?>