/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES (1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-16 04:56:00','2025-03-16 04:56:00'),(2,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Joshua \"}',NULL,'2025-03-16 05:02:01','2025-03-16 05:02:01'),(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-17 05:10:54','2025-03-17 05:10:54'),(4,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-17 05:35:19','2025-03-17 05:35:19');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 03:13:44','2017-12-18 03:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 03:04:39','2017-12-18 03:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 02:55:40','2017-12-18 02:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 02:58:40','2017-12-18 02:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Joschem Pharmacy Ltd',133,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Africa/Nairobi',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"enable_msp\":\"1\",\"allow_overselling\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"disable_draft\":\"1\",\"disable_discount\":\"1\",\"disable_order_tax\":\"1\",\"print_on_suspend\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',0,1,0,1,0,0,1,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"expenses\",\"account\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":\"Mpesa\",\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"enable_purchase_order\":\"1\",\"enable_purchase_requisition\":\"1\",\"default_datatable_page_entries\":\"25\"}',1,'2025-03-16 07:25:49','2025-03-17 05:53:04');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','Joschem Pharmacy Ltd - Emali','Mbilo Building, Opposite County Council Offices','Kenya','Emali','Makueni','00100',1,1,1,1,0,1,'browser',NULL,'0723107943','0785646872',NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-16 07:25:49','2025-03-17 05:13:48');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-03-17 05:50:00','2025-03-17 05:50:48');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (2,'PRODUCT',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:26','2025-03-17 05:47:26'),(3,'INFUSIONS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:27','2025-03-17 05:47:27'),(4,'COUGH SYRUP',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:27','2025-03-17 05:47:27'),(5,'ANT-HYPERTENSIVE',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:27','2025-03-17 05:47:27'),(6,'ANTACID',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:27','2025-03-17 05:47:27'),(7,'SUPPOSITORIES',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(8,'SEXUAL ENHANCER',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(9,'PESSARIES',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(10,'NASAL DROPS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(11,'Miscellaneous',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(12,'LAXATIVE',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(13,'F00D SUPPLIMENT',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(14,'EYE DR0PS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(15,'EMERGENCY PILLS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(16,'DISINFECTANT',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(17,'DEWORMER',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(18,'CREAMS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(19,'COUGH SUPPRESSANT',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(20,'CNS DEPRESSANTS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(21,'CALCIUM SUPLIMENT',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(22,'BRONCHODILATOR',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(23,'Beauty Products',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(24,'APPETIZER',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(25,'ANT-PSYCHOTIC',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(26,'ANTISEPTIC',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(27,'ANTIFUNGAL CRM',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(28,'ANTIFUNGAL',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(29,'anti histamin crm',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(30,'ANTHISTAMINE/COUGH SYR',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(31,'ANTHISTAMINE TABS',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(32,'ANT-DIABETIC',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(33,'ANTBIOTIC',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(34,'ANTASTHMATIC',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(35,'Analgesia Cream',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(36,'Analgesia',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(37,'AMOEBICIDE',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-03-17 05:47:28','2025-03-17 05:47:28');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-16 07:25:49','2025-03-16 07:25:49');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'Item','Qty','Price','Subtotal',NULL,NULL,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,1,0,NULL,0,NULL,'slim',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'2025-03-16 07:25:49','2025-03-17 05:15:05');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,0,4,1,'2025-03-16 07:25:49','2025-03-16 07:25:49');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2022_10_31_115725_create_accounting_account_types_table',1),(286,'2022_11_01_104108_create_accounting_accounts_table',1),(287,'2022_11_10_135427_create_accounts_transactions_table',1),(288,'2022_11_14_171948_create_accounting_acc_trans_mapping',1),(289,'2022_12_02_133536_create_accounting_budgets_table',1),(290,'2022_12_19_124743_add_accounting_settings_column_to_business_table',1),(291,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',1),(292,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(293,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(294,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(295,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(296,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(297,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(298,'2023_04_17_155216_add_custom_fields_to_products',1),(299,'2023_04_28_130247_add_price_type_to_group_price_table',1),(300,'2023_05_25_131005_add_default_map_transactions_fields',1),(301,'2023_06_21_033923_add_delivery_person_in_transactions',1),(302,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(303,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(304,'2023_12_06_152840_add_contact_type_in_contacts',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',2);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(1,'App\\User',2);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2025-03-16 07:24:26',NULL),(2,'direct_sell.access','web','2025-03-16 07:24:26',NULL),(3,'product.opening_stock','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(4,'crud_all_bookings','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(5,'crud_own_bookings','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(6,'access_default_selling_price','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(7,'purchase.payments','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(8,'sell.payments','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(9,'edit_product_price_from_sale_screen','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(10,'edit_product_discount_from_sale_screen','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(11,'roles.view','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(12,'roles.create','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(13,'roles.update','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(14,'roles.delete','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(15,'account.access','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(16,'discount.access','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(17,'view_purchase_price','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(18,'view_own_sell_only','web','2025-03-16 07:24:27','2025-03-16 07:24:27'),(19,'edit_product_discount_from_pos_screen','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(20,'edit_product_price_from_pos_screen','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(21,'access_shipping','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(22,'purchase.update_status','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(23,'list_drafts','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(24,'list_quotations','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(25,'view_cash_register','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(26,'close_cash_register','web','2025-03-16 07:24:28','2025-03-16 07:24:28'),(27,'print_invoice','web','2025-03-16 07:24:29','2025-03-16 07:24:29'),(28,'user.view','web','2025-03-16 07:24:29',NULL),(29,'user.create','web','2025-03-16 07:24:29',NULL),(30,'user.update','web','2025-03-16 07:24:29',NULL),(31,'user.delete','web','2025-03-16 07:24:29',NULL),(32,'supplier.view','web','2025-03-16 07:24:29',NULL),(33,'supplier.create','web','2025-03-16 07:24:29',NULL),(34,'supplier.update','web','2025-03-16 07:24:29',NULL),(35,'supplier.delete','web','2025-03-16 07:24:29',NULL),(36,'customer.view','web','2025-03-16 07:24:29',NULL),(37,'customer.create','web','2025-03-16 07:24:29',NULL),(38,'customer.update','web','2025-03-16 07:24:29',NULL),(39,'customer.delete','web','2025-03-16 07:24:29',NULL),(40,'product.view','web','2025-03-16 07:24:29',NULL),(41,'product.create','web','2025-03-16 07:24:29',NULL),(42,'product.update','web','2025-03-16 07:24:29',NULL),(43,'product.delete','web','2025-03-16 07:24:29',NULL),(44,'purchase.view','web','2025-03-16 07:24:29',NULL),(45,'purchase.create','web','2025-03-16 07:24:29',NULL),(46,'purchase.update','web','2025-03-16 07:24:29',NULL),(47,'purchase.delete','web','2025-03-16 07:24:29',NULL),(48,'sell.view','web','2025-03-16 07:24:29',NULL),(49,'sell.create','web','2025-03-16 07:24:29',NULL),(50,'sell.update','web','2025-03-16 07:24:29',NULL),(51,'sell.delete','web','2025-03-16 07:24:29',NULL),(52,'purchase_n_sell_report.view','web','2025-03-16 07:24:29',NULL),(53,'contacts_report.view','web','2025-03-16 07:24:29',NULL),(54,'stock_report.view','web','2025-03-16 07:24:29',NULL),(55,'tax_report.view','web','2025-03-16 07:24:29',NULL),(56,'trending_product_report.view','web','2025-03-16 07:24:29',NULL),(57,'register_report.view','web','2025-03-16 07:24:29',NULL),(58,'sales_representative.view','web','2025-03-16 07:24:29',NULL),(59,'expense_report.view','web','2025-03-16 07:24:29',NULL),(60,'business_settings.access','web','2025-03-16 07:24:29',NULL),(61,'barcode_settings.access','web','2025-03-16 07:24:29',NULL),(62,'invoice_settings.access','web','2025-03-16 07:24:29',NULL),(63,'brand.view','web','2025-03-16 07:24:29',NULL),(64,'brand.create','web','2025-03-16 07:24:29',NULL),(65,'brand.update','web','2025-03-16 07:24:29',NULL),(66,'brand.delete','web','2025-03-16 07:24:29',NULL),(67,'tax_rate.view','web','2025-03-16 07:24:29',NULL),(68,'tax_rate.create','web','2025-03-16 07:24:29',NULL),(69,'tax_rate.update','web','2025-03-16 07:24:29',NULL),(70,'tax_rate.delete','web','2025-03-16 07:24:29',NULL),(71,'unit.view','web','2025-03-16 07:24:29',NULL),(72,'unit.create','web','2025-03-16 07:24:29',NULL),(73,'unit.update','web','2025-03-16 07:24:29',NULL),(74,'unit.delete','web','2025-03-16 07:24:29',NULL),(75,'category.view','web','2025-03-16 07:24:29',NULL),(76,'category.create','web','2025-03-16 07:24:29',NULL),(77,'category.update','web','2025-03-16 07:24:29',NULL),(78,'category.delete','web','2025-03-16 07:24:29',NULL),(79,'expense.access','web','2025-03-16 07:24:29',NULL),(80,'access_all_locations','web','2025-03-16 07:24:29',NULL),(81,'dashboard.data','web','2025-03-16 07:24:29',NULL),(82,'location.1','web','2025-03-16 07:25:49','2025-03-16 07:25:49'),(83,'selling_price_group.1','web','2025-03-17 05:47:47','2025-03-17 05:47:47');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(258,1),(259,1),(260,1),(261,1),(262,1),(263,1),(264,1),(265,1),(266,1),(267,1),(268,1),(269,1),(270,1),(271,1),(272,1),(273,1),(274,1),(275,1),(276,1),(277,1),(278,1),(279,1),(280,1),(281,1),(282,1),(283,1),(284,1),(285,1),(286,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1),(299,1),(300,1),(301,1),(302,1),(303,1),(304,1),(305,1),(306,1),(307,1),(308,1),(309,1),(310,1),(311,1),(312,1),(313,1),(314,1),(315,1),(316,1),(317,1),(318,1),(319,1),(320,1),(321,1),(322,1),(323,1),(324,1),(325,1),(326,1),(327,1),(328,1),(329,1),(330,1),(331,1),(332,1),(333,1),(334,1),(335,1),(336,1),(337,1),(338,1),(339,1),(340,1),(341,1),(342,1),(343,1),(344,1),(345,1),(346,1),(347,1),(348,1),(349,1),(350,1),(351,1),(352,1),(353,1),(354,1),(355,1),(356,1),(357,1),(358,1),(359,1),(360,1),(361,1),(362,1),(363,1),(364,1),(365,1),(366,1),(367,1),(368,1),(369,1),(370,1),(371,1),(372,1),(373,1),(374,1),(375,1),(376,1),(377,1),(378,1),(379,1),(380,1),(381,1),(382,1),(383,1),(384,1),(385,1),(386,1),(387,1),(388,1),(389,1),(390,1),(391,1),(392,1),(393,1),(394,1),(395,1),(396,1),(397,1),(398,1),(399,1),(400,1),(401,1),(402,1),(403,1),(404,1),(405,1),(406,1),(407,1),(408,1),(409,1),(410,1),(411,1),(412,1),(413,1),(414,1),(415,1),(416,1),(417,1),(418,1),(419,1),(420,1),(421,1),(422,1),(423,1),(424,1),(425,1),(426,1),(427,1),(428,1),(429,1),(430,1),(431,1),(432,1),(433,1),(434,1),(435,1),(436,1),(437,1),(438,1),(439,1),(440,1),(441,1),(442,1),(443,1),(444,1),(445,1),(446,1),(447,1),(448,1),(449,1),(450,1),(451,1),(452,1),(453,1),(454,1),(455,1),(456,1),(457,1),(458,1),(459,1),(460,1),(461,1),(462,1),(463,1),(464,1),(465,1),(466,1),(467,1),(468,1),(469,1),(470,1),(471,1),(472,1),(473,1),(474,1),(475,1),(476,1),(477,1),(478,1),(479,1),(480,1),(481,1),(482,1),(483,1),(484,1),(485,1),(486,1),(487,1),(488,1),(489,1),(490,1),(491,1),(492,1),(493,1),(494,1),(495,1),(496,1),(497,1),(498,1),(499,1),(500,1),(501,1),(502,1),(503,1),(504,1),(505,1),(506,1),(507,1),(508,1),(509,1),(510,1),(511,1),(512,1),(513,1),(514,1),(515,1),(516,1),(517,1),(518,1),(519,1),(520,1),(521,1),(522,1),(523,1),(524,1),(525,1),(526,1),(527,1),(528,1),(529,1),(530,1),(531,1),(532,1),(533,1),(534,1),(535,1),(536,1),(537,1),(538,1),(539,1),(540,1),(541,1),(542,1),(543,1),(544,1),(545,1),(546,1),(547,1),(548,1),(549,1),(550,1),(551,1),(552,1),(553,1),(554,1),(555,1),(556,1),(557,1),(558,1),(559,1),(560,1),(561,1),(562,1),(563,1),(564,1),(565,1),(566,1),(567,1),(568,1),(569,1),(570,1),(571,1),(572,1),(573,1),(574,1),(575,1),(576,1),(577,1),(578,1),(579,1),(580,1),(581,1),(582,1),(583,1),(584,1),(585,1),(586,1),(587,1),(588,1),(589,1),(590,1),(591,1),(592,1),(593,1),(594,1),(595,1),(596,1),(597,1),(598,1),(599,1),(600,1),(601,1),(602,1),(603,1),(604,1),(605,1),(606,1),(607,1),(608,1),(609,1),(610,1),(611,1),(612,1),(613,1),(614,1),(615,1),(616,1),(617,1),(618,1),(619,1),(620,1),(621,1),(622,1),(623,1),(624,1),(625,1),(626,1),(627,1),(628,1),(629,1),(630,1),(631,1),(632,1),(633,1),(634,1),(635,1),(636,1),(637,1),(638,1),(639,1),(640,1),(641,1),(642,1),(643,1),(644,1),(645,1),(646,1),(647,1),(648,1),(649,1),(650,1),(651,1),(652,1),(653,1),(654,1),(655,1),(656,1),(657,1),(658,1),(659,1),(660,1),(661,1),(662,1),(663,1),(664,1),(665,1),(666,1),(667,1),(668,1),(669,1),(670,1),(671,1),(672,1),(673,1),(674,1),(675,1),(676,1),(677,1),(678,1),(679,1),(680,1),(681,1),(682,1),(683,1),(684,1),(685,1),(686,1),(687,1),(688,1),(689,1),(690,1),(691,1),(692,1),(693,1),(694,1),(695,1),(696,1),(697,1),(698,1),(699,1),(700,1),(701,1),(702,1),(703,1),(704,1),(705,1),(706,1),(707,1),(708,1),(709,1),(710,1),(711,1),(712,1),(713,1),(714,1),(715,1),(716,1),(717,1),(718,1),(719,1),(720,1),(721,1),(722,1),(723,1),(724,1),(725,1),(726,1),(727,1),(728,1),(729,1),(730,1),(731,1),(732,1),(733,1),(734,1),(735,1),(736,1),(737,1),(738,1),(739,1),(740,1),(741,1),(742,1),(743,1),(744,1),(745,1),(746,1),(747,1),(748,1),(749,1),(750,1),(751,1),(752,1),(753,1),(754,1),(755,1),(756,1),(757,1),(758,1),(759,1),(760,1),(761,1),(762,1),(763,1),(764,1),(765,1),(766,1),(767,1),(768,1),(769,1),(770,1),(771,1),(772,1),(773,1),(774,1),(775,1),(776,1),(777,1),(778,1),(779,1),(780,1),(781,1),(782,1),(783,1),(784,1),(785,1),(786,1),(787,1),(788,1),(789,1),(790,1),(791,1),(792,1),(793,1),(794,1),(795,1),(796,1),(797,1),(798,1),(799,1),(800,1),(801,1),(802,1),(803,1),(804,1),(805,1),(806,1),(807,1),(808,1),(809,1),(810,1),(811,1),(812,1),(813,1),(814,1),(815,1),(816,1),(817,1),(818,1),(819,1),(820,1),(821,1),(822,1),(823,1),(824,1),(825,1),(826,1),(827,1),(828,1),(829,1),(830,1),(831,1),(832,1),(833,1),(834,1),(835,1),(836,1),(837,1),(838,1),(839,1),(840,1),(841,1),(842,1),(843,1),(844,1),(845,1),(846,1),(847,1),(848,1),(849,1),(850,1),(851,1),(852,1),(853,1),(854,1),(855,1),(856,1),(857,1),(858,1),(859,1),(860,1),(861,1),(862,1),(863,1),(864,1),(865,1),(866,1),(867,1),(868,1),(869,1),(870,1),(871,1),(872,1),(873,1),(874,1),(875,1),(876,1),(877,1),(878,1),(879,1),(880,1),(881,1),(882,1),(883,1),(884,1),(885,1),(886,1),(887,1),(888,1),(889,1),(890,1),(891,1),(892,1),(893,1),(894,1),(895,1),(896,1),(897,1),(898,1),(899,1),(900,1),(901,1),(902,1),(903,1),(904,1),(905,1),(906,1),(907,1),(908,1),(909,1),(910,1),(911,1),(912,1),(913,1),(914,1),(915,1),(916,1),(917,1),(918,1),(919,1),(920,1),(921,1),(922,1),(923,1),(924,1),(925,1),(926,1),(927,1),(928,1),(929,1),(930,1),(931,1),(932,1),(933,1),(934,1),(935,1),(936,1),(937,1),(938,1),(939,1),(940,1),(941,1),(942,1),(943,1),(944,1),(945,1),(946,1),(947,1),(948,1),(949,1),(950,1),(951,1),(952,1),(953,1),(954,1),(955,1),(956,1),(957,1),(958,1),(959,1),(960,1),(961,1),(962,1),(963,1),(964,1),(965,1),(966,1),(967,1),(968,1),(969,1),(970,1),(971,1),(972,1),(973,1),(974,1),(975,1),(976,1),(977,1),(978,1),(979,1),(980,1),(981,1),(982,1),(983,1),(984,1),(985,1),(986,1),(987,1),(988,1),(989,1),(990,1),(991,1),(992,1),(993,1),(994,1),(995,1),(996,1),(997,1),(998,1),(999,1),(1000,1),(1001,1),(1002,1),(1003,1),(1004,1),(1005,1),(1006,1),(1007,1),(1008,1),(1009,1),(1010,1),(1011,1),(1012,1),(1013,1),(1014,1),(1015,1),(1016,1),(1017,1),(1018,1),(1019,1),(1020,1),(1021,1),(1022,1),(1023,1),(1024,1),(1025,1),(1026,1),(1027,1),(1028,1),(1029,1),(1030,1),(1031,1),(1032,1),(1033,1),(1034,1),(1035,1),(1036,1),(1037,1),(1038,1),(1039,1),(1040,1),(1041,1),(1042,1),(1043,1),(1044,1),(1045,1),(1046,1),(1047,1),(1048,1),(1049,1),(1050,1),(1051,1),(1052,1),(1053,1),(1054,1),(1055,1),(1056,1),(1057,1),(1058,1),(1059,1),(1060,1),(1061,1),(1062,1),(1063,1),(1064,1),(1065,1),(1066,1),(1067,1),(1068,1),(1069,1),(1070,1),(1071,1),(1072,1),(1073,1),(1074,1),(1075,1),(1076,1),(1077,1),(1078,1),(1079,1),(1080,1),(1081,1),(1082,1),(1083,1),(1084,1),(1085,1),(1086,1),(1087,1),(1088,1),(1089,1),(1090,1),(1091,1),(1092,1),(1093,1),(1094,1),(1095,1),(1096,1),(1097,1),(1098,1),(1099,1),(1100,1),(1101,1),(1102,1),(1103,1),(1104,1),(1105,1),(1106,1),(1107,1),(1108,1),(1109,1),(1110,1),(1111,1),(1112,1),(1113,1),(1114,1),(1115,1),(1116,1),(1117,1),(1118,1),(1119,1),(1120,1),(1121,1),(1122,1),(1123,1),(1124,1),(1125,1),(1126,1),(1127,1),(1128,1),(1129,1),(1130,1),(1131,1),(1132,1),(1133,1),(1134,1),(1135,1),(1136,1),(1137,1),(1138,1),(1139,1),(1140,1),(1141,1),(1142,1),(1143,1),(1144,1),(1145,1),(1146,1),(1147,1),(1148,1),(1149,1),(1150,1),(1151,1),(1152,1),(1153,1),(1154,1),(1155,1),(1156,1),(1157,1),(1158,1),(1159,1),(1160,1),(1161,1),(1162,1),(1163,1),(1164,1),(1165,1),(1166,1),(1167,1),(1168,1),(1169,1),(1170,1),(1171,1),(1172,1),(1173,1),(1174,1),(1175,1),(1176,1),(1177,1),(1178,1),(1179,1),(1180,1),(1181,1),(1182,1),(1183,1),(1184,1),(1185,1),(1186,1),(1187,1),(1188,1),(1189,1),(1190,1),(1191,1),(1192,1),(1193,1),(1194,1),(1195,1),(1196,1),(1197,1),(1198,1),(1199,1),(1200,1),(1201,1),(1202,1),(1203,1),(1204,1),(1205,1),(1206,1),(1207,1),(1208,1),(1209,1),(1210,1),(1211,1),(1212,1),(1213,1),(1214,1),(1215,1),(1216,1),(1217,1),(1218,1),(1219,1),(1220,1),(1221,1),(1222,1),(1223,1),(1224,1),(1225,1),(1226,1),(1227,1),(1228,1),(1229,1),(1230,1),(1231,1),(1232,1),(1233,1),(1234,1),(1235,1),(1236,1),(1237,1),(1238,1),(1239,1),(1240,1),(1241,1),(1242,1),(1243,1),(1244,1),(1245,1),(1246,1),(1247,1),(1248,1),(1249,1),(1250,1),(1251,1),(1252,1),(1253,1),(1254,1),(1255,1),(1256,1),(1257,1),(1258,1),(1259,1),(1260,1),(1261,1),(1262,1),(1263,1),(1264,1),(1265,1),(1266,1),(1267,1),(1268,1),(1269,1),(1270,1),(1271,1),(1272,1),(1273,1),(1274,1),(1275,1),(1276,1),(1277,1),(1278,1),(1279,1),(1280,1),(1281,1),(1282,1),(1283,1),(1284,1),(1285,1),(1286,1),(1287,1),(1288,1),(1289,1),(1290,1),(1291,1),(1292,1),(1293,1),(1294,1),(1295,1),(1296,1),(1297,1),(1298,1),(1299,1),(1300,1),(1301,1),(1302,1),(1303,1),(1304,1),(1305,1),(1306,1),(1307,1),(1308,1),(1309,1),(1310,1),(1311,1),(1312,1),(1313,1),(1314,1),(1315,1),(1316,1),(1317,1),(1318,1),(1319,1),(1320,1),(1321,1),(1322,1),(1323,1),(1324,1),(1325,1),(1326,1),(1327,1),(1328,1),(1329,1),(1330,1),(1331,1),(1332,1),(1333,1),(1334,1),(1335,1),(1336,1),(1337,1),(1338,1),(1339,1),(1340,1),(1341,1),(1342,1),(1343,1),(1344,1),(1345,1),(1346,1),(1347,1),(1348,1),(1349,1),(1350,1),(1351,1),(1352,1),(1353,1),(1354,1),(1355,1),(1356,1),(1357,1),(1358,1),(1359,1),(1360,1),(1361,1),(1362,1),(1363,1),(1364,1),(1365,1),(1366,1),(1367,1),(1368,1),(1369,1),(1370,1),(1371,1),(1372,1),(1373,1),(1374,1),(1375,1),(1376,1),(1377,1),(1378,1),(1379,1),(1380,1),(1381,1),(1382,1),(1383,1),(1384,1),(1385,1),(1386,1),(1387,1),(1388,1),(1389,1),(1390,1),(1391,1),(1392,1),(1393,1),(1394,1),(1395,1),(1396,1),(1397,1),(1398,1),(1399,1),(1400,1),(1401,1),(1402,1),(1403,1),(1404,1),(1405,1),(1406,1),(1407,1),(1408,1),(1409,1),(1410,1),(1411,1),(1412,1),(1413,1),(1414,1),(1415,1),(1416,1),(1417,1),(1418,1),(1419,1),(1420,1),(1421,1),(1422,1),(1423,1),(1424,1),(1425,1),(1426,1),(1427,1),(1428,1),(1429,1),(1430,1),(1431,1),(1432,1),(1433,1),(1434,1),(1435,1),(1436,1),(1437,1),(1438,1),(1439,1),(1440,1),(1441,1),(1442,1),(1443,1),(1444,1),(1445,1),(1446,1),(1447,1),(1448,1),(1449,1),(1450,1),(1451,1),(1452,1),(1453,1),(1454,1),(1455,1),(1456,1),(1457,1),(1458,1),(1459,1),(1460,1),(1461,1),(1462,1),(1463,1),(1464,1),(1465,1),(1466,1),(1467,1),(1468,1),(1469,1),(1470,1),(1471,1),(1472,1),(1473,1),(1474,1),(1475,1),(1476,1),(1477,1),(1478,1),(1479,1),(1480,1),(1481,1),(1482,1),(1483,1),(1484,1),(1485,1),(1486,1),(1487,1),(1488,1),(1489,1),(1490,1),(1491,1),(1492,1),(1493,1),(1494,1),(1495,1),(1496,1),(1497,1),(1498,1),(1499,1),(1500,1),(1501,1),(1502,1),(1503,1),(1504,1),(1505,1),(1506,1),(1507,1),(1508,1),(1509,1),(1510,1),(1511,1),(1512,1),(1513,1),(1514,1),(1515,1),(1516,1),(1517,1),(1518,1),(1519,1),(1520,1),(1521,1),(1522,1),(1523,1),(1524,1),(1525,1),(1526,1),(1527,1),(1528,1),(1529,1),(1530,1),(1531,1),(1532,1),(1533,1),(1534,1),(1535,1),(1536,1),(1537,1),(1538,1),(1539,1),(1540,1),(1541,1),(1542,1),(1543,1),(1544,1),(1545,1),(1546,1),(1547,1),(1548,1),(1549,1),(1550,1),(1551,1),(1552,1),(1553,1),(1554,1),(1555,1),(1556,1),(1557,1),(1558,1),(1559,1),(1560,1),(1561,1),(1562,1),(1563,1),(1564,1),(1565,1),(1566,1),(1567,1),(1568,1),(1569,1),(1570,1),(1571,1),(1572,1),(1573,1),(1574,1),(1575,1),(1576,1),(1577,1),(1578,1),(1579,1),(1580,1),(1581,1),(1582,1),(1583,1),(1584,1),(1585,1),(1586,1),(1587,1),(1588,1),(1589,1),(1590,1),(1591,1),(1592,1),(1593,1),(1594,1),(1595,1),(1596,1),(1597,1),(1598,1),(1599,1),(1600,1),(1601,1),(1602,1),(1603,1),(1604,1),(1605,1),(1606,1),(1607,1),(1608,1),(1609,1),(1610,1),(1611,1),(1612,1),(1613,1),(1614,1),(1615,1),(1616,1),(1617,1),(1618,1),(1619,1),(1620,1),(1621,1),(1622,1),(1623,1),(1624,1),(1625,1),(1626,1),(1627,1),(1628,1),(1629,1),(1630,1),(1631,1),(1632,1),(1633,1),(1634,1),(1635,1),(1636,1),(1637,1),(1638,1),(1639,1),(1640,1),(1641,1),(1642,1),(1643,1),(1644,1),(1645,1),(1646,1),(1647,1),(1648,1),(1649,1),(1650,1),(1651,1),(1652,1),(1653,1),(1654,1),(1655,1),(1656,1),(1657,1),(1658,1),(1659,1),(1660,1),(1661,1),(1662,1),(1663,1),(1664,1),(1665,1),(1666,1),(1667,1),(1668,1),(1669,1),(1670,1),(1671,1),(1672,1),(1673,1),(1674,1),(1675,1),(1676,1),(1677,1),(1678,1),(1679,1),(1680,1),(1681,1),(1682,1),(1683,1),(1684,1),(1685,1),(1686,1),(1687,1),(1688,1),(1689,1),(1690,1),(1691,1),(1692,1),(1693,1),(1694,1),(1695,1),(1696,1),(1697,1),(1698,1),(1699,1),(1700,1),(1701,1),(1702,1),(1703,1),(1704,1),(1705,1),(1706,1),(1707,1),(1708,1),(1709,1),(1710,1),(1711,1),(1712,1),(1713,1),(1714,1),(1715,1),(1716,1),(1717,1),(1718,1),(1719,1),(1720,1),(1721,1),(1722,1),(1723,1),(1724,1),(1725,1),(1726,1),(1727,1),(1728,1),(1729,1),(1730,1),(1731,1),(1732,1),(1733,1),(1734,1),(1735,1),(1736,1),(1737,1),(1738,1),(1739,1),(1740,1),(1741,1),(1742,1),(1743,1),(1744,1),(1745,1),(1746,1),(1747,1),(1748,1),(1749,1),(1750,1),(1751,1),(1752,1),(1753,1),(1754,1),(1755,1),(1756,1),(1757,1),(1758,1),(1759,1),(1760,1),(1761,1),(1762,1),(1763,1),(1764,1),(1765,1),(1766,1),(1767,1),(1768,1),(1769,1),(1770,1),(1771,1),(1772,1),(1773,1),(1774,1),(1775,1),(1776,1),(1777,1),(1778,1),(1779,1),(1780,1),(1781,1),(1782,1),(1783,1),(1784,1),(1785,1),(1786,1),(1787,1),(1788,1),(1789,1),(1790,1),(1791,1),(1792,1),(1793,1),(1794,1),(1795,1),(1796,1),(1797,1),(1798,1),(1799,1),(1800,1),(1801,1),(1802,1),(1803,1),(1804,1),(1805,1),(1806,1),(1807,1),(1808,1),(1809,1),(1810,1),(1811,1),(1812,1),(1813,1),(1814,1),(1815,1),(1816,1),(1817,1),(1818,1),(1819,1),(1820,1),(1821,1),(1822,1),(1823,1),(1824,1),(1825,1),(1826,1),(1827,1),(1828,1),(1829,1),(1830,1),(1831,1),(1832,1),(1833,1),(1834,1),(1835,1),(1836,1),(1837,1),(1838,1),(1839,1),(1840,1),(1841,1),(1842,1),(1843,1),(1844,1),(1845,1),(1846,1),(1847,1),(1848,1),(1849,1),(1850,1),(1851,1),(1852,1),(1853,1),(1854,1),(1855,1),(1856,1),(1857,1),(1858,1),(1859,1),(1860,1),(1861,1),(1862,1),(1863,1),(1864,1),(1865,1),(1866,1),(1867,1),(1868,1),(1869,1),(1870,1),(1871,1),(1872,1),(1873,1),(1874,1),(1875,1),(1876,1),(1877,1),(1878,1),(1879,1),(1880,1),(1881,1),(1882,1),(1883,1),(1884,1),(1885,1),(1886,1),(1887,1),(1888,1),(1889,1),(1890,1),(1891,1),(1892,1),(1893,1),(1894,1),(1895,1),(1896,1),(1897,1),(1898,1),(1899,1),(1900,1),(1901,1),(1902,1),(1903,1),(1904,1),(1905,1),(1906,1),(1907,1),(1908,1),(1909,1),(1910,1),(1911,1),(1912,1),(1913,1),(1914,1),(1915,1),(1916,1),(1917,1),(1918,1),(1919,1),(1920,1),(1921,1),(1922,1),(1923,1),(1924,1),(1925,1),(1926,1),(1927,1),(1928,1),(1929,1),(1930,1),(1931,1),(1932,1),(1933,1),(1934,1),(1935,1),(1936,1),(1937,1),(1938,1),(1939,1),(1940,1),(1941,1),(1942,1),(1943,1),(1944,1),(1945,1),(1946,1),(1947,1),(1948,1),(1949,1),(1950,1),(1951,1),(1952,1),(1953,1),(1954,1),(1955,1),(1956,1),(1957,1),(1958,1),(1959,1),(1960,1),(1961,1),(1962,1),(1963,1),(1964,1),(1965,1),(1966,1),(1967,1),(1968,1),(1969,1),(1970,1),(1971,1),(1972,1),(1973,1),(1974,1),(1975,1),(1976,1),(1977,1),(1978,1),(1979,1),(1980,1),(1981,1),(1982,1),(1983,1),(1984,1),(1985,1),(1986,1),(1987,1),(1988,1),(1989,1),(1990,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1991 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(2,NULL,'DUMMY',2,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(3,NULL,'DUMMY',3,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(4,NULL,'DUMMY',4,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(5,NULL,'DUMMY',5,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(6,NULL,'DUMMY',6,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(7,NULL,'DUMMY',7,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(8,NULL,'DUMMY',8,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(9,NULL,'DUMMY',9,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(10,NULL,'DUMMY',10,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(11,NULL,'DUMMY',11,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(12,NULL,'DUMMY',12,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(13,NULL,'DUMMY',13,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(14,NULL,'DUMMY',14,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(15,NULL,'DUMMY',15,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(16,NULL,'DUMMY',16,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(17,NULL,'DUMMY',17,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(18,NULL,'DUMMY',18,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(19,NULL,'DUMMY',19,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(20,NULL,'DUMMY',20,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(21,NULL,'DUMMY',21,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(22,NULL,'DUMMY',22,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(23,NULL,'DUMMY',23,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(24,NULL,'DUMMY',24,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(25,NULL,'DUMMY',25,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(26,NULL,'DUMMY',26,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(27,NULL,'DUMMY',27,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(28,NULL,'DUMMY',28,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(29,NULL,'DUMMY',29,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(30,NULL,'DUMMY',30,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(31,NULL,'DUMMY',31,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(32,NULL,'DUMMY',32,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(33,NULL,'DUMMY',33,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(34,NULL,'DUMMY',34,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(35,NULL,'DUMMY',35,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(36,NULL,'DUMMY',36,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(37,NULL,'DUMMY',37,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(38,NULL,'DUMMY',38,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(39,NULL,'DUMMY',39,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(40,NULL,'DUMMY',40,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(41,NULL,'DUMMY',41,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(42,NULL,'DUMMY',42,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(43,NULL,'DUMMY',43,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(44,NULL,'DUMMY',44,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(45,NULL,'DUMMY',45,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(46,NULL,'DUMMY',46,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(47,NULL,'DUMMY',47,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(48,NULL,'DUMMY',48,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(49,NULL,'DUMMY',49,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(50,NULL,'DUMMY',50,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(51,NULL,'DUMMY',51,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(52,NULL,'DUMMY',52,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(53,NULL,'DUMMY',53,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(54,NULL,'DUMMY',54,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(55,NULL,'DUMMY',55,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(56,NULL,'DUMMY',56,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(57,NULL,'DUMMY',57,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(58,NULL,'DUMMY',58,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(59,NULL,'DUMMY',59,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(60,NULL,'DUMMY',60,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(61,NULL,'DUMMY',61,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(62,NULL,'DUMMY',62,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(63,NULL,'DUMMY',63,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(64,NULL,'DUMMY',64,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(65,NULL,'DUMMY',65,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(66,NULL,'DUMMY',66,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(67,NULL,'DUMMY',67,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(68,NULL,'DUMMY',68,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(69,NULL,'DUMMY',69,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(70,NULL,'DUMMY',70,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(71,NULL,'DUMMY',71,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(72,NULL,'DUMMY',72,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(73,NULL,'DUMMY',73,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(74,NULL,'DUMMY',74,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(75,NULL,'DUMMY',75,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(76,NULL,'DUMMY',76,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(77,NULL,'DUMMY',77,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(78,NULL,'DUMMY',78,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(79,NULL,'DUMMY',79,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(80,NULL,'DUMMY',80,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(81,NULL,'DUMMY',81,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(82,NULL,'DUMMY',82,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(83,NULL,'DUMMY',83,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(84,NULL,'DUMMY',84,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(85,NULL,'DUMMY',85,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(86,NULL,'DUMMY',86,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(87,NULL,'DUMMY',87,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(88,NULL,'DUMMY',88,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(89,NULL,'DUMMY',89,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(90,NULL,'DUMMY',90,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(91,NULL,'DUMMY',91,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(92,NULL,'DUMMY',92,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(93,NULL,'DUMMY',93,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(94,NULL,'DUMMY',94,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(95,NULL,'DUMMY',95,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(96,NULL,'DUMMY',96,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(97,NULL,'DUMMY',97,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(98,NULL,'DUMMY',98,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(99,NULL,'DUMMY',99,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(100,NULL,'DUMMY',100,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(101,NULL,'DUMMY',101,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(102,NULL,'DUMMY',102,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(103,NULL,'DUMMY',103,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(104,NULL,'DUMMY',104,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(105,NULL,'DUMMY',105,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(106,NULL,'DUMMY',106,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(107,NULL,'DUMMY',107,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(108,NULL,'DUMMY',108,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(109,NULL,'DUMMY',109,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(110,NULL,'DUMMY',110,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(111,NULL,'DUMMY',111,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(112,NULL,'DUMMY',112,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(113,NULL,'DUMMY',113,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(114,NULL,'DUMMY',114,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(115,NULL,'DUMMY',115,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(116,NULL,'DUMMY',116,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(117,NULL,'DUMMY',117,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(118,NULL,'DUMMY',118,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(119,NULL,'DUMMY',119,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(120,NULL,'DUMMY',120,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(121,NULL,'DUMMY',121,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(122,NULL,'DUMMY',122,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(123,NULL,'DUMMY',123,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(124,NULL,'DUMMY',124,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(125,NULL,'DUMMY',125,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(126,NULL,'DUMMY',126,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(127,NULL,'DUMMY',127,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(128,NULL,'DUMMY',128,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(129,NULL,'DUMMY',129,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(130,NULL,'DUMMY',130,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(131,NULL,'DUMMY',131,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(132,NULL,'DUMMY',132,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(133,NULL,'DUMMY',133,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(134,NULL,'DUMMY',134,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(135,NULL,'DUMMY',135,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(136,NULL,'DUMMY',136,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(137,NULL,'DUMMY',137,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(138,NULL,'DUMMY',138,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(139,NULL,'DUMMY',139,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(140,NULL,'DUMMY',140,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(141,NULL,'DUMMY',141,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(142,NULL,'DUMMY',142,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(143,NULL,'DUMMY',143,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(144,NULL,'DUMMY',144,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(145,NULL,'DUMMY',145,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(146,NULL,'DUMMY',146,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(147,NULL,'DUMMY',147,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(148,NULL,'DUMMY',148,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(149,NULL,'DUMMY',149,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(150,NULL,'DUMMY',150,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(151,NULL,'DUMMY',151,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(152,NULL,'DUMMY',152,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(153,NULL,'DUMMY',153,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(154,NULL,'DUMMY',154,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(155,NULL,'DUMMY',155,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(156,NULL,'DUMMY',156,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(157,NULL,'DUMMY',157,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(158,NULL,'DUMMY',158,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(159,NULL,'DUMMY',159,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(160,NULL,'DUMMY',160,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(161,NULL,'DUMMY',161,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(162,NULL,'DUMMY',162,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(163,NULL,'DUMMY',163,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(164,NULL,'DUMMY',164,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(165,NULL,'DUMMY',165,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(166,NULL,'DUMMY',166,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(167,NULL,'DUMMY',167,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(168,NULL,'DUMMY',168,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(169,NULL,'DUMMY',169,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(170,NULL,'DUMMY',170,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(171,NULL,'DUMMY',171,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(172,NULL,'DUMMY',172,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(173,NULL,'DUMMY',173,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(174,NULL,'DUMMY',174,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(175,NULL,'DUMMY',175,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(176,NULL,'DUMMY',176,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(177,NULL,'DUMMY',177,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(178,NULL,'DUMMY',178,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(179,NULL,'DUMMY',179,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(180,NULL,'DUMMY',180,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(181,NULL,'DUMMY',181,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(182,NULL,'DUMMY',182,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(183,NULL,'DUMMY',183,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(184,NULL,'DUMMY',184,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(185,NULL,'DUMMY',185,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(186,NULL,'DUMMY',186,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(187,NULL,'DUMMY',187,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(188,NULL,'DUMMY',188,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(189,NULL,'DUMMY',189,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(190,NULL,'DUMMY',190,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(191,NULL,'DUMMY',191,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(192,NULL,'DUMMY',192,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(193,NULL,'DUMMY',193,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(194,NULL,'DUMMY',194,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(195,NULL,'DUMMY',195,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(196,NULL,'DUMMY',196,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(197,NULL,'DUMMY',197,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(198,NULL,'DUMMY',198,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(199,NULL,'DUMMY',199,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(200,NULL,'DUMMY',200,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(201,NULL,'DUMMY',201,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(202,NULL,'DUMMY',202,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(203,NULL,'DUMMY',203,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(204,NULL,'DUMMY',204,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(205,NULL,'DUMMY',205,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(206,NULL,'DUMMY',206,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(207,NULL,'DUMMY',207,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(208,NULL,'DUMMY',208,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(209,NULL,'DUMMY',209,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(210,NULL,'DUMMY',210,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(211,NULL,'DUMMY',211,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(212,NULL,'DUMMY',212,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(213,NULL,'DUMMY',213,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(214,NULL,'DUMMY',214,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(215,NULL,'DUMMY',215,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(216,NULL,'DUMMY',216,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(217,NULL,'DUMMY',217,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(218,NULL,'DUMMY',218,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(219,NULL,'DUMMY',219,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(220,NULL,'DUMMY',220,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(221,NULL,'DUMMY',221,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(222,NULL,'DUMMY',222,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(223,NULL,'DUMMY',223,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(224,NULL,'DUMMY',224,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(225,NULL,'DUMMY',225,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(226,NULL,'DUMMY',226,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(227,NULL,'DUMMY',227,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(228,NULL,'DUMMY',228,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(229,NULL,'DUMMY',229,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(230,NULL,'DUMMY',230,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(231,NULL,'DUMMY',231,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(232,NULL,'DUMMY',232,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(233,NULL,'DUMMY',233,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(234,NULL,'DUMMY',234,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(235,NULL,'DUMMY',235,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(236,NULL,'DUMMY',236,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(237,NULL,'DUMMY',237,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(238,NULL,'DUMMY',238,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(239,NULL,'DUMMY',239,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(240,NULL,'DUMMY',240,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(241,NULL,'DUMMY',241,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(242,NULL,'DUMMY',242,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(243,NULL,'DUMMY',243,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(244,NULL,'DUMMY',244,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(245,NULL,'DUMMY',245,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(246,NULL,'DUMMY',246,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(247,NULL,'DUMMY',247,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(248,NULL,'DUMMY',248,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(249,NULL,'DUMMY',249,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(250,NULL,'DUMMY',250,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(251,NULL,'DUMMY',251,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(252,NULL,'DUMMY',252,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(253,NULL,'DUMMY',253,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(254,NULL,'DUMMY',254,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(255,NULL,'DUMMY',255,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(256,NULL,'DUMMY',256,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(257,NULL,'DUMMY',257,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(258,NULL,'DUMMY',258,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(259,NULL,'DUMMY',259,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(260,NULL,'DUMMY',260,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(261,NULL,'DUMMY',261,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(262,NULL,'DUMMY',262,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(263,NULL,'DUMMY',263,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(264,NULL,'DUMMY',264,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(265,NULL,'DUMMY',265,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(266,NULL,'DUMMY',266,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(267,NULL,'DUMMY',267,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(268,NULL,'DUMMY',268,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(269,NULL,'DUMMY',269,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(270,NULL,'DUMMY',270,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(271,NULL,'DUMMY',271,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(272,NULL,'DUMMY',272,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(273,NULL,'DUMMY',273,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(274,NULL,'DUMMY',274,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(275,NULL,'DUMMY',275,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(276,NULL,'DUMMY',276,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(277,NULL,'DUMMY',277,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(278,NULL,'DUMMY',278,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(279,NULL,'DUMMY',279,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(280,NULL,'DUMMY',280,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(281,NULL,'DUMMY',281,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(282,NULL,'DUMMY',282,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(283,NULL,'DUMMY',283,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(284,NULL,'DUMMY',284,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(285,NULL,'DUMMY',285,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(286,NULL,'DUMMY',286,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(287,NULL,'DUMMY',287,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(288,NULL,'DUMMY',288,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(289,NULL,'DUMMY',289,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(290,NULL,'DUMMY',290,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(291,NULL,'DUMMY',291,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(292,NULL,'DUMMY',292,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(293,NULL,'DUMMY',293,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(294,NULL,'DUMMY',294,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(295,NULL,'DUMMY',295,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(296,NULL,'DUMMY',296,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(297,NULL,'DUMMY',297,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(298,NULL,'DUMMY',298,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(299,NULL,'DUMMY',299,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(300,NULL,'DUMMY',300,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(301,NULL,'DUMMY',301,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(302,NULL,'DUMMY',302,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(303,NULL,'DUMMY',303,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(304,NULL,'DUMMY',304,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(305,NULL,'DUMMY',305,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(306,NULL,'DUMMY',306,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(307,NULL,'DUMMY',307,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(308,NULL,'DUMMY',308,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(309,NULL,'DUMMY',309,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(310,NULL,'DUMMY',310,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(311,NULL,'DUMMY',311,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(312,NULL,'DUMMY',312,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(313,NULL,'DUMMY',313,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(314,NULL,'DUMMY',314,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(315,NULL,'DUMMY',315,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(316,NULL,'DUMMY',316,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(317,NULL,'DUMMY',317,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(318,NULL,'DUMMY',318,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(319,NULL,'DUMMY',319,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(320,NULL,'DUMMY',320,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(321,NULL,'DUMMY',321,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(322,NULL,'DUMMY',322,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(323,NULL,'DUMMY',323,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(324,NULL,'DUMMY',324,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(325,NULL,'DUMMY',325,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(326,NULL,'DUMMY',326,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(327,NULL,'DUMMY',327,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(328,NULL,'DUMMY',328,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(329,NULL,'DUMMY',329,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(330,NULL,'DUMMY',330,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(331,NULL,'DUMMY',331,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(332,NULL,'DUMMY',332,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(333,NULL,'DUMMY',333,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(334,NULL,'DUMMY',334,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(335,NULL,'DUMMY',335,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(336,NULL,'DUMMY',336,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(337,NULL,'DUMMY',337,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(338,NULL,'DUMMY',338,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(339,NULL,'DUMMY',339,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(340,NULL,'DUMMY',340,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(341,NULL,'DUMMY',341,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(342,NULL,'DUMMY',342,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(343,NULL,'DUMMY',343,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(344,NULL,'DUMMY',344,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(345,NULL,'DUMMY',345,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(346,NULL,'DUMMY',346,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(347,NULL,'DUMMY',347,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(348,NULL,'DUMMY',348,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(349,NULL,'DUMMY',349,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(350,NULL,'DUMMY',350,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(351,NULL,'DUMMY',351,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(352,NULL,'DUMMY',352,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(353,NULL,'DUMMY',353,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(354,NULL,'DUMMY',354,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(355,NULL,'DUMMY',355,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(356,NULL,'DUMMY',356,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(357,NULL,'DUMMY',357,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(358,NULL,'DUMMY',358,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(359,NULL,'DUMMY',359,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(360,NULL,'DUMMY',360,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(361,NULL,'DUMMY',361,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(362,NULL,'DUMMY',362,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(363,NULL,'DUMMY',363,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(364,NULL,'DUMMY',364,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(365,NULL,'DUMMY',365,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(366,NULL,'DUMMY',366,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(367,NULL,'DUMMY',367,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(368,NULL,'DUMMY',368,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(369,NULL,'DUMMY',369,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(370,NULL,'DUMMY',370,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(371,NULL,'DUMMY',371,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(372,NULL,'DUMMY',372,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(373,NULL,'DUMMY',373,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(374,NULL,'DUMMY',374,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(375,NULL,'DUMMY',375,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(376,NULL,'DUMMY',376,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(377,NULL,'DUMMY',377,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(378,NULL,'DUMMY',378,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(379,NULL,'DUMMY',379,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(380,NULL,'DUMMY',380,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(381,NULL,'DUMMY',381,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(382,NULL,'DUMMY',382,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(383,NULL,'DUMMY',383,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(384,NULL,'DUMMY',384,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(385,NULL,'DUMMY',385,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(386,NULL,'DUMMY',386,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(387,NULL,'DUMMY',387,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(388,NULL,'DUMMY',388,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(389,NULL,'DUMMY',389,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(390,NULL,'DUMMY',390,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(391,NULL,'DUMMY',391,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(392,NULL,'DUMMY',392,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(393,NULL,'DUMMY',393,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(394,NULL,'DUMMY',394,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(395,NULL,'DUMMY',395,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(396,NULL,'DUMMY',396,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(397,NULL,'DUMMY',397,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(398,NULL,'DUMMY',398,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(399,NULL,'DUMMY',399,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(400,NULL,'DUMMY',400,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(401,NULL,'DUMMY',401,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(402,NULL,'DUMMY',402,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(403,NULL,'DUMMY',403,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(404,NULL,'DUMMY',404,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(405,NULL,'DUMMY',405,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(406,NULL,'DUMMY',406,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(407,NULL,'DUMMY',407,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(408,NULL,'DUMMY',408,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(409,NULL,'DUMMY',409,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(410,NULL,'DUMMY',410,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(411,NULL,'DUMMY',411,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(412,NULL,'DUMMY',412,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(413,NULL,'DUMMY',413,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(414,NULL,'DUMMY',414,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(415,NULL,'DUMMY',415,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(416,NULL,'DUMMY',416,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(417,NULL,'DUMMY',417,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(418,NULL,'DUMMY',418,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(419,NULL,'DUMMY',419,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(420,NULL,'DUMMY',420,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(421,NULL,'DUMMY',421,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(422,NULL,'DUMMY',422,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(423,NULL,'DUMMY',423,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(424,NULL,'DUMMY',424,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(425,NULL,'DUMMY',425,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(426,NULL,'DUMMY',426,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(427,NULL,'DUMMY',427,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(428,NULL,'DUMMY',428,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(429,NULL,'DUMMY',429,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(430,NULL,'DUMMY',430,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(431,NULL,'DUMMY',431,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(432,NULL,'DUMMY',432,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(433,NULL,'DUMMY',433,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(434,NULL,'DUMMY',434,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(435,NULL,'DUMMY',435,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(436,NULL,'DUMMY',436,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(437,NULL,'DUMMY',437,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(438,NULL,'DUMMY',438,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(439,NULL,'DUMMY',439,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(440,NULL,'DUMMY',440,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(441,NULL,'DUMMY',441,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(442,NULL,'DUMMY',442,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(443,NULL,'DUMMY',443,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(444,NULL,'DUMMY',444,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(445,NULL,'DUMMY',445,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(446,NULL,'DUMMY',446,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(447,NULL,'DUMMY',447,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(448,NULL,'DUMMY',448,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(449,NULL,'DUMMY',449,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(450,NULL,'DUMMY',450,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(451,NULL,'DUMMY',451,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(452,NULL,'DUMMY',452,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(453,NULL,'DUMMY',453,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(454,NULL,'DUMMY',454,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(455,NULL,'DUMMY',455,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(456,NULL,'DUMMY',456,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(457,NULL,'DUMMY',457,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(458,NULL,'DUMMY',458,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(459,NULL,'DUMMY',459,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(460,NULL,'DUMMY',460,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(461,NULL,'DUMMY',461,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(462,NULL,'DUMMY',462,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(463,NULL,'DUMMY',463,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(464,NULL,'DUMMY',464,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(465,NULL,'DUMMY',465,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(466,NULL,'DUMMY',466,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(467,NULL,'DUMMY',467,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(468,NULL,'DUMMY',468,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(469,NULL,'DUMMY',469,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(470,NULL,'DUMMY',470,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(471,NULL,'DUMMY',471,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(472,NULL,'DUMMY',472,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(473,NULL,'DUMMY',473,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(474,NULL,'DUMMY',474,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(475,NULL,'DUMMY',475,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(476,NULL,'DUMMY',476,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(477,NULL,'DUMMY',477,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(478,NULL,'DUMMY',478,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(479,NULL,'DUMMY',479,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(480,NULL,'DUMMY',480,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(481,NULL,'DUMMY',481,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(482,NULL,'DUMMY',482,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(483,NULL,'DUMMY',483,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(484,NULL,'DUMMY',484,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(485,NULL,'DUMMY',485,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(486,NULL,'DUMMY',486,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(487,NULL,'DUMMY',487,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(488,NULL,'DUMMY',488,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(489,NULL,'DUMMY',489,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(490,NULL,'DUMMY',490,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(491,NULL,'DUMMY',491,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(492,NULL,'DUMMY',492,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(493,NULL,'DUMMY',493,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(494,NULL,'DUMMY',494,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(495,NULL,'DUMMY',495,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(496,NULL,'DUMMY',496,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(497,NULL,'DUMMY',497,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(498,NULL,'DUMMY',498,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(499,NULL,'DUMMY',499,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(500,NULL,'DUMMY',500,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(501,NULL,'DUMMY',501,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(502,NULL,'DUMMY',502,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(503,NULL,'DUMMY',503,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(504,NULL,'DUMMY',504,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(505,NULL,'DUMMY',505,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(506,NULL,'DUMMY',506,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(507,NULL,'DUMMY',507,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(508,NULL,'DUMMY',508,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(509,NULL,'DUMMY',509,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(510,NULL,'DUMMY',510,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(511,NULL,'DUMMY',511,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(512,NULL,'DUMMY',512,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(513,NULL,'DUMMY',513,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(514,NULL,'DUMMY',514,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(515,NULL,'DUMMY',515,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(516,NULL,'DUMMY',516,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(517,NULL,'DUMMY',517,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(518,NULL,'DUMMY',518,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(519,NULL,'DUMMY',519,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(520,NULL,'DUMMY',520,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(521,NULL,'DUMMY',521,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(522,NULL,'DUMMY',522,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(523,NULL,'DUMMY',523,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(524,NULL,'DUMMY',524,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(525,NULL,'DUMMY',525,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(526,NULL,'DUMMY',526,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(527,NULL,'DUMMY',527,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(528,NULL,'DUMMY',528,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(529,NULL,'DUMMY',529,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(530,NULL,'DUMMY',530,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(531,NULL,'DUMMY',531,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(532,NULL,'DUMMY',532,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(533,NULL,'DUMMY',533,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(534,NULL,'DUMMY',534,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(535,NULL,'DUMMY',535,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(536,NULL,'DUMMY',536,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(537,NULL,'DUMMY',537,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(538,NULL,'DUMMY',538,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(539,NULL,'DUMMY',539,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(540,NULL,'DUMMY',540,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(541,NULL,'DUMMY',541,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(542,NULL,'DUMMY',542,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(543,NULL,'DUMMY',543,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(544,NULL,'DUMMY',544,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(545,NULL,'DUMMY',545,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(546,NULL,'DUMMY',546,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(547,NULL,'DUMMY',547,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(548,NULL,'DUMMY',548,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(549,NULL,'DUMMY',549,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(550,NULL,'DUMMY',550,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(551,NULL,'DUMMY',551,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(552,NULL,'DUMMY',552,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(553,NULL,'DUMMY',553,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(554,NULL,'DUMMY',554,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(555,NULL,'DUMMY',555,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(556,NULL,'DUMMY',556,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(557,NULL,'DUMMY',557,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(558,NULL,'DUMMY',558,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(559,NULL,'DUMMY',559,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(560,NULL,'DUMMY',560,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(561,NULL,'DUMMY',561,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(562,NULL,'DUMMY',562,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(563,NULL,'DUMMY',563,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(564,NULL,'DUMMY',564,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(565,NULL,'DUMMY',565,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(566,NULL,'DUMMY',566,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(567,NULL,'DUMMY',567,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(568,NULL,'DUMMY',568,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(569,NULL,'DUMMY',569,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(570,NULL,'DUMMY',570,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(571,NULL,'DUMMY',571,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(572,NULL,'DUMMY',572,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(573,NULL,'DUMMY',573,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(574,NULL,'DUMMY',574,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(575,NULL,'DUMMY',575,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(576,NULL,'DUMMY',576,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(577,NULL,'DUMMY',577,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(578,NULL,'DUMMY',578,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(579,NULL,'DUMMY',579,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(580,NULL,'DUMMY',580,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(581,NULL,'DUMMY',581,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(582,NULL,'DUMMY',582,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(583,NULL,'DUMMY',583,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(584,NULL,'DUMMY',584,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(585,NULL,'DUMMY',585,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(586,NULL,'DUMMY',586,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(587,NULL,'DUMMY',587,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(588,NULL,'DUMMY',588,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(589,NULL,'DUMMY',589,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(590,NULL,'DUMMY',590,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(591,NULL,'DUMMY',591,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(592,NULL,'DUMMY',592,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(593,NULL,'DUMMY',593,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(594,NULL,'DUMMY',594,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(595,NULL,'DUMMY',595,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(596,NULL,'DUMMY',596,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(597,NULL,'DUMMY',597,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(598,NULL,'DUMMY',598,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(599,NULL,'DUMMY',599,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(600,NULL,'DUMMY',600,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(601,NULL,'DUMMY',601,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(602,NULL,'DUMMY',602,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(603,NULL,'DUMMY',603,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(604,NULL,'DUMMY',604,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(605,NULL,'DUMMY',605,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(606,NULL,'DUMMY',606,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(607,NULL,'DUMMY',607,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(608,NULL,'DUMMY',608,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(609,NULL,'DUMMY',609,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(610,NULL,'DUMMY',610,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(611,NULL,'DUMMY',611,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(612,NULL,'DUMMY',612,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(613,NULL,'DUMMY',613,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(614,NULL,'DUMMY',614,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(615,NULL,'DUMMY',615,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(616,NULL,'DUMMY',616,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(617,NULL,'DUMMY',617,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(618,NULL,'DUMMY',618,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(619,NULL,'DUMMY',619,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(620,NULL,'DUMMY',620,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(621,NULL,'DUMMY',621,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(622,NULL,'DUMMY',622,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(623,NULL,'DUMMY',623,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(624,NULL,'DUMMY',624,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(625,NULL,'DUMMY',625,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(626,NULL,'DUMMY',626,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(627,NULL,'DUMMY',627,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(628,NULL,'DUMMY',628,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(629,NULL,'DUMMY',629,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(630,NULL,'DUMMY',630,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(631,NULL,'DUMMY',631,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(632,NULL,'DUMMY',632,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(633,NULL,'DUMMY',633,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(634,NULL,'DUMMY',634,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(635,NULL,'DUMMY',635,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(636,NULL,'DUMMY',636,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(637,NULL,'DUMMY',637,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(638,NULL,'DUMMY',638,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(639,NULL,'DUMMY',639,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(640,NULL,'DUMMY',640,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(641,NULL,'DUMMY',641,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(642,NULL,'DUMMY',642,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(643,NULL,'DUMMY',643,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(644,NULL,'DUMMY',644,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(645,NULL,'DUMMY',645,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(646,NULL,'DUMMY',646,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(647,NULL,'DUMMY',647,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(648,NULL,'DUMMY',648,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(649,NULL,'DUMMY',649,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(650,NULL,'DUMMY',650,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(651,NULL,'DUMMY',651,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(652,NULL,'DUMMY',652,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(653,NULL,'DUMMY',653,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(654,NULL,'DUMMY',654,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(655,NULL,'DUMMY',655,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(656,NULL,'DUMMY',656,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(657,NULL,'DUMMY',657,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(658,NULL,'DUMMY',658,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(659,NULL,'DUMMY',659,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(660,NULL,'DUMMY',660,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(661,NULL,'DUMMY',661,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(662,NULL,'DUMMY',662,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(663,NULL,'DUMMY',663,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(664,NULL,'DUMMY',664,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(665,NULL,'DUMMY',665,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(666,NULL,'DUMMY',666,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(667,NULL,'DUMMY',667,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(668,NULL,'DUMMY',668,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(669,NULL,'DUMMY',669,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(670,NULL,'DUMMY',670,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(671,NULL,'DUMMY',671,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(672,NULL,'DUMMY',672,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(673,NULL,'DUMMY',673,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(674,NULL,'DUMMY',674,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(675,NULL,'DUMMY',675,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(676,NULL,'DUMMY',676,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(677,NULL,'DUMMY',677,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(678,NULL,'DUMMY',678,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(679,NULL,'DUMMY',679,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(680,NULL,'DUMMY',680,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(681,NULL,'DUMMY',681,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(682,NULL,'DUMMY',682,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(683,NULL,'DUMMY',683,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(684,NULL,'DUMMY',684,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(685,NULL,'DUMMY',685,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(686,NULL,'DUMMY',686,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(687,NULL,'DUMMY',687,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(688,NULL,'DUMMY',688,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(689,NULL,'DUMMY',689,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(690,NULL,'DUMMY',690,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(691,NULL,'DUMMY',691,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(692,NULL,'DUMMY',692,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(693,NULL,'DUMMY',693,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(694,NULL,'DUMMY',694,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(695,NULL,'DUMMY',695,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(696,NULL,'DUMMY',696,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(697,NULL,'DUMMY',697,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(698,NULL,'DUMMY',698,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(699,NULL,'DUMMY',699,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(700,NULL,'DUMMY',700,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(701,NULL,'DUMMY',701,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(702,NULL,'DUMMY',702,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(703,NULL,'DUMMY',703,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(704,NULL,'DUMMY',704,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(705,NULL,'DUMMY',705,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(706,NULL,'DUMMY',706,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(707,NULL,'DUMMY',707,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(708,NULL,'DUMMY',708,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(709,NULL,'DUMMY',709,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(710,NULL,'DUMMY',710,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(711,NULL,'DUMMY',711,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(712,NULL,'DUMMY',712,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(713,NULL,'DUMMY',713,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(714,NULL,'DUMMY',714,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(715,NULL,'DUMMY',715,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(716,NULL,'DUMMY',716,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(717,NULL,'DUMMY',717,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(718,NULL,'DUMMY',718,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(719,NULL,'DUMMY',719,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(720,NULL,'DUMMY',720,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(721,NULL,'DUMMY',721,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(722,NULL,'DUMMY',722,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(723,NULL,'DUMMY',723,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(724,NULL,'DUMMY',724,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(725,NULL,'DUMMY',725,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(726,NULL,'DUMMY',726,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(727,NULL,'DUMMY',727,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(728,NULL,'DUMMY',728,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(729,NULL,'DUMMY',729,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(730,NULL,'DUMMY',730,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(731,NULL,'DUMMY',731,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(732,NULL,'DUMMY',732,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(733,NULL,'DUMMY',733,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(734,NULL,'DUMMY',734,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(735,NULL,'DUMMY',735,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(736,NULL,'DUMMY',736,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(737,NULL,'DUMMY',737,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(738,NULL,'DUMMY',738,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(739,NULL,'DUMMY',739,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(740,NULL,'DUMMY',740,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(741,NULL,'DUMMY',741,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(742,NULL,'DUMMY',742,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(743,NULL,'DUMMY',743,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(744,NULL,'DUMMY',744,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(745,NULL,'DUMMY',745,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(746,NULL,'DUMMY',746,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(747,NULL,'DUMMY',747,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(748,NULL,'DUMMY',748,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(749,NULL,'DUMMY',749,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(750,NULL,'DUMMY',750,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(751,NULL,'DUMMY',751,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(752,NULL,'DUMMY',752,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(753,NULL,'DUMMY',753,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(754,NULL,'DUMMY',754,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(755,NULL,'DUMMY',755,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(756,NULL,'DUMMY',756,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(757,NULL,'DUMMY',757,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(758,NULL,'DUMMY',758,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(759,NULL,'DUMMY',759,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(760,NULL,'DUMMY',760,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(761,NULL,'DUMMY',761,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(762,NULL,'DUMMY',762,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(763,NULL,'DUMMY',763,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(764,NULL,'DUMMY',764,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(765,NULL,'DUMMY',765,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(766,NULL,'DUMMY',766,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(767,NULL,'DUMMY',767,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(768,NULL,'DUMMY',768,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(769,NULL,'DUMMY',769,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(770,NULL,'DUMMY',770,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(771,NULL,'DUMMY',771,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(772,NULL,'DUMMY',772,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(773,NULL,'DUMMY',773,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(774,NULL,'DUMMY',774,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(775,NULL,'DUMMY',775,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(776,NULL,'DUMMY',776,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(777,NULL,'DUMMY',777,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(778,NULL,'DUMMY',778,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(779,NULL,'DUMMY',779,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(780,NULL,'DUMMY',780,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(781,NULL,'DUMMY',781,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(782,NULL,'DUMMY',782,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(783,NULL,'DUMMY',783,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(784,NULL,'DUMMY',784,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(785,NULL,'DUMMY',785,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(786,NULL,'DUMMY',786,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(787,NULL,'DUMMY',787,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(788,NULL,'DUMMY',788,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(789,NULL,'DUMMY',789,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(790,NULL,'DUMMY',790,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(791,NULL,'DUMMY',791,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(792,NULL,'DUMMY',792,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(793,NULL,'DUMMY',793,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(794,NULL,'DUMMY',794,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(795,NULL,'DUMMY',795,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(796,NULL,'DUMMY',796,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(797,NULL,'DUMMY',797,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(798,NULL,'DUMMY',798,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(799,NULL,'DUMMY',799,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(800,NULL,'DUMMY',800,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(801,NULL,'DUMMY',801,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(802,NULL,'DUMMY',802,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(803,NULL,'DUMMY',803,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(804,NULL,'DUMMY',804,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(805,NULL,'DUMMY',805,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(806,NULL,'DUMMY',806,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(807,NULL,'DUMMY',807,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(808,NULL,'DUMMY',808,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(809,NULL,'DUMMY',809,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(810,NULL,'DUMMY',810,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(811,NULL,'DUMMY',811,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(812,NULL,'DUMMY',812,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(813,NULL,'DUMMY',813,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(814,NULL,'DUMMY',814,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(815,NULL,'DUMMY',815,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(816,NULL,'DUMMY',816,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(817,NULL,'DUMMY',817,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(818,NULL,'DUMMY',818,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(819,NULL,'DUMMY',819,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(820,NULL,'DUMMY',820,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(821,NULL,'DUMMY',821,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(822,NULL,'DUMMY',822,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(823,NULL,'DUMMY',823,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(824,NULL,'DUMMY',824,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(825,NULL,'DUMMY',825,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(826,NULL,'DUMMY',826,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(827,NULL,'DUMMY',827,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(828,NULL,'DUMMY',828,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(829,NULL,'DUMMY',829,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(830,NULL,'DUMMY',830,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(831,NULL,'DUMMY',831,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(832,NULL,'DUMMY',832,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(833,NULL,'DUMMY',833,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(834,NULL,'DUMMY',834,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(835,NULL,'DUMMY',835,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(836,NULL,'DUMMY',836,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(837,NULL,'DUMMY',837,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(838,NULL,'DUMMY',838,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(839,NULL,'DUMMY',839,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(840,NULL,'DUMMY',840,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(841,NULL,'DUMMY',841,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(842,NULL,'DUMMY',842,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(843,NULL,'DUMMY',843,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(844,NULL,'DUMMY',844,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(845,NULL,'DUMMY',845,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(846,NULL,'DUMMY',846,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(847,NULL,'DUMMY',847,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(848,NULL,'DUMMY',848,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(849,NULL,'DUMMY',849,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(850,NULL,'DUMMY',850,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(851,NULL,'DUMMY',851,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(852,NULL,'DUMMY',852,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(853,NULL,'DUMMY',853,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(854,NULL,'DUMMY',854,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(855,NULL,'DUMMY',855,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(856,NULL,'DUMMY',856,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(857,NULL,'DUMMY',857,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(858,NULL,'DUMMY',858,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(859,NULL,'DUMMY',859,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(860,NULL,'DUMMY',860,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(861,NULL,'DUMMY',861,1,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(862,NULL,'DUMMY',862,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(863,NULL,'DUMMY',863,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(864,NULL,'DUMMY',864,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(865,NULL,'DUMMY',865,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(866,NULL,'DUMMY',866,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(867,NULL,'DUMMY',867,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(868,NULL,'DUMMY',868,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(869,NULL,'DUMMY',869,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(870,NULL,'DUMMY',870,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(871,NULL,'DUMMY',871,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(872,NULL,'DUMMY',872,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(873,NULL,'DUMMY',873,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(874,NULL,'DUMMY',874,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(875,NULL,'DUMMY',875,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(876,NULL,'DUMMY',876,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(877,NULL,'DUMMY',877,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(878,NULL,'DUMMY',878,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(879,NULL,'DUMMY',879,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(880,NULL,'DUMMY',880,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(881,NULL,'DUMMY',881,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(882,NULL,'DUMMY',882,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(883,NULL,'DUMMY',883,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(884,NULL,'DUMMY',884,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(885,NULL,'DUMMY',885,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(886,NULL,'DUMMY',886,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(887,NULL,'DUMMY',887,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(888,NULL,'DUMMY',888,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(889,NULL,'DUMMY',889,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(890,NULL,'DUMMY',890,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(891,NULL,'DUMMY',891,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(892,NULL,'DUMMY',892,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(893,NULL,'DUMMY',893,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(894,NULL,'DUMMY',894,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(895,NULL,'DUMMY',895,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(896,NULL,'DUMMY',896,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(897,NULL,'DUMMY',897,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(898,NULL,'DUMMY',898,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(899,NULL,'DUMMY',899,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(900,NULL,'DUMMY',900,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(901,NULL,'DUMMY',901,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(902,NULL,'DUMMY',902,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(903,NULL,'DUMMY',903,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(904,NULL,'DUMMY',904,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(905,NULL,'DUMMY',905,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(906,NULL,'DUMMY',906,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(907,NULL,'DUMMY',907,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(908,NULL,'DUMMY',908,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(909,NULL,'DUMMY',909,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(910,NULL,'DUMMY',910,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(911,NULL,'DUMMY',911,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(912,NULL,'DUMMY',912,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(913,NULL,'DUMMY',913,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(914,NULL,'DUMMY',914,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(915,NULL,'DUMMY',915,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(916,NULL,'DUMMY',916,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(917,NULL,'DUMMY',917,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(918,NULL,'DUMMY',918,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(919,NULL,'DUMMY',919,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(920,NULL,'DUMMY',920,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(921,NULL,'DUMMY',921,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(922,NULL,'DUMMY',922,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(923,NULL,'DUMMY',923,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(924,NULL,'DUMMY',924,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(925,NULL,'DUMMY',925,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(926,NULL,'DUMMY',926,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(927,NULL,'DUMMY',927,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(928,NULL,'DUMMY',928,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(929,NULL,'DUMMY',929,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(930,NULL,'DUMMY',930,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(931,NULL,'DUMMY',931,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(932,NULL,'DUMMY',932,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(933,NULL,'DUMMY',933,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(934,NULL,'DUMMY',934,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(935,NULL,'DUMMY',935,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(936,NULL,'DUMMY',936,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(937,NULL,'DUMMY',937,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(938,NULL,'DUMMY',938,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(939,NULL,'DUMMY',939,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(940,NULL,'DUMMY',940,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(941,NULL,'DUMMY',941,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(942,NULL,'DUMMY',942,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(943,NULL,'DUMMY',943,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(944,NULL,'DUMMY',944,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(945,NULL,'DUMMY',945,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(946,NULL,'DUMMY',946,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(947,NULL,'DUMMY',947,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(948,NULL,'DUMMY',948,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(949,NULL,'DUMMY',949,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(950,NULL,'DUMMY',950,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(951,NULL,'DUMMY',951,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(952,NULL,'DUMMY',952,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(953,NULL,'DUMMY',953,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(954,NULL,'DUMMY',954,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(955,NULL,'DUMMY',955,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(956,NULL,'DUMMY',956,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(957,NULL,'DUMMY',957,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(958,NULL,'DUMMY',958,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(959,NULL,'DUMMY',959,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(960,NULL,'DUMMY',960,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(961,NULL,'DUMMY',961,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(962,NULL,'DUMMY',962,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(963,NULL,'DUMMY',963,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(964,NULL,'DUMMY',964,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(965,NULL,'DUMMY',965,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(966,NULL,'DUMMY',966,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(967,NULL,'DUMMY',967,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(968,NULL,'DUMMY',968,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(969,NULL,'DUMMY',969,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(970,NULL,'DUMMY',970,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(971,NULL,'DUMMY',971,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(972,NULL,'DUMMY',972,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(973,NULL,'DUMMY',973,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(974,NULL,'DUMMY',974,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(975,NULL,'DUMMY',975,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(976,NULL,'DUMMY',976,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(977,NULL,'DUMMY',977,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(978,NULL,'DUMMY',978,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(979,NULL,'DUMMY',979,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(980,NULL,'DUMMY',980,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(981,NULL,'DUMMY',981,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(982,NULL,'DUMMY',982,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(983,NULL,'DUMMY',983,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(984,NULL,'DUMMY',984,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(985,NULL,'DUMMY',985,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(986,NULL,'DUMMY',986,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(987,NULL,'DUMMY',987,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(988,NULL,'DUMMY',988,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(989,NULL,'DUMMY',989,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(990,NULL,'DUMMY',990,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(991,NULL,'DUMMY',991,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(992,NULL,'DUMMY',992,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(993,NULL,'DUMMY',993,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(994,NULL,'DUMMY',994,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(995,NULL,'DUMMY',995,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(996,NULL,'DUMMY',996,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(997,NULL,'DUMMY',997,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(998,NULL,'DUMMY',998,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(999,NULL,'DUMMY',999,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1000,NULL,'DUMMY',1000,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1001,NULL,'DUMMY',1001,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1002,NULL,'DUMMY',1002,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1003,NULL,'DUMMY',1003,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1004,NULL,'DUMMY',1004,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1005,NULL,'DUMMY',1005,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1006,NULL,'DUMMY',1006,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1007,NULL,'DUMMY',1007,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1008,NULL,'DUMMY',1008,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1009,NULL,'DUMMY',1009,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1010,NULL,'DUMMY',1010,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1011,NULL,'DUMMY',1011,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1012,NULL,'DUMMY',1012,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1013,NULL,'DUMMY',1013,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1014,NULL,'DUMMY',1014,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1015,NULL,'DUMMY',1015,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1016,NULL,'DUMMY',1016,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1017,NULL,'DUMMY',1017,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1018,NULL,'DUMMY',1018,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1019,NULL,'DUMMY',1019,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1020,NULL,'DUMMY',1020,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1021,NULL,'DUMMY',1021,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1022,NULL,'DUMMY',1022,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1023,NULL,'DUMMY',1023,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1024,NULL,'DUMMY',1024,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1025,NULL,'DUMMY',1025,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1026,NULL,'DUMMY',1026,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1027,NULL,'DUMMY',1027,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1028,NULL,'DUMMY',1028,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1029,NULL,'DUMMY',1029,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1030,NULL,'DUMMY',1030,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1031,NULL,'DUMMY',1031,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1032,NULL,'DUMMY',1032,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1033,NULL,'DUMMY',1033,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1034,NULL,'DUMMY',1034,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1035,NULL,'DUMMY',1035,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1036,NULL,'DUMMY',1036,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1037,NULL,'DUMMY',1037,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1038,NULL,'DUMMY',1038,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1039,NULL,'DUMMY',1039,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1040,NULL,'DUMMY',1040,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1041,NULL,'DUMMY',1041,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1042,NULL,'DUMMY',1042,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1043,NULL,'DUMMY',1043,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1044,NULL,'DUMMY',1044,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1045,NULL,'DUMMY',1045,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1046,NULL,'DUMMY',1046,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1047,NULL,'DUMMY',1047,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1048,NULL,'DUMMY',1048,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1049,NULL,'DUMMY',1049,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1050,NULL,'DUMMY',1050,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1051,NULL,'DUMMY',1051,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1052,NULL,'DUMMY',1052,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1053,NULL,'DUMMY',1053,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1054,NULL,'DUMMY',1054,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1055,NULL,'DUMMY',1055,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1056,NULL,'DUMMY',1056,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1057,NULL,'DUMMY',1057,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1058,NULL,'DUMMY',1058,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1059,NULL,'DUMMY',1059,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1060,NULL,'DUMMY',1060,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1061,NULL,'DUMMY',1061,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1062,NULL,'DUMMY',1062,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1063,NULL,'DUMMY',1063,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1064,NULL,'DUMMY',1064,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1065,NULL,'DUMMY',1065,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1066,NULL,'DUMMY',1066,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1067,NULL,'DUMMY',1067,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1068,NULL,'DUMMY',1068,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1069,NULL,'DUMMY',1069,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1070,NULL,'DUMMY',1070,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1071,NULL,'DUMMY',1071,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1072,NULL,'DUMMY',1072,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1073,NULL,'DUMMY',1073,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1074,NULL,'DUMMY',1074,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1075,NULL,'DUMMY',1075,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1076,NULL,'DUMMY',1076,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1077,NULL,'DUMMY',1077,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1078,NULL,'DUMMY',1078,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1079,NULL,'DUMMY',1079,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1080,NULL,'DUMMY',1080,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1081,NULL,'DUMMY',1081,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1082,NULL,'DUMMY',1082,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1083,NULL,'DUMMY',1083,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1084,NULL,'DUMMY',1084,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1085,NULL,'DUMMY',1085,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1086,NULL,'DUMMY',1086,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1087,NULL,'DUMMY',1087,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1088,NULL,'DUMMY',1088,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1089,NULL,'DUMMY',1089,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1090,NULL,'DUMMY',1090,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1091,NULL,'DUMMY',1091,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1092,NULL,'DUMMY',1092,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1093,NULL,'DUMMY',1093,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1094,NULL,'DUMMY',1094,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1095,NULL,'DUMMY',1095,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1096,NULL,'DUMMY',1096,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1097,NULL,'DUMMY',1097,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1098,NULL,'DUMMY',1098,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1099,NULL,'DUMMY',1099,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1100,NULL,'DUMMY',1100,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1101,NULL,'DUMMY',1101,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1102,NULL,'DUMMY',1102,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1103,NULL,'DUMMY',1103,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1104,NULL,'DUMMY',1104,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1105,NULL,'DUMMY',1105,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1106,NULL,'DUMMY',1106,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1107,NULL,'DUMMY',1107,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1108,NULL,'DUMMY',1108,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1109,NULL,'DUMMY',1109,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1110,NULL,'DUMMY',1110,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1111,NULL,'DUMMY',1111,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1112,NULL,'DUMMY',1112,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1113,NULL,'DUMMY',1113,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1114,NULL,'DUMMY',1114,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1115,NULL,'DUMMY',1115,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1116,NULL,'DUMMY',1116,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1117,NULL,'DUMMY',1117,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1118,NULL,'DUMMY',1118,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1119,NULL,'DUMMY',1119,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1120,NULL,'DUMMY',1120,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1121,NULL,'DUMMY',1121,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1122,NULL,'DUMMY',1122,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1123,NULL,'DUMMY',1123,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1124,NULL,'DUMMY',1124,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1125,NULL,'DUMMY',1125,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1126,NULL,'DUMMY',1126,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1127,NULL,'DUMMY',1127,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1128,NULL,'DUMMY',1128,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1129,NULL,'DUMMY',1129,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1130,NULL,'DUMMY',1130,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1131,NULL,'DUMMY',1131,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1132,NULL,'DUMMY',1132,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1133,NULL,'DUMMY',1133,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1134,NULL,'DUMMY',1134,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1135,NULL,'DUMMY',1135,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1136,NULL,'DUMMY',1136,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1137,NULL,'DUMMY',1137,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1138,NULL,'DUMMY',1138,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1139,NULL,'DUMMY',1139,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1140,NULL,'DUMMY',1140,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1141,NULL,'DUMMY',1141,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1142,NULL,'DUMMY',1142,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1143,NULL,'DUMMY',1143,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1144,NULL,'DUMMY',1144,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1145,NULL,'DUMMY',1145,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1146,NULL,'DUMMY',1146,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1147,NULL,'DUMMY',1147,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1148,NULL,'DUMMY',1148,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1149,NULL,'DUMMY',1149,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1150,NULL,'DUMMY',1150,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1151,NULL,'DUMMY',1151,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1152,NULL,'DUMMY',1152,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1153,NULL,'DUMMY',1153,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1154,NULL,'DUMMY',1154,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1155,NULL,'DUMMY',1155,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1156,NULL,'DUMMY',1156,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1157,NULL,'DUMMY',1157,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1158,NULL,'DUMMY',1158,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1159,NULL,'DUMMY',1159,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1160,NULL,'DUMMY',1160,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1161,NULL,'DUMMY',1161,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1162,NULL,'DUMMY',1162,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1163,NULL,'DUMMY',1163,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1164,NULL,'DUMMY',1164,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1165,NULL,'DUMMY',1165,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1166,NULL,'DUMMY',1166,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1167,NULL,'DUMMY',1167,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1168,NULL,'DUMMY',1168,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1169,NULL,'DUMMY',1169,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1170,NULL,'DUMMY',1170,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1171,NULL,'DUMMY',1171,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1172,NULL,'DUMMY',1172,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1173,NULL,'DUMMY',1173,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1174,NULL,'DUMMY',1174,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1175,NULL,'DUMMY',1175,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1176,NULL,'DUMMY',1176,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1177,NULL,'DUMMY',1177,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1178,NULL,'DUMMY',1178,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1179,NULL,'DUMMY',1179,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1180,NULL,'DUMMY',1180,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1181,NULL,'DUMMY',1181,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1182,NULL,'DUMMY',1182,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1183,NULL,'DUMMY',1183,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1184,NULL,'DUMMY',1184,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1185,NULL,'DUMMY',1185,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1186,NULL,'DUMMY',1186,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1187,NULL,'DUMMY',1187,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1188,NULL,'DUMMY',1188,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1189,NULL,'DUMMY',1189,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1190,NULL,'DUMMY',1190,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1191,NULL,'DUMMY',1191,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1192,NULL,'DUMMY',1192,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1193,NULL,'DUMMY',1193,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1194,NULL,'DUMMY',1194,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1195,NULL,'DUMMY',1195,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1196,NULL,'DUMMY',1196,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1197,NULL,'DUMMY',1197,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1198,NULL,'DUMMY',1198,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1199,NULL,'DUMMY',1199,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1200,NULL,'DUMMY',1200,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1201,NULL,'DUMMY',1201,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1202,NULL,'DUMMY',1202,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1203,NULL,'DUMMY',1203,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1204,NULL,'DUMMY',1204,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1205,NULL,'DUMMY',1205,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1206,NULL,'DUMMY',1206,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1207,NULL,'DUMMY',1207,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1208,NULL,'DUMMY',1208,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1209,NULL,'DUMMY',1209,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1210,NULL,'DUMMY',1210,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1211,NULL,'DUMMY',1211,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1212,NULL,'DUMMY',1212,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1213,NULL,'DUMMY',1213,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1214,NULL,'DUMMY',1214,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1215,NULL,'DUMMY',1215,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1216,NULL,'DUMMY',1216,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1217,NULL,'DUMMY',1217,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1218,NULL,'DUMMY',1218,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1219,NULL,'DUMMY',1219,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1220,NULL,'DUMMY',1220,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1221,NULL,'DUMMY',1221,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1222,NULL,'DUMMY',1222,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1223,NULL,'DUMMY',1223,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1224,NULL,'DUMMY',1224,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1225,NULL,'DUMMY',1225,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1226,NULL,'DUMMY',1226,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1227,NULL,'DUMMY',1227,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1228,NULL,'DUMMY',1228,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1229,NULL,'DUMMY',1229,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1230,NULL,'DUMMY',1230,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1231,NULL,'DUMMY',1231,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1232,NULL,'DUMMY',1232,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1233,NULL,'DUMMY',1233,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1234,NULL,'DUMMY',1234,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1235,NULL,'DUMMY',1235,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1236,NULL,'DUMMY',1236,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1237,NULL,'DUMMY',1237,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1238,NULL,'DUMMY',1238,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1239,NULL,'DUMMY',1239,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1240,NULL,'DUMMY',1240,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1241,NULL,'DUMMY',1241,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1242,NULL,'DUMMY',1242,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1243,NULL,'DUMMY',1243,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1244,NULL,'DUMMY',1244,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1245,NULL,'DUMMY',1245,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1246,NULL,'DUMMY',1246,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1247,NULL,'DUMMY',1247,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1248,NULL,'DUMMY',1248,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1249,NULL,'DUMMY',1249,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1250,NULL,'DUMMY',1250,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1251,NULL,'DUMMY',1251,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1252,NULL,'DUMMY',1252,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1253,NULL,'DUMMY',1253,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1254,NULL,'DUMMY',1254,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1255,NULL,'DUMMY',1255,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1256,NULL,'DUMMY',1256,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1257,NULL,'DUMMY',1257,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1258,NULL,'DUMMY',1258,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1259,NULL,'DUMMY',1259,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1260,NULL,'DUMMY',1260,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1261,NULL,'DUMMY',1261,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1262,NULL,'DUMMY',1262,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1263,NULL,'DUMMY',1263,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1264,NULL,'DUMMY',1264,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1265,NULL,'DUMMY',1265,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1266,NULL,'DUMMY',1266,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1267,NULL,'DUMMY',1267,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1268,NULL,'DUMMY',1268,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1269,NULL,'DUMMY',1269,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1270,NULL,'DUMMY',1270,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1271,NULL,'DUMMY',1271,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1272,NULL,'DUMMY',1272,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1273,NULL,'DUMMY',1273,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1274,NULL,'DUMMY',1274,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1275,NULL,'DUMMY',1275,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1276,NULL,'DUMMY',1276,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1277,NULL,'DUMMY',1277,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1278,NULL,'DUMMY',1278,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1279,NULL,'DUMMY',1279,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1280,NULL,'DUMMY',1280,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1281,NULL,'DUMMY',1281,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1282,NULL,'DUMMY',1282,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1283,NULL,'DUMMY',1283,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1284,NULL,'DUMMY',1284,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1285,NULL,'DUMMY',1285,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1286,NULL,'DUMMY',1286,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1287,NULL,'DUMMY',1287,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1288,NULL,'DUMMY',1288,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1289,NULL,'DUMMY',1289,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1290,NULL,'DUMMY',1290,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1291,NULL,'DUMMY',1291,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1292,NULL,'DUMMY',1292,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1293,NULL,'DUMMY',1293,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1294,NULL,'DUMMY',1294,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1295,NULL,'DUMMY',1295,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1296,NULL,'DUMMY',1296,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1297,NULL,'DUMMY',1297,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1298,NULL,'DUMMY',1298,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1299,NULL,'DUMMY',1299,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1300,NULL,'DUMMY',1300,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1301,NULL,'DUMMY',1301,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1302,NULL,'DUMMY',1302,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1303,NULL,'DUMMY',1303,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1304,NULL,'DUMMY',1304,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1305,NULL,'DUMMY',1305,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1306,NULL,'DUMMY',1306,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1307,NULL,'DUMMY',1307,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1308,NULL,'DUMMY',1308,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1309,NULL,'DUMMY',1309,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1310,NULL,'DUMMY',1310,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1311,NULL,'DUMMY',1311,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1312,NULL,'DUMMY',1312,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1313,NULL,'DUMMY',1313,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1314,NULL,'DUMMY',1314,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1315,NULL,'DUMMY',1315,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1316,NULL,'DUMMY',1316,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1317,NULL,'DUMMY',1317,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1318,NULL,'DUMMY',1318,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1319,NULL,'DUMMY',1319,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1320,NULL,'DUMMY',1320,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1321,NULL,'DUMMY',1321,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1322,NULL,'DUMMY',1322,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1323,NULL,'DUMMY',1323,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1324,NULL,'DUMMY',1324,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1325,NULL,'DUMMY',1325,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1326,NULL,'DUMMY',1326,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1327,NULL,'DUMMY',1327,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1328,NULL,'DUMMY',1328,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1329,NULL,'DUMMY',1329,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1330,NULL,'DUMMY',1330,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1331,NULL,'DUMMY',1331,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1332,NULL,'DUMMY',1332,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1333,NULL,'DUMMY',1333,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1334,NULL,'DUMMY',1334,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1335,NULL,'DUMMY',1335,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1336,NULL,'DUMMY',1336,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1337,NULL,'DUMMY',1337,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1338,NULL,'DUMMY',1338,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1339,NULL,'DUMMY',1339,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1340,NULL,'DUMMY',1340,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1341,NULL,'DUMMY',1341,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1342,NULL,'DUMMY',1342,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1343,NULL,'DUMMY',1343,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1344,NULL,'DUMMY',1344,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1345,NULL,'DUMMY',1345,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1346,NULL,'DUMMY',1346,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1347,NULL,'DUMMY',1347,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1348,NULL,'DUMMY',1348,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1349,NULL,'DUMMY',1349,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1350,NULL,'DUMMY',1350,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1351,NULL,'DUMMY',1351,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1352,NULL,'DUMMY',1352,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1353,NULL,'DUMMY',1353,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1354,NULL,'DUMMY',1354,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1355,NULL,'DUMMY',1355,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1356,NULL,'DUMMY',1356,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1357,NULL,'DUMMY',1357,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1358,NULL,'DUMMY',1358,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1359,NULL,'DUMMY',1359,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1360,NULL,'DUMMY',1360,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1361,NULL,'DUMMY',1361,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1362,NULL,'DUMMY',1362,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1363,NULL,'DUMMY',1363,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1364,NULL,'DUMMY',1364,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1365,NULL,'DUMMY',1365,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1366,NULL,'DUMMY',1366,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1367,NULL,'DUMMY',1367,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1368,NULL,'DUMMY',1368,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1369,NULL,'DUMMY',1369,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1370,NULL,'DUMMY',1370,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1371,NULL,'DUMMY',1371,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1372,NULL,'DUMMY',1372,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1373,NULL,'DUMMY',1373,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1374,NULL,'DUMMY',1374,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1375,NULL,'DUMMY',1375,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1376,NULL,'DUMMY',1376,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1377,NULL,'DUMMY',1377,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1378,NULL,'DUMMY',1378,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1379,NULL,'DUMMY',1379,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1380,NULL,'DUMMY',1380,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1381,NULL,'DUMMY',1381,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1382,NULL,'DUMMY',1382,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1383,NULL,'DUMMY',1383,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1384,NULL,'DUMMY',1384,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1385,NULL,'DUMMY',1385,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1386,NULL,'DUMMY',1386,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1387,NULL,'DUMMY',1387,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1388,NULL,'DUMMY',1388,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1389,NULL,'DUMMY',1389,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1390,NULL,'DUMMY',1390,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1391,NULL,'DUMMY',1391,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1392,NULL,'DUMMY',1392,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1393,NULL,'DUMMY',1393,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1394,NULL,'DUMMY',1394,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1395,NULL,'DUMMY',1395,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1396,NULL,'DUMMY',1396,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1397,NULL,'DUMMY',1397,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1398,NULL,'DUMMY',1398,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1399,NULL,'DUMMY',1399,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1400,NULL,'DUMMY',1400,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1401,NULL,'DUMMY',1401,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1402,NULL,'DUMMY',1402,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1403,NULL,'DUMMY',1403,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1404,NULL,'DUMMY',1404,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1405,NULL,'DUMMY',1405,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1406,NULL,'DUMMY',1406,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1407,NULL,'DUMMY',1407,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1408,NULL,'DUMMY',1408,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1409,NULL,'DUMMY',1409,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1410,NULL,'DUMMY',1410,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1411,NULL,'DUMMY',1411,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1412,NULL,'DUMMY',1412,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1413,NULL,'DUMMY',1413,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1414,NULL,'DUMMY',1414,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1415,NULL,'DUMMY',1415,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1416,NULL,'DUMMY',1416,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1417,NULL,'DUMMY',1417,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1418,NULL,'DUMMY',1418,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1419,NULL,'DUMMY',1419,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1420,NULL,'DUMMY',1420,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1421,NULL,'DUMMY',1421,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1422,NULL,'DUMMY',1422,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1423,NULL,'DUMMY',1423,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1424,NULL,'DUMMY',1424,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1425,NULL,'DUMMY',1425,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1426,NULL,'DUMMY',1426,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1427,NULL,'DUMMY',1427,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1428,NULL,'DUMMY',1428,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1429,NULL,'DUMMY',1429,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1430,NULL,'DUMMY',1430,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1431,NULL,'DUMMY',1431,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1432,NULL,'DUMMY',1432,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1433,NULL,'DUMMY',1433,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1434,NULL,'DUMMY',1434,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1435,NULL,'DUMMY',1435,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1436,NULL,'DUMMY',1436,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1437,NULL,'DUMMY',1437,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1438,NULL,'DUMMY',1438,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1439,NULL,'DUMMY',1439,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1440,NULL,'DUMMY',1440,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1441,NULL,'DUMMY',1441,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1442,NULL,'DUMMY',1442,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1443,NULL,'DUMMY',1443,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1444,NULL,'DUMMY',1444,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1445,NULL,'DUMMY',1445,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1446,NULL,'DUMMY',1446,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1447,NULL,'DUMMY',1447,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1448,NULL,'DUMMY',1448,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1449,NULL,'DUMMY',1449,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1450,NULL,'DUMMY',1450,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1451,NULL,'DUMMY',1451,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1452,NULL,'DUMMY',1452,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1453,NULL,'DUMMY',1453,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1454,NULL,'DUMMY',1454,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1455,NULL,'DUMMY',1455,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1456,NULL,'DUMMY',1456,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1457,NULL,'DUMMY',1457,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1458,NULL,'DUMMY',1458,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1459,NULL,'DUMMY',1459,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1460,NULL,'DUMMY',1460,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1461,NULL,'DUMMY',1461,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1462,NULL,'DUMMY',1462,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1463,NULL,'DUMMY',1463,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1464,NULL,'DUMMY',1464,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1465,NULL,'DUMMY',1465,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1466,NULL,'DUMMY',1466,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1467,NULL,'DUMMY',1467,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1468,NULL,'DUMMY',1468,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1469,NULL,'DUMMY',1469,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1470,NULL,'DUMMY',1470,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1471,NULL,'DUMMY',1471,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1472,NULL,'DUMMY',1472,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1473,NULL,'DUMMY',1473,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1474,NULL,'DUMMY',1474,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1475,NULL,'DUMMY',1475,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1476,NULL,'DUMMY',1476,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1477,NULL,'DUMMY',1477,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1478,NULL,'DUMMY',1478,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1479,NULL,'DUMMY',1479,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1480,NULL,'DUMMY',1480,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1481,NULL,'DUMMY',1481,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1482,NULL,'DUMMY',1482,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1483,NULL,'DUMMY',1483,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1484,NULL,'DUMMY',1484,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1485,NULL,'DUMMY',1485,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1486,NULL,'DUMMY',1486,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1487,NULL,'DUMMY',1487,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1488,NULL,'DUMMY',1488,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1489,NULL,'DUMMY',1489,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1490,NULL,'DUMMY',1490,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1491,NULL,'DUMMY',1491,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1492,NULL,'DUMMY',1492,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1493,NULL,'DUMMY',1493,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1494,NULL,'DUMMY',1494,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1495,NULL,'DUMMY',1495,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1496,NULL,'DUMMY',1496,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1497,NULL,'DUMMY',1497,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1498,NULL,'DUMMY',1498,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1499,NULL,'DUMMY',1499,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1500,NULL,'DUMMY',1500,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1501,NULL,'DUMMY',1501,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1502,NULL,'DUMMY',1502,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1503,NULL,'DUMMY',1503,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1504,NULL,'DUMMY',1504,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1505,NULL,'DUMMY',1505,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1506,NULL,'DUMMY',1506,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1507,NULL,'DUMMY',1507,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1508,NULL,'DUMMY',1508,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1509,NULL,'DUMMY',1509,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1510,NULL,'DUMMY',1510,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1511,NULL,'DUMMY',1511,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1512,NULL,'DUMMY',1512,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1513,NULL,'DUMMY',1513,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1514,NULL,'DUMMY',1514,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1515,NULL,'DUMMY',1515,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1516,NULL,'DUMMY',1516,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1517,NULL,'DUMMY',1517,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1518,NULL,'DUMMY',1518,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1519,NULL,'DUMMY',1519,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1520,NULL,'DUMMY',1520,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1521,NULL,'DUMMY',1521,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1522,NULL,'DUMMY',1522,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1523,NULL,'DUMMY',1523,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1524,NULL,'DUMMY',1524,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1525,NULL,'DUMMY',1525,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1526,NULL,'DUMMY',1526,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1527,NULL,'DUMMY',1527,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1528,NULL,'DUMMY',1528,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1529,NULL,'DUMMY',1529,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1530,NULL,'DUMMY',1530,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1531,NULL,'DUMMY',1531,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1532,NULL,'DUMMY',1532,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1533,NULL,'DUMMY',1533,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1534,NULL,'DUMMY',1534,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1535,NULL,'DUMMY',1535,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1536,NULL,'DUMMY',1536,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1537,NULL,'DUMMY',1537,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1538,NULL,'DUMMY',1538,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1539,NULL,'DUMMY',1539,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1540,NULL,'DUMMY',1540,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1541,NULL,'DUMMY',1541,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1542,NULL,'DUMMY',1542,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1543,NULL,'DUMMY',1543,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1544,NULL,'DUMMY',1544,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1545,NULL,'DUMMY',1545,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1546,NULL,'DUMMY',1546,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1547,NULL,'DUMMY',1547,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1548,NULL,'DUMMY',1548,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1549,NULL,'DUMMY',1549,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1550,NULL,'DUMMY',1550,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1551,NULL,'DUMMY',1551,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1552,NULL,'DUMMY',1552,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1553,NULL,'DUMMY',1553,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1554,NULL,'DUMMY',1554,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1555,NULL,'DUMMY',1555,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1556,NULL,'DUMMY',1556,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1557,NULL,'DUMMY',1557,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1558,NULL,'DUMMY',1558,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1559,NULL,'DUMMY',1559,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1560,NULL,'DUMMY',1560,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1561,NULL,'DUMMY',1561,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1562,NULL,'DUMMY',1562,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1563,NULL,'DUMMY',1563,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1564,NULL,'DUMMY',1564,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1565,NULL,'DUMMY',1565,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1566,NULL,'DUMMY',1566,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1567,NULL,'DUMMY',1567,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1568,NULL,'DUMMY',1568,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1569,NULL,'DUMMY',1569,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1570,NULL,'DUMMY',1570,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1571,NULL,'DUMMY',1571,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1572,NULL,'DUMMY',1572,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1573,NULL,'DUMMY',1573,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1574,NULL,'DUMMY',1574,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1575,NULL,'DUMMY',1575,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1576,NULL,'DUMMY',1576,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1577,NULL,'DUMMY',1577,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1578,NULL,'DUMMY',1578,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1579,NULL,'DUMMY',1579,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1580,NULL,'DUMMY',1580,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1581,NULL,'DUMMY',1581,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1582,NULL,'DUMMY',1582,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1583,NULL,'DUMMY',1583,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1584,NULL,'DUMMY',1584,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1585,NULL,'DUMMY',1585,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1586,NULL,'DUMMY',1586,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1587,NULL,'DUMMY',1587,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1588,NULL,'DUMMY',1588,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1589,NULL,'DUMMY',1589,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1590,NULL,'DUMMY',1590,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1591,NULL,'DUMMY',1591,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1592,NULL,'DUMMY',1592,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1593,NULL,'DUMMY',1593,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1594,NULL,'DUMMY',1594,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1595,NULL,'DUMMY',1595,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1596,NULL,'DUMMY',1596,1,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1597,NULL,'DUMMY',1597,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1598,NULL,'DUMMY',1598,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1599,NULL,'DUMMY',1599,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1600,NULL,'DUMMY',1600,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1601,NULL,'DUMMY',1601,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1602,NULL,'DUMMY',1602,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1603,NULL,'DUMMY',1603,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1604,NULL,'DUMMY',1604,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1605,NULL,'DUMMY',1605,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1606,NULL,'DUMMY',1606,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1607,NULL,'DUMMY',1607,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1608,NULL,'DUMMY',1608,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1609,NULL,'DUMMY',1609,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1610,NULL,'DUMMY',1610,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1611,NULL,'DUMMY',1611,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1612,NULL,'DUMMY',1612,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1613,NULL,'DUMMY',1613,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1614,NULL,'DUMMY',1614,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1615,NULL,'DUMMY',1615,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1616,NULL,'DUMMY',1616,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1617,NULL,'DUMMY',1617,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1618,NULL,'DUMMY',1618,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1619,NULL,'DUMMY',1619,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1620,NULL,'DUMMY',1620,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1621,NULL,'DUMMY',1621,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1622,NULL,'DUMMY',1622,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1623,NULL,'DUMMY',1623,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1624,NULL,'DUMMY',1624,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1625,NULL,'DUMMY',1625,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1626,NULL,'DUMMY',1626,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1627,NULL,'DUMMY',1627,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1628,NULL,'DUMMY',1628,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1629,NULL,'DUMMY',1629,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1630,NULL,'DUMMY',1630,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1631,NULL,'DUMMY',1631,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1632,NULL,'DUMMY',1632,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1633,NULL,'DUMMY',1633,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1634,NULL,'DUMMY',1634,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1635,NULL,'DUMMY',1635,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1636,NULL,'DUMMY',1636,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1637,NULL,'DUMMY',1637,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1638,NULL,'DUMMY',1638,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1639,NULL,'DUMMY',1639,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1640,NULL,'DUMMY',1640,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1641,NULL,'DUMMY',1641,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1642,NULL,'DUMMY',1642,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1643,NULL,'DUMMY',1643,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1644,NULL,'DUMMY',1644,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1645,NULL,'DUMMY',1645,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1646,NULL,'DUMMY',1646,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1647,NULL,'DUMMY',1647,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1648,NULL,'DUMMY',1648,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1649,NULL,'DUMMY',1649,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1650,NULL,'DUMMY',1650,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1651,NULL,'DUMMY',1651,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1652,NULL,'DUMMY',1652,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1653,NULL,'DUMMY',1653,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1654,NULL,'DUMMY',1654,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1655,NULL,'DUMMY',1655,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1656,NULL,'DUMMY',1656,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1657,NULL,'DUMMY',1657,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1658,NULL,'DUMMY',1658,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1659,NULL,'DUMMY',1659,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1660,NULL,'DUMMY',1660,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1661,NULL,'DUMMY',1661,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1662,NULL,'DUMMY',1662,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1663,NULL,'DUMMY',1663,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1664,NULL,'DUMMY',1664,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1665,NULL,'DUMMY',1665,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1666,NULL,'DUMMY',1666,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1667,NULL,'DUMMY',1667,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1668,NULL,'DUMMY',1668,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1669,NULL,'DUMMY',1669,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1670,NULL,'DUMMY',1670,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1671,NULL,'DUMMY',1671,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1672,NULL,'DUMMY',1672,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1673,NULL,'DUMMY',1673,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1674,NULL,'DUMMY',1674,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1675,NULL,'DUMMY',1675,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1676,NULL,'DUMMY',1676,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1677,NULL,'DUMMY',1677,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1678,NULL,'DUMMY',1678,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1679,NULL,'DUMMY',1679,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1680,NULL,'DUMMY',1680,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1681,NULL,'DUMMY',1681,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1682,NULL,'DUMMY',1682,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1683,NULL,'DUMMY',1683,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1684,NULL,'DUMMY',1684,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1685,NULL,'DUMMY',1685,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1686,NULL,'DUMMY',1686,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1687,NULL,'DUMMY',1687,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1688,NULL,'DUMMY',1688,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1689,NULL,'DUMMY',1689,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1690,NULL,'DUMMY',1690,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1691,NULL,'DUMMY',1691,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1692,NULL,'DUMMY',1692,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1693,NULL,'DUMMY',1693,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1694,NULL,'DUMMY',1694,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1695,NULL,'DUMMY',1695,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1696,NULL,'DUMMY',1696,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1697,NULL,'DUMMY',1697,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1698,NULL,'DUMMY',1698,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1699,NULL,'DUMMY',1699,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1700,NULL,'DUMMY',1700,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1701,NULL,'DUMMY',1701,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1702,NULL,'DUMMY',1702,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1703,NULL,'DUMMY',1703,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1704,NULL,'DUMMY',1704,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1705,NULL,'DUMMY',1705,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1706,NULL,'DUMMY',1706,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1707,NULL,'DUMMY',1707,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1708,NULL,'DUMMY',1708,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1709,NULL,'DUMMY',1709,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1710,NULL,'DUMMY',1710,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1711,NULL,'DUMMY',1711,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1712,NULL,'DUMMY',1712,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1713,NULL,'DUMMY',1713,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1714,NULL,'DUMMY',1714,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1715,NULL,'DUMMY',1715,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1716,NULL,'DUMMY',1716,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1717,NULL,'DUMMY',1717,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1718,NULL,'DUMMY',1718,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1719,NULL,'DUMMY',1719,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1720,NULL,'DUMMY',1720,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1721,NULL,'DUMMY',1721,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1722,NULL,'DUMMY',1722,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1723,NULL,'DUMMY',1723,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1724,NULL,'DUMMY',1724,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1725,NULL,'DUMMY',1725,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1726,NULL,'DUMMY',1726,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1727,NULL,'DUMMY',1727,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1728,NULL,'DUMMY',1728,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1729,NULL,'DUMMY',1729,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1730,NULL,'DUMMY',1730,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1731,NULL,'DUMMY',1731,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1732,NULL,'DUMMY',1732,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1733,NULL,'DUMMY',1733,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1734,NULL,'DUMMY',1734,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1735,NULL,'DUMMY',1735,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1736,NULL,'DUMMY',1736,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1737,NULL,'DUMMY',1737,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1738,NULL,'DUMMY',1738,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1739,NULL,'DUMMY',1739,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1740,NULL,'DUMMY',1740,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1741,NULL,'DUMMY',1741,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1742,NULL,'DUMMY',1742,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1743,NULL,'DUMMY',1743,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1744,NULL,'DUMMY',1744,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1745,NULL,'DUMMY',1745,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1746,NULL,'DUMMY',1746,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1747,NULL,'DUMMY',1747,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1748,NULL,'DUMMY',1748,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1749,NULL,'DUMMY',1749,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1750,NULL,'DUMMY',1750,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1751,NULL,'DUMMY',1751,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1752,NULL,'DUMMY',1752,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1753,NULL,'DUMMY',1753,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1754,NULL,'DUMMY',1754,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1755,NULL,'DUMMY',1755,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1756,NULL,'DUMMY',1756,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1757,NULL,'DUMMY',1757,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1758,NULL,'DUMMY',1758,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1759,NULL,'DUMMY',1759,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1760,NULL,'DUMMY',1760,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1761,NULL,'DUMMY',1761,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1762,NULL,'DUMMY',1762,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1763,NULL,'DUMMY',1763,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1764,NULL,'DUMMY',1764,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1765,NULL,'DUMMY',1765,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1766,NULL,'DUMMY',1766,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1767,NULL,'DUMMY',1767,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1768,NULL,'DUMMY',1768,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1769,NULL,'DUMMY',1769,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1770,NULL,'DUMMY',1770,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1771,NULL,'DUMMY',1771,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1772,NULL,'DUMMY',1772,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1773,NULL,'DUMMY',1773,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1774,NULL,'DUMMY',1774,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1775,NULL,'DUMMY',1775,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1776,NULL,'DUMMY',1776,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1777,NULL,'DUMMY',1777,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1778,NULL,'DUMMY',1778,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1779,NULL,'DUMMY',1779,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1780,NULL,'DUMMY',1780,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1781,NULL,'DUMMY',1781,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1782,NULL,'DUMMY',1782,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1783,NULL,'DUMMY',1783,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1784,NULL,'DUMMY',1784,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1785,NULL,'DUMMY',1785,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1786,NULL,'DUMMY',1786,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1787,NULL,'DUMMY',1787,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1788,NULL,'DUMMY',1788,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1789,NULL,'DUMMY',1789,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1790,NULL,'DUMMY',1790,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1791,NULL,'DUMMY',1791,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1792,NULL,'DUMMY',1792,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1793,NULL,'DUMMY',1793,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1794,NULL,'DUMMY',1794,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1795,NULL,'DUMMY',1795,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1796,NULL,'DUMMY',1796,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1797,NULL,'DUMMY',1797,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1798,NULL,'DUMMY',1798,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1799,NULL,'DUMMY',1799,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1800,NULL,'DUMMY',1800,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1801,NULL,'DUMMY',1801,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1802,NULL,'DUMMY',1802,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1803,NULL,'DUMMY',1803,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1804,NULL,'DUMMY',1804,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1805,NULL,'DUMMY',1805,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1806,NULL,'DUMMY',1806,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1807,NULL,'DUMMY',1807,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1808,NULL,'DUMMY',1808,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1809,NULL,'DUMMY',1809,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1810,NULL,'DUMMY',1810,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1811,NULL,'DUMMY',1811,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1812,NULL,'DUMMY',1812,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1813,NULL,'DUMMY',1813,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1814,NULL,'DUMMY',1814,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1815,NULL,'DUMMY',1815,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1816,NULL,'DUMMY',1816,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1817,NULL,'DUMMY',1817,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1818,NULL,'DUMMY',1818,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1819,NULL,'DUMMY',1819,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1820,NULL,'DUMMY',1820,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1821,NULL,'DUMMY',1821,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1822,NULL,'DUMMY',1822,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1823,NULL,'DUMMY',1823,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1824,NULL,'DUMMY',1824,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1825,NULL,'DUMMY',1825,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1826,NULL,'DUMMY',1826,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1827,NULL,'DUMMY',1827,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1828,NULL,'DUMMY',1828,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1829,NULL,'DUMMY',1829,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1830,NULL,'DUMMY',1830,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1831,NULL,'DUMMY',1831,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1832,NULL,'DUMMY',1832,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1833,NULL,'DUMMY',1833,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1834,NULL,'DUMMY',1834,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1835,NULL,'DUMMY',1835,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1836,NULL,'DUMMY',1836,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1837,NULL,'DUMMY',1837,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1838,NULL,'DUMMY',1838,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1839,NULL,'DUMMY',1839,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1840,NULL,'DUMMY',1840,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1841,NULL,'DUMMY',1841,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1842,NULL,'DUMMY',1842,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1843,NULL,'DUMMY',1843,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1844,NULL,'DUMMY',1844,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1845,NULL,'DUMMY',1845,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1846,NULL,'DUMMY',1846,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1847,NULL,'DUMMY',1847,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1848,NULL,'DUMMY',1848,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1849,NULL,'DUMMY',1849,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1850,NULL,'DUMMY',1850,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1851,NULL,'DUMMY',1851,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1852,NULL,'DUMMY',1852,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1853,NULL,'DUMMY',1853,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1854,NULL,'DUMMY',1854,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1855,NULL,'DUMMY',1855,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1856,NULL,'DUMMY',1856,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1857,NULL,'DUMMY',1857,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1858,NULL,'DUMMY',1858,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1859,NULL,'DUMMY',1859,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1860,NULL,'DUMMY',1860,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1861,NULL,'DUMMY',1861,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1862,NULL,'DUMMY',1862,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1863,NULL,'DUMMY',1863,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1864,NULL,'DUMMY',1864,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1865,NULL,'DUMMY',1865,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1866,NULL,'DUMMY',1866,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1867,NULL,'DUMMY',1867,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1868,NULL,'DUMMY',1868,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1869,NULL,'DUMMY',1869,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1870,NULL,'DUMMY',1870,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1871,NULL,'DUMMY',1871,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1872,NULL,'DUMMY',1872,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1873,NULL,'DUMMY',1873,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1874,NULL,'DUMMY',1874,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1875,NULL,'DUMMY',1875,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1876,NULL,'DUMMY',1876,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1877,NULL,'DUMMY',1877,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1878,NULL,'DUMMY',1878,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1879,NULL,'DUMMY',1879,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1880,NULL,'DUMMY',1880,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1881,NULL,'DUMMY',1881,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1882,NULL,'DUMMY',1882,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1883,NULL,'DUMMY',1883,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1884,NULL,'DUMMY',1884,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1885,NULL,'DUMMY',1885,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1886,NULL,'DUMMY',1886,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1887,NULL,'DUMMY',1887,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1888,NULL,'DUMMY',1888,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1889,NULL,'DUMMY',1889,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1890,NULL,'DUMMY',1890,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1891,NULL,'DUMMY',1891,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1892,NULL,'DUMMY',1892,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1893,NULL,'DUMMY',1893,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1894,NULL,'DUMMY',1894,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1895,NULL,'DUMMY',1895,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1896,NULL,'DUMMY',1896,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1897,NULL,'DUMMY',1897,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1898,NULL,'DUMMY',1898,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1899,NULL,'DUMMY',1899,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1900,NULL,'DUMMY',1900,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1901,NULL,'DUMMY',1901,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1902,NULL,'DUMMY',1902,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1903,NULL,'DUMMY',1903,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1904,NULL,'DUMMY',1904,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1905,NULL,'DUMMY',1905,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1906,NULL,'DUMMY',1906,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1907,NULL,'DUMMY',1907,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1908,NULL,'DUMMY',1908,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1909,NULL,'DUMMY',1909,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1910,NULL,'DUMMY',1910,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1911,NULL,'DUMMY',1911,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1912,NULL,'DUMMY',1912,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1913,NULL,'DUMMY',1913,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1914,NULL,'DUMMY',1914,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1915,NULL,'DUMMY',1915,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1916,NULL,'DUMMY',1916,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1917,NULL,'DUMMY',1917,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1918,NULL,'DUMMY',1918,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1919,NULL,'DUMMY',1919,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1920,NULL,'DUMMY',1920,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1921,NULL,'DUMMY',1921,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1922,NULL,'DUMMY',1922,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1923,NULL,'DUMMY',1923,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1924,NULL,'DUMMY',1924,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1925,NULL,'DUMMY',1925,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1926,NULL,'DUMMY',1926,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1927,NULL,'DUMMY',1927,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1928,NULL,'DUMMY',1928,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1929,NULL,'DUMMY',1929,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1930,NULL,'DUMMY',1930,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1931,NULL,'DUMMY',1931,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1932,NULL,'DUMMY',1932,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1933,NULL,'DUMMY',1933,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1934,NULL,'DUMMY',1934,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1935,NULL,'DUMMY',1935,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1936,NULL,'DUMMY',1936,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1937,NULL,'DUMMY',1937,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1938,NULL,'DUMMY',1938,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1939,NULL,'DUMMY',1939,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1940,NULL,'DUMMY',1940,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1941,NULL,'DUMMY',1941,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1942,NULL,'DUMMY',1942,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1943,NULL,'DUMMY',1943,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1944,NULL,'DUMMY',1944,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1945,NULL,'DUMMY',1945,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1946,NULL,'DUMMY',1946,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1947,NULL,'DUMMY',1947,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1948,NULL,'DUMMY',1948,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1949,NULL,'DUMMY',1949,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1950,NULL,'DUMMY',1950,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1951,NULL,'DUMMY',1951,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1952,NULL,'DUMMY',1952,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1953,NULL,'DUMMY',1953,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1954,NULL,'DUMMY',1954,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1955,NULL,'DUMMY',1955,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1956,NULL,'DUMMY',1956,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1957,NULL,'DUMMY',1957,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1958,NULL,'DUMMY',1958,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1959,NULL,'DUMMY',1959,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1960,NULL,'DUMMY',1960,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1961,NULL,'DUMMY',1961,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1962,NULL,'DUMMY',1962,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1963,NULL,'DUMMY',1963,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1964,NULL,'DUMMY',1964,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1965,NULL,'DUMMY',1965,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1966,NULL,'DUMMY',1966,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1967,NULL,'DUMMY',1967,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1968,NULL,'DUMMY',1968,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1969,NULL,'DUMMY',1969,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1970,NULL,'DUMMY',1970,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1971,NULL,'DUMMY',1971,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1972,NULL,'DUMMY',1972,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1973,NULL,'DUMMY',1973,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1974,NULL,'DUMMY',1974,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1975,NULL,'DUMMY',1975,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1976,NULL,'DUMMY',1976,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1977,NULL,'DUMMY',1977,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1978,NULL,'DUMMY',1978,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1979,NULL,'DUMMY',1979,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1980,NULL,'DUMMY',1980,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1981,NULL,'DUMMY',1981,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1982,NULL,'DUMMY',1982,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1983,NULL,'DUMMY',1983,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1984,NULL,'DUMMY',1984,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1985,NULL,'DUMMY',1985,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1986,NULL,'DUMMY',1986,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1987,NULL,'DUMMY',1987,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1988,NULL,'DUMMY',1988,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1989,NULL,'DUMMY',1989,1,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1990,NULL,'DUMMY',1990,1,'2025-03-17 05:47:30','2025-03-17 05:47:30');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1991 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'TETANUS INJ 10ML MULTIDOSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4265','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(2,'DEXAMETHASONE INJ 8MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(3,'LANSO KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4263','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(4,'XTRADERM SMALL SIZE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(5,'DISPOSIBLE AMOXYL 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(6,'LUMARTEM FORTE 6S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(7,'PRECOB MTHYLCOBALABIN & PREGABALIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4259','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(8,'DACOF MUCOLYTIC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(9,'DACOF PAED 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4257','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(10,'NOXICAM LORNOXICAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4256','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(11,'BESDIZ ,BETASERC GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(12,'METMIN XR 1000MG METFORMIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4254','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(13,'BRONCHOWIN DOXOFYLLINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4253','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(14,'RILIF SR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4252','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(15,'BILASTIN BILAS 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(16,'NORXICAM PLUS LORNOXICAM&PARACETAMOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(17,'SPASMOCARE DROTAVERINE 80MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4249','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(18,'KOFED PAED100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4248','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(19,'YESCORT 30MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(20,'CALPOL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(21,'LOFNAC SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(22,'PREGABALIN 75MG PERGALIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4244','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(23,'CETRIZINE 30ML[ALERID]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4243','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(24,'DOMPERIDONE EMITINO 8MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4242','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(25,'EMITINO 30ML ONDASETRON',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(26,'HIV TEST KIT CADYSOLO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(27,'SHALRTEM SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4239','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(28,'ZINCAT OD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(29,'GLUCONOVA STRIPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4237','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(30,'ETEROCOXIB ICOXIB 60MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4236','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(31,'ETEROCOXIB ICOXIB 120MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(32,'ETEROCOXIB ICOXIB 90MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4234','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(33,'CONACE MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4233','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(34,'TADALAFIL 5MG TADIFA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(35,'CITRO SODA 120GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4231','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(36,'MISSION HB STRIPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4230','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(37,'AEROVENT INHALER 200MD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4229','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(38,'EMPIGET 10MG EMPAGLIFLOZIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(39,'AMINOGUARD SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4227','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(40,'CEFUROXIME SYRUP 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4226','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(41,'DAWA GRIPE WATER 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4225','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(42,'VALTAS 750MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4224','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(43,'ITORPLUS CAPS 20-150',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4223','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(44,'KETOPLUS SHAMBOO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(45,'MISFAJOIN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(46,'GIK 1L',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4219','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(47,'MENTHOL KING LOSENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4217','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(48,'BACTOSEPTIC LOSENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(49,'LABESTEN CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(50,'BONY  KID 120ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(51,'PRONERVE 75-750MCG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(52,'COSCOF EXP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4212','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(53,'APPEVITE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(54,'CLINDA-P- GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(55,'CARVEDILOL CARVETROL 3.125MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4209','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(56,'PLASIL METCOS TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(57,'VITAMIN D3 CAPS SARA D3',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(58,'TADAFORCE 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(59,'NEGRA 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(60,'NEGRA 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(61,'BIOBROL 60ML AMINOSIDINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(62,'CARVEDILOL 12.5MG CARCA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(63,'CARVETROL CARVEDILOL 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(64,'NYLON SUTURE 3/0 RC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(65,'BISOPROLOL 5MG BIZOLOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4199','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(66,'DUME CLASSIC CODOMS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4198','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(67,'GOLDEN PEARL CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4197','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(68,'FLAREX EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4196','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(69,'ZEJOINT TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4195','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(70,'CETRIZINE ZYCET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(71,'CARVEDILOL 25MG CARVICARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(72,'DERMOLUKONIL LUKODERM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4192','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(73,'COFZIL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(74,'AMLODIPINE 5MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(75,'OFLIN D EYE EAR DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(76,'NELGRA 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(77,'NELGRA 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(78,'DAY BY DAY NAPPY RASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4186','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(79,'OVACARE MYO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(80,'ONDASETRON EMITOSS 8MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4184','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(81,'BIO OIL 25ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(82,'MOXAFORTE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(83,'LUNAHIST 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(84,'LUNAHIST 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(85,'SOLVIN PLUS 120ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(86,'OLANZAPINE DEPREX 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(87,'COFZIT 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4177','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(88,'PREGABALIN CABALIN 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(89,'THIOCARB 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(90,'THIOCARB 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(91,'LOOBITOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(92,'ZETAPORE ELASTOPLAST ORIG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(93,'SYRINGES 10ML+NEEDLES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(94,'VICRYL SUTURE 2/0',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(95,'CHROMIC CUTGUT 3/0',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(96,'PREGABALIN CABALIN 150MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4167','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(97,'CELECOXIB 200MG CELOZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4166','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(98,'CELECOXIB 100MG CELOZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(99,'CANDID B CREAM 30G BIG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4164','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(100,'MENTHOL POA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4163','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(101,'OMIS GEL 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(102,'MICONA GEL MICONAZOLE ORAL GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(103,'HEPATIS B IMMUNOGLOBULIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(104,'DIAGLUC GLICLAZIDE 80MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(105,'PANADOL BABY 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(106,'CLOZOLE TRIO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(107,'IVYDEXNEOCIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(108,'MASTIC- LC MONTELUKAST LEVOCETRIZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(109,'SOLUSET WITH G21 NEEDLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(110,'SOFTBAN 8INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(111,'SENSODYNE 20ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(112,'PYROFEN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(113,'SENSODYNE FRESHMINT 40ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(114,'I.V CANULA PURPLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(115,'SILDENAFIL 100MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(116,'SILDENAFIL GEN 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(117,'MTM 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(118,'MTM 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4145','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(119,'IBUGESIC SYR 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(120,'STOMACID TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4143','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(121,'CHESTCOF TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(122,'ESOMEPRAZOLE 20MG ESOME',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(123,'CELCOXX 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(124,'ETRIB 60MG ETORICOXIB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(125,'HYPERTONIC SALINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(126,'MOMETASONE CRAEM NATCORT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(127,'CARVEDILOL 6.25 CARVETROL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(128,'GABS SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4134','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(129,'MUPIROCIN MUPIBAN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4133','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(130,'BETASOL**',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(131,'ALACOT DS EYE DROPS OLAPATADINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(132,'EYEVI CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(133,'CLONAZEPAM 2MG CLONAZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(134,'CLONAZEPAM 0.5MG CLONAZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(135,'MISFACARE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(136,'BULKOT CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(137,'GASTROGEL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4124','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(138,'DEMELAN SUNSCREEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(139,'OLANZAPINE OLASTAR 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(140,'ETORICOXIB VEROXIB 60MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(141,'AUROTIM TIMOLOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(142,'PACE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(143,'GYNOCARE KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(144,'CHLORINE POWDER 500G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(145,'SENSODYNE REPAIR 75ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(146,'EMITO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(147,'ONDASETRON SOLUTION EMITOSS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(148,'VITAMIN C 1000MG EFFERVERSENT GLENCEE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(149,'CLEAR T GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(150,'ONDASETRON TABS EMITOSS -EMISAFE 4MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(151,'LEVIPIL 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(152,'SILVEX SILVER SULPHADIAZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(153,'SEVEN SEAS MULTVITAMIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(154,'COMBIGAN EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(155,'MICROGYNON- FE GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(156,'PECTOCID PLUS 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(157,'OBREX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(158,'OBREX 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4099','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(159,'NORCOLUT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(160,'ANDOLEX - C 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(161,'ACTIVATED CHARCOAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4096','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(162,'BENACOFF DRY 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(163,'BENACOFF PAED 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4094','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(164,'BENACOFF EXPECTORANT 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(165,'BROXAM 100ML AMBROXOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(166,'ACE P',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(167,'TADALIS 40MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(168,'COSCOF EXP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(169,'CLOPIDOGREL GEN 75MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(170,'RETEN 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4087','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(171,'KNEE SUPPORT SMALL[OCA]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(172,'MICROFINE NEEDLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(173,'GLIMEPIRIDE 2MG ZIGLIM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(174,'NIFEDIFINE CALCIGUARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(175,'MYONAC MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(176,'LOXIAM PLUS LORNOXICAM+PARA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(177,'CAFENOL TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(178,'CEEPRO EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'4078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(179,'NILHEAT GEL 30G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(180,'TOBI-D TOBRAMYCIN $ DEXA EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(181,'COLCHICINE TABS 500MCG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3192','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(182,'NILSONS OMEGA-3',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(183,'REJUKEN CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(184,'H.PYROLI SURE KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(185,'TUSPEL PLUS 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(186,'TUSPEL PLUS 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(187,'ATORVASTATIN ATRONA 40MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(188,'TUSICOFF 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3184','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(189,'AZELASTINE OCULAST EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(190,'OLANZAPINE OLASTAR 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(191,'PREGABALIN CABALIN 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(192,'PREGABALIN 75MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(193,'RILIF PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(194,'DEXACIPRO EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(195,'IBULAB TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3177','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(196,'GLUDOWN 28-S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(197,'HOMAGON SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(198,'CLOSTAT CLOTRIMAZOLE POWDER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(199,'YESCORT 6MG DEFLAZACORT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(200,'HER KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(201,'FORMALIN 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(202,'CANDID CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(203,'ALCOF 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(204,'ALCOF 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(205,'DIPROSALIC 30G BIG SIZE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3167','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(206,'GIT PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3166','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(207,'OFLOXACIN TABS TOFLOX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(208,'SODIUM VALPROATE 500MG BRAIPORIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(209,'LEVOTHYROXINE EUTHROX 25MCG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(210,'VITAPYN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(211,'KOFGON RED 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(212,'KOFGON GREEN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(213,'KOFGON GREEN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(214,'KOFGON RED 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(215,'KENCAL CALCIUM TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(216,'CARTIKEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(217,'TRIPACOFF 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(218,'TRIPACOFF 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(219,'SHALTOUX SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(220,'LOSANGIO -HT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(221,'SUPER APPETI TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(222,'SUPER APPETI SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(223,'CARVEDILOL 3.125MG CARVICARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3145','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(224,'UPACOF EXP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(225,'UPACOF DRY 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3143','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(226,'UPACOF PAED 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(227,'NEUROCARE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(228,'H.PYROLI KIT PYLO C',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(229,'H.PYROLI KIT ,EUROPYL KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(230,'HIV STRIP NORM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(231,'VITAMIN D3 DROPS VOX 30ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(232,'VIGOMAX CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(233,'ETRIB ETORICOXIB 90MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(234,'L-SIGN KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3134','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(235,'DYRASUN DF  TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3133','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(236,'ENTEREZOLE DF TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(237,'POWERGESIC MR TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(238,'ESOFAG -D CAPSULE ESOMEPRAZOLE $ DOMPERIDONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(239,'DECOMIT INHALER BECLOMETHASONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(240,'DULOMIN TABS 60MG DULOXETINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(241,'CORDCARE SOLUTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(242,'ONDASETRON INJECTION ONDAZED',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3126','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(243,'CLOTRIMAZOLE CLOTRINE PESSARIES 1\"S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(244,'CORD CLAMPS UMBILICAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3124','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(245,'MELCAM 15MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3123','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(246,'ACYCLOVIR ACIRAX 200MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(247,'UNIBROM EYE DROPS BROMFENAC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(248,'TRANEXAMIC ACID  INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(249,'PACE MR TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(250,'CELEBROPROTEIN ZECERP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3117','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(251,'MINFEN HEAT GEL 30G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(252,'DOMPERIDONE 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(253,'CELECOXIB 200MG ZECEXB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(254,'CELECOXIB 100MG ZECEXB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(255,'MELATONIN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(256,'CHX MOUTHWASH 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(257,'LEVOCETRIZINE TABS FLAMOSET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(258,'TADALAFIL 20MG TADALIS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(259,'TADALAFIL TADALIS 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(260,'LORATEN LORATADINE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(261,'LEVOFREE SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(262,'KRIDOFOS INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(263,'ATORVASTATIN AVAS 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(264,'ATORVASTATIN AVAS 40MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(265,'DOLA CR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(266,'ACNESTAR CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(267,'ITACON ITRACONAZOLE 100MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3099','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(268,'ACP MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(269,'METADOL FIZZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(270,'CIPROGLAX -D EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(271,'NEUTRICID ANTACID 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3094','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(272,'BRIMOCHEK EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(273,'RHINATHIOL INFANT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(274,'COMBISAF KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(275,'PARANOVA EFFER 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(276,'TIMOLOL IVYTIMOLOL 0.5%',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(277,'AUROPODOX 200MG CEFPODOXIME',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(278,'ETOXYM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3087','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(279,'OPTIMAL MOUTHWASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3086','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(280,'PREDNISOLONE SYRUP PREDNCURE 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(281,'BENYLIN DRY 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(282,'PREPOST-N NORETHISTERONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(283,'DIPROSON CREAM 15G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(284,'TRIDAHIST 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(285,'TRIDAHIST 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(286,'ENALAPRIL 5MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3077','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(287,'MONTA PLUS LEVOCETRIZINE+MONTELUKAST',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3076','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(288,'ESOMEPRAZOLE TAB/CAPS 20MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(289,'LEVOCETRIZINE LEVOFREE TABS 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3074','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(290,'CYPROACTIN TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3073','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(291,'CYPROACTIN SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(292,'H.PYROLI TEST KIT STOOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(293,'OTRIVIN 0.1  ADULT DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(294,'ATORVASTATIN AVASTATIN 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3067','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(295,'KALUMASIL LOSENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3066','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(296,'TAMSOLIN  WELTAM XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(297,'AFLODOR ACECLOFENAC 200MG+THIOCOLCHICOSIDE 8MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3064','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(298,'LUBTEAR EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(299,'AMBROX CAPS 75 SR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3062','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(300,'CLEDOMOX 228MG DISPERSIBLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(301,'AMOXYCLAV TABS 228MG DISPERSIBLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(302,'CODOM CATHETER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3059','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(303,'COVERAM 5MG/5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(304,'CARTIMOVE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3057','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(305,'LABCARE LUBRICATING JELLY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(306,'KISS STUDDED CODOMS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3054','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(307,'VERI LUBE LUBRICATING JELLY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3053','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(308,'EOLOY LUBRICATING JELLY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(309,'LANTUS INSULIN 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(310,'TELMI 80H TELMISARTAN & HCTZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(311,'SUBNEURO-B6 TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3049','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(312,'SUBNEURO B12TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3048','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(313,'IVYGENTACIN EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(314,'ITRACONAZOLE ITRANOX 100MG TAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(315,'FLUCONAZOLE 200MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(316,'CETRIZINE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3043','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(317,'VOMISTOP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3042','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(318,'SODIUM VALPROATE BRAPORIN 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(319,'CALCISTAR CALCIUM TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3039','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(320,'DEXAMETHASONE INJ 4MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(321,'ACECLOFENAC ACEKEN 100MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(322,'DIPROSALIC OINT 10G SMALL SIZE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3036','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(323,'SOLARCARE CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(324,'HCTZ 50MG HYMET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(325,'HCTZ HYMET 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3032','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(326,'EROSTIN TABS 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(327,'DICLOFENAC EYE DROPS DICLONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3029','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(328,'SOLVIN PLUS TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(329,'VOLTAREN EMULGEL 20GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3027','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(330,'VOLTAREN EMULGEL50GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3026','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(331,'CARCA 3.125MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(332,'LIFEGUARD CODOMS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(333,'CHLORINE POWDER 250G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(334,'ROCK ALLUM 250G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(335,'REUNITE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(336,'TEARS FORTE EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(337,'PIRITON SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(338,'KNEE SUPPORT LARGE OAC ORTHOCARE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(339,'KNEE SUPPORT XXL TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(340,'COFTA SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(341,'MAXFLORA SATCHETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(342,'BIOZINC DRY POWDER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(343,'KLEEN ENEMA 135ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(344,'ONDASETRON EMESAFE TABS 8MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(345,'ACYCLOVIR UNIVIR 200MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(346,'FLEXPEN NEEDLES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(347,'FERROLIC TABS FERROUS+FOLIC ACID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(348,'CHESTCOF SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(349,'SPOTCLAV COAMOXICLAV 625MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'3000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(350,'AMOEBA TEST',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2999','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(351,'SYMBICORT 160/4.5',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2998','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(352,'FLUCONAZOLE SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2997','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(353,'VITSOL D3',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2995','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(354,'STAY YOUNG ACTIVE GIRL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2994','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(355,'ACTILIFE WOMEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2992','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(356,'FLEX TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2991','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(357,'RABEPRAZOLE RZOLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2990','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(358,'ASPA SWEET 150',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2989','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(359,'SYRINGES 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2988','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(360,'SYPHYLIS TEST KITS VDRL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2986','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(361,'DIAPERS ADULT XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2983','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(362,'FALCIGO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2982','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(363,'TRICOF RED 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2981','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(364,'CARDITAN AM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2980','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(365,'ONECID ANTACID 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2979','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(366,'NACC-DERM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2978','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(367,'BISACODYL BISACOT TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2977','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(368,'PREDNISOLONE DAWASOLONE SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2976','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(369,'ELECTRODOC ORS 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2975','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(370,'EVOKE SILDENAFIL 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2973','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(371,'ALLUCID PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2972','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(372,'HARTEZE RIVAROXABAN 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2971','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(373,'SONADOL JUNIOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2969','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(374,'KALUMA WHITE BALM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2968','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(375,'INFRAPRED SYRUP PREDSOLONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2967','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(376,'TETANUS SINGLE DOSE INJ.',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2966','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(377,'OLIGOCARE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2963','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(378,'MALAREM SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2962','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(379,'ESOMEPRAZOLE 40MG CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2961','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(380,'CIPROFLOXACIN I.V',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2960','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(381,'LOSARTAS 50MG SARTILO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2959','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(382,'MONTELUKAST+ LEVOCET MONTIKAST- LA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2958','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(383,'ONDASETRON SYRUP VOMIKIND',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2957','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(384,'ECONAZOLE CREAM ECONAZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2956','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(385,'MICOBACT POWDER MICONAZOLE 75G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2955','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(386,'PYROFEN IBUPR+PARA 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2953','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(387,'PREGABALIN 150MG PRINAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2952','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(388,'GOLDCAL SYRUP 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2950','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(389,'AMOXYCLAV 156MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2949','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(390,'CODSEAS CODLIVER 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2948','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(391,'DICLOFENAC CAREFENAC 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2947','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(392,'MALEGRA SILDENAFIL ORAL GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2946','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(393,'FUNGIFIN CREAM TERBINAFINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2944','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(394,'MELOXICAM 15MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2942','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(395,'FEVITE B.COMPLEX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2941','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(396,'VITAMIN B COMPLEX TABS BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2940','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(397,'MENTHOLPLUS 9GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2939','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(398,'DICLOFENAC 100MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2938','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(399,'MONTELUKAST 4MG MONTIKAST',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2935','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(400,'ATENOLOL-50MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2932','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(401,'PROZIN SILVERSULFADIAZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2931','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(402,'CARBAMAZIPINE 200MG LAB/BIO/COMET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2930','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(403,'BLOOD PRESSURE CHECK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2929','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(404,'CARDINOL 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2928','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(405,'BIODINE ANTISEPTIC 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2927','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(406,'JUST TEARS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2926','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(407,'FERROPLEX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2925','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(408,'JOINTTEK PLUS TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2924','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(409,'RETEN -H LOSARTAN+HYDROCHLOROTHIAZIDE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2923','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(410,'ACENAC- P',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2922','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(411,'MELCAM 7.5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2920','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(412,'MIXTARD FLEXPEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2919','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(413,'ZEBATIN EBASTINE 120ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2918','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(414,'SONADOL XTRA RETAIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2917','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(415,'LEVAMISOLE TABS RETAIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2916','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(416,'TRICOFF 100ML RED',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2914','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(417,'FERROUS SULPHATE TABS BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2912','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(418,'ULTRAFLOX CIPROFLOXACIN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2911','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(419,'ANTISTREPTOLYSIN O STRIPS REAGENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2909','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(420,'URINALYSIS STRIPS 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2908','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(421,'BLOODB GROUP REAGENT ANTI D',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2907','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(422,'BROOD GROUP REAGENT ANTI B',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2906','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(423,'BLOOD GROUPING REAGENT ANTI A',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2905','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(424,'RHEUMATOID FACTOR REAGENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2903','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(425,'BRUCELLA TEST REAGENT M',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2902','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(426,'BRUCELLA TEST REAGENT A',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2901','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(427,'MICROSCOPE SLIDES 72S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2900','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(428,'MEBEDAZOLE SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2899','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(429,'TORY 120MG ETORICOXIB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2898','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(430,'SOLUBLE  INSULIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2897','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(431,'STREPSILS RENGULAR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2896','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(432,'FLAZINE SILVER SULPHADIAZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2895','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(433,'ABUMOL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2894','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(434,'GLUCOMET-XR 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2893','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(435,'BUSCOPAN GENERIC COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2892','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(436,'GLOGEN-D EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2891','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(437,'AL 12,S CHILD DOSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2890','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(438,'NYSTATIN DROPS 12ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2887','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(439,'NYSTATIN DROPS 30ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2886','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(440,'BIODINE MOUTHWASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2884','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(441,'M',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2883','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(442,'MONTELUKAST 10MG UCON',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(443,'JADELLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2880','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(444,'IMPLANON',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2879','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(445,'TALGENTIS 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2878','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(446,'HYDROGEN PEROXIDE 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2877','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(447,'PHARMASAL SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2876','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(448,'TREATMENT CHARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2875','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(449,'NEXAHIST 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2874','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(450,'NEXAHIST 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2873','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(451,'AMINOSIDINE TABS MINODINE 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2872','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(452,'METHYLCOBALAMIN 1500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2871','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(453,'TRANEXAMIC ACID STOP-500MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2870','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(454,'ZINC SUSPENSION ZYNQ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2869','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(455,'H. PYROLI KIT HELICURE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2868','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(456,'ALLUCID TABS 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2867','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(457,'IROVEL 300MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2866','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(458,'LYRICA 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2865','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(459,'URISOL SATCHET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2863','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(460,'DEXAMETHASONE TABS 4MG BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2862','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(461,'BLOOD PRESSURE TEST',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2860','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(462,'GALVUSMET 50\\1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2857','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(463,'GALVUSMET 50\\500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2856','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(464,'CARVEDILOL CARCA 6.2MG INTAS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2855','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(465,'AMOXIL 500MG ORIGINAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2854','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(466,'PEARDINE MOUTHWASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2853','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(467,'SALBUTAMOL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2852','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(468,'DOMPERIDONE DOMNAC 30ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2850','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(469,'MAALOX PLUS TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2849','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(470,'DELASED NON-DROWSY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2848','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(471,'PIRITON 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2847','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(472,'GENTIAN VIOLENT G.V 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2846','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(473,'TAMEDOL ETRA 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2845','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(474,'SALOREX MUCOLYTIIC 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2843','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(475,'DEKOZI EXPECTORANT 100M9L',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2842','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(476,'CLARIE DS125MG\\5ML.50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2838','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(477,'ALZOLAM 0.5MG[APLAZOLAM]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2837','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(478,'GABAPENTIN GABAZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2836','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(479,'ROVISTA 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2834','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(480,'VENTOLIN NEBULISER SOLUTION 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2830','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(481,'LISTERINE MOUTHWASH COOLMINT 500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2829','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(482,'ETERICOXIB VEROXIB 90MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2827','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(483,'HARTEZE RIVAROXOBAN 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2826','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(484,'DR TOUX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(485,'HEMOFORCE 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2824','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(486,'BROXOL 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2823','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(487,'PROMETHAZINE COSMOS BP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2822','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(488,'SHALARTEM AL DS 6S ADULT DOSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2820','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(489,'PANTOPLAZOLE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2816','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(490,'NEBILONG AM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2813','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(491,'SURDEX SYRUP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(492,'ZUPRICIN  OINT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2811','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(493,'AUROCROME EYE DROP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(494,'COLDAMOL P SYP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(495,'ACP SP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(496,'LE-SURE KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(497,'ACICLOVIR EYE OINTMENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(498,'MULTIVITAMIN 100 S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(499,'GLODEX-N[DEXAMETHASONE+NEOMYCIN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(500,'ZARONTIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2800','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(501,'TRICOF 100ML GREEEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2799','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(502,'LACOFF RED 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2798','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(503,'LACOFF  RED 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2797','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(504,'AMARYL 4',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2796','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(505,'TITANIC GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2794','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(506,'EPIDERM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2792','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(507,'VIT C+SODIUM+ZINC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2791','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(508,'ZECUF LOZENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2790','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(509,'PENDOFER 200ML[HAEMATINIC]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2789','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(510,'TROGYL PLUS[METRO+DILOXANIDE]SYP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2788','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(511,'CEOVIT 250',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2787','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(512,'POLY POT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2786','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(513,'IBUCAP FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2785','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(514,'MONTANA 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2784','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(515,'ZOFEN CZ MR ACECLOFENAC/PAR/CHZ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2782','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(516,'ZOFEN GEL[ACECLO,LINSEED,M.SALICYLT,MENTHO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2781','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(517,'TERBINAFINE[TFINE 250MG]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2780','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(518,'ZOFEN-P[ACECLO,PARACE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2778','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(519,'EPIBALIN 150',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2777','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(520,'VIT D[D3 60 CAP]4S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2776','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(521,'THIOVENT[WITH PROMETHAZINE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2775','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(522,'MODURETIC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2774','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(523,'MAGNOMINT 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2773','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(524,'SONAPEN MENTHOPLUS 9ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2772','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(525,'PHENOBARBITONE 30 MG COMET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2771','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(526,'GLYCERINE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2768','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(527,'CARVAS 6.25MG[CARVEDILOL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2767','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(528,'SOFT BALL 4\"',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2766','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(529,'ECOLD PLUS 10 TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2765','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(530,'SOFT BALL BANDAGE 6\"',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2764','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(531,'FOLIC ACID TIN 1000S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2762','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(532,'ELAXIC P TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2760','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(533,'VITAMIN C SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2759','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(534,'H.PYLORI KIT HELICOS KIT 7S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2754','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(535,'PROPRANOLOL GEN.',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2753','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(536,'MONTANA 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2752','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(537,'TRIMORIX SYP 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2751','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(538,'ESOXIUM IT[ESOMEP 40MG+ITOPRIDE 150MG]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2750','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(539,'DESLIT SYP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2749','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(540,'GABAZ GABAPENTIN 300MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2748','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(541,'COFTA TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2747','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(542,'SHOULDER IMMOBILISER LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2746','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(543,'SHOULDER IMMOBILISER MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(544,'AQUATABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2744','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(545,'DUZELLA 30MG DULOXETINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2743','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(546,'SUCRALFATE TAB ANTEPSIN 1G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2742','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(547,'VISIONACE CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2741','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(548,'ITRACONAZOLE ICON',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2740','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(549,'TOFEN 1MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2739','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(550,'LACOFF GREEN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2738','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(551,'LACOFF GREEN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2737','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(552,'GENTA DEXA/GENTA D EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2736','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(553,'DEXNEO EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2735','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(554,'LETROZOLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2734','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(555,'DEFLAM SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2732','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(556,'ACYCLOVIR TABS CYCLOVIR 400MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2730','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(557,'TRAMADOL 50MG CAPSULES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2729','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(558,'CIPLADON 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2728','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(559,'BENYLIN 4 FLU 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2727','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(560,'CITRO SODA 60GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2726','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(561,'BROXOL SYP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2725','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(562,'L MONTUS KID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2724','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(563,'SPIRONOLACONE 1OOMG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2722','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(564,'ECOLD SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2721','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(565,'APIGESIC PLUS ACECLOFENAC\\PARACETAMOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2720','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(566,'ALPRAZOLAM CALMEX 0.5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2719','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(567,'CLARITHROMYCIN SYRUP CLARICOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2718','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(568,'COSCOF DM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2717','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(569,'ADVANT 16MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2716','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(570,'ELOCOM MOMETASONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2715','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(571,'LASIX LAB AND ALLIED',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2713','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(572,'SUNGEL ANTACID SUSPENSION 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2711','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(573,'NADOXIN CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2710','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(574,'FLUCONAZOLE INFUSSION 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2709','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(575,'ASCORIL D',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2708','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(576,'LOFNAC GEL TUBE 30G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2707','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(577,'MEDIVEN OINTMENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2706','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(578,'MOXIFLOXACIN EYE DROPS MOLFLOREN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2705','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(579,'CEFIXIME 200MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2704','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(580,'TADALAFIL TADALISTA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2703','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(581,'EBASTINE HISTY TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(582,'PROMESIL[SOY ISOFLAVO40%&ESSENTIAL PHOSPHOLIPIDS]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2700','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(583,'RE-UNITE2[CALCIUM&VITAMIN D3] XX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2699','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(584,'KAAP D DROPS[VIT D ]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2698','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(585,'BONIKAP[CALCIUM,ZINC,VIT D3]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2697','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(586,'INSTAFLEX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2696','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(587,'ACCUCHECK TEST STRIPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2695','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(588,'COW AND GATE 3[NUTRISTART]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2694','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(589,'FLOXAPEN SYP O',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2691','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(590,'VALTAS 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2690','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(591,'AMPICILLIN 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2689','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(592,'OXIMETRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2686','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(593,'ULCERID PLUS 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2685','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(594,'CEFTAZIDIME INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2684','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(595,'CHOLESTYRAMINE 5MG CHOLTRAN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2683','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(596,'VAGIL -CL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(597,'JOINTPRO TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2680','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(598,'GLEMONT -L',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2678','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(599,'DYNACORT 30MG DEFLAZACORT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2677','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(600,'UNICONTIN 400MG THEOPHYLLINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2676','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(601,'BENACOFF LINCTUS 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2675','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(602,'MYOZOX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2674','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(603,'BENACOFF EXPECTORANT 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2671','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(604,'BENACOF PAED 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2670','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(605,'KISS STRAWBERRY[DOTTED]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2669','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(606,'UNIACTIN TABS 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2668','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(607,'ZULU SP[ACECLOFENAC,PARACETAMOL&SERRATIOPEPTIDASE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2666','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(608,'LOFNAC 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2665','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(609,'LOFNAC 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2664','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(610,'NAN 2',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2663','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(611,'ECONAZOLE EYE DROP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2662','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(612,'TAMILONG[TAMOXIFEN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2661','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(613,'MOBIC 15MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2660','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(614,'POTASSIUM CHLORIDE 150MG/ML 10ML AMP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2659','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(615,'MELOXICAM 7.5MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(616,'DEXA G EYE DROP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2657','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(617,'CLOPRONE CRM[CLOBETASOL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2656','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(618,'BLOOD PRESSURE MACHINE PULSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2655','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(619,'HUMAN ALBUMIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2654','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(620,'FUNCTIONAL HINGED KNEE SUPPORT XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2653','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(621,'AEROCORT 200D INHALER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(622,'ACETAL MR[ACECLOFENAC+PARACETAMOL+CHLORZOXAZONE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2650','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(623,'STERODERM[MOMETASONE 0.1%]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2649','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(624,'ENTEREZOLE SYRUP 100ML [DILOXANIDE+METRONIDAZOLE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2648','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(625,'MUCOSOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2646','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(626,'ZEDCAL TABS 30S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2645','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(627,'COSATRIM DS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2644','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(628,'NAZOMED TABLETS[ACECLOFENAC100MG+PARACETAMOL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2643','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(629,'SHAL ARTEM FORTE TABLETS 6S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2642','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(630,'GABANERVE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2641','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(631,'TRAMACETAL TABS 10S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2640','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(632,'SUNCTION CATHETER S14',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2639','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(633,'METFORMIN 850MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2638','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(634,'ANTACID MAGNOMINT BLISTER100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2637','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(635,'TETRACYCLINE CAPS BP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2636','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(636,'NON STERILE GAUZE SWABS 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2635','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(637,'DIAPHAGE 500 MG[METFORMIN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2633','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(638,'CELEBET TABS 30',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2632','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(639,'OG KIT[FLUCONAZOLE 150MG,AZITHRO,SECN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2631','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(640,'POVIDONE 5L',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2630','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(641,'SARA D3 DROPS 15ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2629','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(642,'DYRASUN[DILOXANIDE+METRONIDAZOLE]100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2627','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(643,'MEBENDAZOLE 100S[NATOA]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2626','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(644,'CLOXACILLIN SYP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2625','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(645,'PROGUANIL TAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2624','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(646,'DERMIDEX CRM[MICONAZOLE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2623','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(647,'NEOGADINE 150ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2622','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(648,'DAZEL KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2621','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(649,'TRICOHIST EXPECT 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2620','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(650,'HAND SANITIZER 5LITRES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2619','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(651,'WALKING STICK QUADRIPOD L-12 UNIVERSAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2618','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(652,'WALKING STICK TRIPOD 32 UNIVERSAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2617','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(653,'RESPERIDON',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2616','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(654,'CHILDREN FACE MASK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2614','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(655,'NEEDLE G18',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2613','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(656,'KNEE SUPPORT[KEDLEY]LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2612','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(657,'KNEE SUPPORT[KEDLEY] MEDIUM]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2611','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(658,'ACTRAPID 10ML/SOLUBLE INSULIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2610','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(659,'H.PYLORI KIT HELIGO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2609','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(660,'GLYPIN 4MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2608','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(661,'ABUMOL 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2607','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(662,'XTRADERM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2606','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(663,'TINTURE OF IODINE 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2605','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(664,'TERBIBACT MIX[TERBINAFINE,OFLO,ORNIDE&CLOBETASOL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(665,'IMODIUM CAP 6S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(666,'FRICK LZENGES HONEYLEMON GL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(667,'KN95 MASK WITH RESPIRATOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2599','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(668,'ELBOW SUPPORT M[MGRM]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2598','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(669,'WRIST SPLINT XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2597','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(670,'TALGENTIS 20MG [TADALAFIL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2594','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(671,'CEFADROXIL 500',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2591','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(672,'ALCOHOL SWABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2590','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(673,'URINE SAMPLE CONTAINER 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2589','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(674,'UNISTEN V1 TABS 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2587','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(675,'METFORMIN 500MG GEN 100-S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2586','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(676,'DIPIFER INJ 5ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2585','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(677,'GLYPIN 2MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2584','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(678,'CERUMOL EARDROP 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2583','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(679,'DIAPHAGE 850MG[METFORMIN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2582','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(680,'ONDASETRON ONDEX MD TABLETS 4MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2580','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(681,'MICONAZ ORAL GEL 20GMS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2579','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(682,'COLOSTOMY BAG 25*15CM[LARGE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2577','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(683,'COLOSTOMY BAG20*14CM[MEDIUM]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2576','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(684,'IFAS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2575','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(685,'TERBINAFINE CREAM DERMAFIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2574','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(686,'STALACE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2572','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(687,'SICLOFEN MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2571','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(688,'ELAXIC FAST GELDICLOFENAC,LEVOMENTHOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2569','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(689,'DTO[OFLOXACIN+ORNIDAZOLE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2568','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(690,'RALIO D[RABEPRAZOLE+DOMPERIDONE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2567','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(691,'CORNIZOLE D SYP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2566','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(692,'BRUFACE SYP[IBUPROFEN+PARACETAMOL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2565','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(693,'CORSPIRIN 75MG 30 S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2564','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(694,'ENLEV[LEVOCETRIZINE SYP]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2563','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(695,'CORNIZOLE D[DILOXANIDE+METRONIDAZOLE] TABS DS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2562','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(696,'ZUNIL[FLUCONAZOLE 200MG]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2561','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(697,'ECOLD CAPSULES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2560','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(698,'MINOCYCLINE 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(699,'ESOFAG KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2557','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(700,'HEMOVIT BLOOD BUILDER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2556','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(701,'PERFECTIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2555','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(702,'NYLON SUTURES REVERSE CUT 2.0 NON ABSORB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2552','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(703,'ETORICOXIB TORY 60MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2551','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(704,'ETORICOXIB TORY 90MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2550','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(705,'FLEXISTAR TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2549','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(706,'ALERFREE TABLET LEVOCETRIZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2547','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(707,'ALERFREE LEVOCETRIZINE SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(708,'CHROMIC CUTGUT 2/0 REVERSE CUTTING',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2545','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(709,'IBUCAP CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2544','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(710,'NEUROBIONE FORTE CAPSON FORTE BENMED',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2543','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(711,'BIOBROL AMINOSIDINE 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2541','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(712,'MEDISTOP SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2540','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(713,'SAFETY BOX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2539','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(714,'CLOTRIMAZOLE MOUTH PAINT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2538','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(715,'WIDAL TEST KITS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2537','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(716,'COSFLORA POWDER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2536','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(717,'KALUMA TOOTHPASTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2532','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(718,'FORALIN INHALER 100DOSES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2531','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(719,'CHESTONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2530','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(720,'FUNBACT CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2529','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(721,'NOVORAPID FLEXPEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2527','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(722,'LASIX 40MG ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2526','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(723,'LEVOTHYROXINE 50MCG EUTHYROX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2525','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(724,'THUNDER M',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2524','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(725,'BETASALIC OINTMENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2523','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(726,'KY GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2522','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(727,'BLOOD PRESSURE MACHINE FABIA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2521','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(728,'CONCOR 5MG  BISOPROLOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2520','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(729,'ONCALL BATTERY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(730,'SAYANA PRESS DEPO',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2517','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(731,'DECOMIT BECLOMETHASONE NASAL SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2516','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(732,'ZYRTAL -OD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2515','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(733,'COVID OVERALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2514','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(734,'EXTEMPORANIOUS PREPARATION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(735,'HAND SANITIZE  WITH PUMB 500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2510','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(736,'FACE SHIELD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2509','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(737,'LANZOL DT JUNIOR 15MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2507','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(738,'AQUEOUS CREAM 500GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2506','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(739,'AQUEOUS CREAM 100G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(740,'TRITIS TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2504','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(741,'OVACARE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2503','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(742,'DUOFILM LIQUID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(743,'PEPTICA GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(744,'CLARINASE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(745,'KALUMA MENTHOL PLUS BALM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2499','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(746,'MOMATE CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2498','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(747,'TRIOKIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2497','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(748,'VASTAREL 35MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2496','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(749,'CANDITRAL ITRACONAZOLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2492','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(750,'BENZHEXOL 5MG COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2491','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(751,'ANKLE SAUPPORT MGRM XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2489','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(752,'ANKLE BRACE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2488','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(753,'WALKING FRAME',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2487','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(754,'METRONIDAZOLE 200MG BLISTER BPACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2486','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(755,'RHEUMAC EC DICLOFENAC 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2485','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(756,'OFLOXACIN EYE DROPS AUROFLOX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2484','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(757,'HIV KIT ORAQUICK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2483','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(758,'ANTACID MIXTURE 500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2482','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(759,'INFRARED THERMOMETRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2479','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(760,'DEPROZET 20MG FLUOXETINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2478','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(761,'OXYBUTININ OXINUS 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2476','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(762,'ZEEROL KIT ORS+ZINC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2475','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(763,'ETORICOXIB 90MG NUCOXIA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2474','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(764,'ROCEPHINE INJECTION 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2472','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(765,'INCENTIVE GIFT  HAMPER…',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2471','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(766,'COMPRESSION STOCKING MID-THIGH MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2469','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(767,'CEFUROXIME INJECTION 750MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2468','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(768,'TERBINAFINE TERBINAFORCE 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2467','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(769,'NATRILIX SR 1.5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2466','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(770,'VASOPRIL 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2465','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(771,'NETAZOX TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2464','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(772,'BETADINE MOUTHWASH 250ML ORIG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2462','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(773,'CARBAMAZIPINE  NEUROTROL UNIVERSAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2461','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(774,'AUROCOL DM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2460','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(775,'CHLORHEXEDINE DIGLUCONATE GEL CHX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2459','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(776,'CLOBEDERM CREAM 10GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2458','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(777,'H.PYROLI RDT TEST KITS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2455','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(778,'TRUST STUDDED',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2454','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(779,'ESOSE HP KIT ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2453','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(780,'ROHO MOJA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2452','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(781,'KALUMAPLAST',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2451','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(782,'VOLTAREN 100MG TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2450','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(783,'KAMAGRA TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2449','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(784,'LESCID ANTACID SUSPE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2448','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(785,'MEROPENEM INJ 1G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2446','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(786,'VAGICLIN PESSARIES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2445','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(787,'ZITHROMAX 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2444','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(788,'MD LUBRICATING JELLY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2442','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(789,'CHLORPROMAZINE 25MG COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2441','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(790,'TRAMADOL INJECTION  100MG/2ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2440','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(791,'ACICLOVIR TABLETS 400MG COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2439','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(792,'UTI KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2438','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(793,'CLOTRIMAZOLE PESS 3S 200MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2437','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(794,'ADVANTAN CREAM 15GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2435','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(795,'MICARDIS PLAIN 80MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2434','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(796,'GAVISCON PEPPERMIN LIQUID 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2432','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(797,'CARDACE 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(798,'SANITIZER 1000ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(799,'RAIN COAT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2427','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(800,'ESOFLAG D 40MG/30MG CAP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2426','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(801,'SANITIZER 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(802,'SANITIZER 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2424','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(803,'EPILIM CHRONO 500MG CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2423','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(804,'VITAMIN C TABLETS 100MG BLISTER PACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2421','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(805,'ACICLOVIR 200MG COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2420','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(806,'COTRIMOXAZOLE [SEPTRIN] 100 480MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2419','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(807,'MALARIA TEST KIT CARESTAT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2418','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(808,'PREGABALIN 150MG[GABAROL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2417','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(809,'DERMIGUARD MIX CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2416','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(810,'METODINE DF[DILOXANIDE+METRONIDAZOLE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2415','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(811,'ONDAVELL[ONDANSETRIN]8MG/4ML INJ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2414','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(812,'LAMIKOT CREAM[TERBINAFIN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2413','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(813,'LEVOCETRIZINE LEVOCET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2412','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(814,'VASOPRIL 5MG[ENALAPRIL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(815,'FELDENE CAP 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2410','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(816,'ELBOW SUPPORT LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2409','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(817,'LUMERAX 80/480 TABLET 6[AL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2408','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(818,'CYPON SYRUP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2407','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(819,'HYLO COMOD EYE DROP 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(820,'PARACETAMOL INFUSION IV 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(821,'GLUCOPHAGE XR 1GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(822,'NADIMIX CREAM 7.5G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(823,'CARVEDILOL[VACODIL] 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2400','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(824,'SILVER SULPHADIAZINE 100GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2399','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(825,'NEOCOFF D 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2398','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(826,'NEOCOFF D SYRUP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2397','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(827,'PAYMENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2395','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(828,'ZERODOL P',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2394','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(829,'COLDAMOL CAPS 100S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2393','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(830,'INTAMINE CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2392','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(831,'MICRONEMA 10ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2390','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(832,'CARVEDILOL 12.5MG VACODIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2388','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(833,'LORATADINE SYRUP LORATA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2387','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(834,'DESLORATADINE DESOSTAR TABLETS 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2386','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(835,'PROPRANOLOL COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2385','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(836,'DIAPERS ADULT  MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2384','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(837,'DIAPERS ADULT  LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2383','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(838,'DIAPERS ADULT SMALL XX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2382','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(839,'AMOXICLAV 1.2GM INJECTION INJMENTIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2381','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(840,'REMUS 0.035% 10G[TACROLIMUS]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2380','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(841,'AMOXYCLAV INJECTION 1000MG INJMENTIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2379','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(842,'CASH BACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2378','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(843,'FLUGONE EX 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2377','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(844,'ETORICOXIB[COXIRAV]120MG TAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2375','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(845,'FLAMOX SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2373','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(846,'CARVEDILOL 12.5 VIDOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2372','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(847,'CARVEDILOL 6.25MG VACODIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2371','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(848,'NIFEDIFINE GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2370','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(849,'PIOGLUC 30MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2369','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(850,'ACICLOVIR CREAM UNIVIR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2368','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(851,'STERIMAR NASAL SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2367','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(852,'PARAFEN SYRUP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2366','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(853,'IVERMECTIN 6MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2365','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(854,'TUSPEL  100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2364','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(855,'CEREGARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2363','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(856,'UNPAID BALANCE CF',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2362','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(857,'VENOFER GEN/ FEROGEN IRON SUCROSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2361','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(858,'DULCOLAX ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2360','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(859,'TINTURE IODINE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2359','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(860,'ROCK ALUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2358','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(861,'FARM LINEMENT 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2357','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:28','2025-03-17 05:47:28'),(862,'CARVEDILOL VIDOL 6.25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2356','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(863,'BENYLIN CHESTY 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2355','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(864,'EPIMAX ALL PURPOSE 400GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2354','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(865,'ATORVASTATIN 20MG AVASTATIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2353','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(866,'E-COLD CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2352','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(867,'GENDEX EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2350','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(868,'FOPYN TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2349','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(869,'MINERAL WATER1.500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2348','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(870,'ZINC OXIDE BPASTE 100G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2346','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(871,'CALENDERS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2345','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(872,'DIAGONE KITS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2344','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(873,'NEXIUM 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2343','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(874,'HEMOFER INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2338','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(875,'GYPSONA P.O.P 8',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2337','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(876,'VENOFER I.V',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2336','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(877,'BENYLIN EXPECTORANT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2335','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(878,'ETORIX ETEROCOXIB 60MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2334','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(879,'COFRID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2333','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(880,'RIDMAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2332','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(881,'SARTILO LOSARTAN H GENER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2331','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(882,'TRYACTIN SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2326','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(883,'DUODART DUTASTERIDE/TAMSULOSIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2317','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(884,'HINGED KNEE SUPPORT LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(885,'HINGED KNEE SUPPORT MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2311','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(886,'DIGITAL WEIGHING SCALE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2310','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(887,'COX B 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2309','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(888,'ZUPRICIN B OINT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2307','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(889,'TAMEDOL EXTRA 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2306','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(890,'IBUGESIC SYP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2305','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(891,'ACTOPHLEM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2304','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(892,'TRANAMIC/MENOZIP TRANEXAMIC ACID500MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(893,'BETADINE ANTISEPTIC 500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(894,'LISTERINE FRESHBURST MOUTHWASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(895,'MAALOX SUSPENSION 350ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2299','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(896,'TREVIAMET 50MG/500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2296','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(897,'ZEEFEE 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2295','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(898,'IBUMEX CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2293','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(899,'AMOXYL ORIGNAL  125MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2292','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(900,'ALGIC-P ACECLOFENAC AND PARACETAMOL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2291','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(901,'COMPRESSION STOCKINGS MID THIGH XXL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2288','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(902,'GYPON SYRUP CYPROHEPTADINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2285','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(903,'MICONAZOLE CREAM LAEOTARIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2284','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(904,'GABAPENTIN ONEGABA 300MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(905,'AMLODEAL 10MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2278','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(906,'NEBILONG 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2277','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(907,'PHENOBARBITONE INJECTION BARBIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2276','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(908,'ACEPAR MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2275','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(909,'ITOPRID 50MG ITOPRIDE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2274','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(910,'ARTESUNATE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(911,'ESCORT INSECTCIDE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2272','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(912,'SALBUTAMOL INHALER GENERIC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(913,'ARMSLING MGRM XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2270','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(914,'ARMSLING MGRM LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2269','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(915,'CERVICAL COLLAR SOFT EYELET MGRM LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2268','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(916,'CERVICAL COLLAR SOFT EYELET COLLAR MGRM MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2267','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(917,'CONTOURED LUMBO. BELT MEDIUM MGRM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2266','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(918,'CONTOURED LUMBOSACRAL BELT LARGE  MGRM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2265','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(919,'KNEE CAP MGRM XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(920,'EPIMAX JUNIOR 400G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2263','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(921,'KALUMA BALM 4GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(922,'CONTAMIZOLE 100ML[METRONIDAZOLE,DILOZANIDE,D',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(923,'POVIDONE IODINE 100ML SINAI',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(924,'ADIPIN 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2257','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(925,'AMAX 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(926,'TRIHISTAMIN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(927,'TRICOHIST 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(928,'NASITHIOL INFANT 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2249','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(929,'LONART SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2248','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(930,'CIGARRETS FILTERS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(931,'NASITHIOL PROMETHAZINE 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(932,'PIRITON INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(933,'REFRESH TEARS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2244','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(934,'APPEVITE 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(935,'ONTEL 80AM[TELMI 80$AMLODIPINE 5MG]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(936,'ONTEL 40[TELMISARTAN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2239','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(937,'ONTEL 80[TELMISARTAN ]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(938,'ONTEL 40AM[TELMI40$AMLODIPINE 5MG]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2237','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(939,'FLUOXETINE[FLUNIL]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2233','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(940,'5ML SYRINGES WITH NEEDLES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(941,'2ML SYRINGES WITH NEEDLES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2231','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(942,'CIPROFLOXACIN EYE DROP[PROLOXIN]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2230','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(943,'LORATIDINE TAB[LORVIC] 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2229','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(944,'MOZA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(945,'FORACHE TOOTHACHE SOLUTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2227','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(946,'WHEEL CHAIR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2226','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(947,'FLAMOX 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2225','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(948,'APRAZOLE PLUS[OMEPRAZOLE  POWDER]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(949,'HEELCREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(950,'EPILIM SYP 300ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2220','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(951,'L-MONTY KID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2218','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(952,'IROVEL 150MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(953,'GLUCOMETXR 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(954,'IROVEL H',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(955,'CHLORPROMAZINE 200MG TABS LAB\\BIODEAL\\ELYS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2212','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(956,'FYBOGEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(957,'ULAX TAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2209','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(958,'SCALP VEIN GREEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(959,'SCALP VEIN BLUE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(960,'AL SYRUP LUMARTEM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(961,'ESOMEPRAZOLE 40MG INJ[ESZED]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(962,'CELCOXX CAP 200MG[CELECOXIB]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(963,'LOLITA GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(964,'BONJELA ADULT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(965,'DEFLAM RUB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(966,'SKDERM CRM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2199','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(967,'JOINTCARE[VITA HEALTH]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2198','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(968,'TRAVOCORT0.1+1%',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2196','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(969,'TERBIFIN TERBINAFINE TABLETS 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2195','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(970,'POSDINE MOUTHWASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(971,'PATELLA HUMMER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2192','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(972,'PEN TORCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(973,'LIPTOMIL  PLUS 1 400G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(974,'DESLORATADINE DESOSTAR SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(975,'FASTUM GEL 20GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(976,'METHYLATED SPIRIT 100MLS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2186','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(977,'H.PYROLI KIT PYLOTRIP KIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(978,'SIGNKIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2184','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(979,'BETADINE VAGINAL PESSARIES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(980,'ERGOMETRINE INJECTION 0.2MG/ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(981,'CATHETER G20',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(982,'CATHETER G16',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(983,'CATHETER G18',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(984,'CATHETER G22',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2177','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(985,'CATHETER G21',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(986,'COSVATE GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(987,'ISLIM SLIMMING PILLS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(988,'PROCOMIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(989,'CLOZOLE CRM[CLOTRIMAZOLE]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(990,'SENSEGRA ORAL GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(991,'GIK 5000ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(992,'METHYLATED SPIRIT 1000ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(993,'DEXTROSE-10 PERCENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2167','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(994,'BECOACTIN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(995,'MYCOTA CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(996,'BETASON S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(997,'ANKLET MEDIUM TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(998,'ANKLET SMALL OAC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(999,'DERMOVATE 25G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1000,'IBUPROFEN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1001,'AMIZOLE METRONIDAZOLE ORAL GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1002,'MYCOTA POWDER 70GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1003,'XAMANA CRM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1004,'CLINDAR-T  PLUS GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1005,'CARNATION CORNCAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1006,'BROZELIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1007,'GV.GENTAIAN VIOLET 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1008,'EPIMAX 125G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1009,'DICLOFENAC 50MG GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1010,'SCOTTS EMULSION ORANGE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1011,'GRIPEWATER WOODWARD 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2145','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1012,'ETORIX 90',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1013,'NILACID 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1014,'SILOXOGENE GEL 180ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1015,'OTOBIOTIC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1016,'GLYCERIN SUPP 49',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1017,'SAYOCAL-FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1018,'VITAMIN  D3 INJ[DEVIT-3]',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1019,'AMLONG 10',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1020,'LEVOFLOXACIN 500MG/100ML IV',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1021,'ANGIZAAR-H',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2134','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1022,'FEXOFENADINE 180MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2133','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1023,'LIPTOMIL PLUS 2',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1024,'WELLKID MULTVIT 1OOML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1025,'CEFPODOXIME CEFPODOX 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1026,'HYDRALAZINE 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1027,'GLYCERINE SUPPOSITORIES CHILD 1GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2126','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1028,'NATOA MEBEDAZOLE BLISTER OF 6S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1029,'CEPHALEXIN 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2123','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1030,'MEBEDAZOLE TIN 1000S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1031,'OSTEOCARE LIQUID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1032,'L-MONTY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1033,'L- MONTY KID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1034,'BETACOR PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1035,'LEVOLUKAST ADULT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1036,'GLODEX DEXAMETHASONE EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1037,'GLIMIDE 5MG/GLIBENCLAMIDE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1038,'ESSNEUROFIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1039,'VITAMIN K INJ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1040,'ATROPINE EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1041,'GLUCOPHAGE XR 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1042,'AMARYL 1MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1043,'CATIS FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1044,'KETOLAC EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1045,'LIQUID PARAFFIN 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1046,'LIQUID PARAFFIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1047,'OTRIVIN CHILD XYLOMETAZOLINE NASAL DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2099','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1048,'GENTAMYCIN INJ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1049,'OMEPRAZOLE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2096','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1050,'BENAFLU TABLETS C-F',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1051,'LIQ P ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2094','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1052,'POWERGESIC PLUS GEL 30GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1053,'OFLOXACIN AND ORNIDAZOLE TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1054,'GLYCERINE 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1055,'CARDACE 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1056,'AMINOSIDINE SYRUP 60ML/ MINODINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2086','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1057,'SCOTT EMULSION ORIGINAL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1058,'FIRST AID BOX SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1059,'FIRST AID BOX COMPLETE/BIG SIZE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1060,'GRANID/ORNIDAZOLE 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1061,'HOUSE RENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1062,'AMPHOTERICIN B INJECTION AMPHIZONE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1063,'METAKIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1064,'KUNGUNIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2077','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1065,'WRITING PADS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2076','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1066,'DOCTORS DUSTCOAT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1067,'BIROPENS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2074','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1068,'TACROLIMUS 0.1 REMUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2073','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1069,'TUSPEL  60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1070,'RABEPRAZOLE RABEMAC 20MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1071,'PARAFAST 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1072,'HEMSAMIC CAPS TRANEXAMIC ACID 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1073,'UNISTEN HC CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2067','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1074,'BUSCOPAN PLUS ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2066','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1075,'NAUMA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1076,'KAMAGRA SILDENAFIL GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2064','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1077,'ANOMEX SUPPOSITORIES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1078,'NEBILONG 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1079,'GAVISCON LIQUID DOUBLE ACTION 150ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1080,'LISTERINE COOL MINT 250ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2059','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1081,'HIV RDT MONOPACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2057','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1082,'LUMARTEM FORTE TABS 6S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2056','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1083,'SONAPEN TABLETS PACKET FULL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1084,'SONATRAX LEVAMISOLE TABLETS PACKET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2054','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1085,'ITOPRIDE GIT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2053','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1086,'STRAPPING 6INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1087,'ACTIFIED RED PACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1088,'FUCICORT 15G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2049','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1089,'TREVIAMET 50/1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1090,'XBETA N',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1091,'CLINDAMYCIN 150MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2043','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1092,'NASITHIOL PROMETHAZINE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1093,'EMULSFYING OINTMENT 500G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1094,'EMULSFYING OINTMENT 100G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1095,'POVICON POVIDONE IODINE 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1096,'BETROZOLE TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2036','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1097,'TOOTH TINCTURE MENOFRESH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2035','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1098,'BETROZOLE 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1099,'BETROZOLE 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1100,'NYLON SURGICAL SUTURES 2\\0 RB NON ABSORBABLE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2032','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1101,'CHROMIC CUTGUT2/0 ROUND BODY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1102,'AZZIR ACICLOVIR TABLLETS 400MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1103,'BUDECORT 200MCG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1104,'CEFTAFAIR-SB CEFTRIAXONE AND SULBACTAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2027','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1105,'MOMESON MOMETASONE NASAL SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1106,'KETAMINE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1107,'MOMATE MOMETASONE SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1108,'DOLOACT MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1109,'PROMETHAZINE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1110,'METHYLATED SPIRIT 50ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1111,'TRICOF GREEN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1112,'WATERGUARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1113,'ZINNAT 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1114,'P2  ORIGNAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1115,'SURGICAL SPIRIT 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1116,'LYSER D',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1117,'LEVOCETRIZINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1118,'SAVLON 75ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1119,'ENO CAL ANTACID TABS 100',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1120,'LEFOAM PAED DROPS 15ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1121,'FLORAL EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1122,'CHLORAMPHENICOL 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1123,'CHLORAMPHENICOL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1124,'ASPA SWEET PACK 450',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1125,'FLAMCHECK MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1126,'TETMOSOL SOAP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'2000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1127,'50% DEXTROSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1999','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1128,'MPESA XX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1998','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1129,'STRAPPING 4INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1997','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1130,'STRAPPING 3INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1996','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1131,'STRAPPING 2INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1995','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1132,'STRAPPING 1INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1994','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1133,'TACROVATE 0.1',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1993','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1134,'AUGMENTIN ORIGNAL 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1992','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1135,'NEUROCARE PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1991','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1136,'CLOPIDOGREL 75MG COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1990','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1137,'COPHYDREX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1989','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1138,'MOMS MAGIC GRIPEWATER 100ML.',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1988','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1139,'PURECAL TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1984','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1140,'FARM LINEMENT 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1983','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1141,'TACROVATE 0.03%',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1982','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1142,'DEEP FREEZE SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1981','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1143,'DEEP FREEZE GEL 35GM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1980','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1144,'BENASED MUCOLYTIC 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1978','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1145,'BENASED CHESTY 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1977','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1146,'ALLUCID SUSP 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1976','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1147,'GYNAECOSID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1975','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1148,'CLOMID 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1974','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1149,'ENTAMAXIN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1973','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1150,'ENTAMAXIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1972','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1151,'PEPGEL ANTACID SYP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1971','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1152,'RELCER GEL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1970','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1153,'VERMOX SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1969','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1154,'L- MONTUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1967','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1155,'ACTIFED WET AND COLD GREEN PACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1966','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1156,'SEVEN SEAS 170ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1965','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1157,'CARDITAN 50MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1964','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1158,'CEFIXIME SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1963','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1159,'XPEN 5MEGA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1960','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1160,'P-ALAXIN SUSPENSION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1959','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1161,'CRUTCHES UNDER ARM PAIR MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1956','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1162,'TRIDEX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1955','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1163,'GRABACIN POWDER 10G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1953','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1164,'CRAVE AWAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1951','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1165,'CANDID B SMALL 15G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1950','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1166,'AL LONART\\GAME 6,S CHILD DOSE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1948','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1167,'METHYLATED SPIRIT  500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1947','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1168,'BENASED DRY 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1946','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1169,'POWERCEF 1G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1945','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1170,'ALDACTONE 25MG ORIG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1944','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1171,'LEXOTANIL 1.5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1943','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1172,'ENCORATE 200MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1942','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1173,'NEBILONG H',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1940','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1174,'IMACOF 100ML.PEAD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1938','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1175,'FLONA SPRAY',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1937','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1176,'TAMEPYN TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1936','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1177,'DENTOGEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1934','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1178,'GRABACIN 3 CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1933','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1179,'PERNEX AC 20G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1932','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1180,'PONSTAN FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1931','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1181,'BRUSTAN TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1930','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1182,'CASTOR 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1929','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1183,'RHINACON  CARBOCISTEN/PROMETHAZIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1928','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1184,'BROZEDEX 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1927','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1185,'CONTRIZET-D 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1926','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1186,'RELCER TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1925','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1187,'DAWAHIST100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1924','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1188,'EFLARON PLUS TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1923','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1189,'SENNA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1922','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1190,'ACEPAR SP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1921','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1191,'DELFLAM CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1920','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1192,'KISS CHOCOLATE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1919','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1193,'SUBSYDE GEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1918','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1194,'ENZOFLAM TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1917','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1195,'SAVLON 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1914','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1196,'RINGERS LACTATE .HARTMANNS SOLUTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1913','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1197,'GLOVATE/CLOBETASOL PROPIONATE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1912','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1198,'CIMETIDINE CEMET 400MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1910','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1199,'DYNA WRIST SPLINT MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1909','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1200,'ELASTIC WRIST SPLINT MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1907','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1201,'ELASTIC WRIST SPRINT LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1906','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1202,'ELASRIC WRIST SPRINT SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1905','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1203,'COMPRESSION STOCKING BELOW KNEE CLASSIC XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1903','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1204,'COMPRESSOIN STOCKING BELOW KNEE LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1902','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1205,'LUMBO SACRAL BELT XXXL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1901','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1206,'LUMBO SACRAL BELT XXL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1900','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1207,'LUMBO SACRAL BELT XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1899','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1208,'LUMO SACRAL BELT LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1898','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1209,'CONTOURED LS SUPPORT LUMBO SACRA LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1897','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1210,'LUMBO SACRAL  SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1896','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1211,'DYNA  ARM SLING MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1895','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1212,'ARM SLING XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1894','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1213,'CYPON 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1893','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1214,'CARDITAN H 50',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1890','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1215,'WRIST SPLINT WITH THUMB TYNOR MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1889','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1216,'ANKLE SPLINT UNIVERSAL SIZE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1888','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1217,'ARM SLING LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1886','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1218,'ARMSLING MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1885','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1219,'ARM SLING SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1884','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1220,'ARMSLING JUNIOR 50-60CM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1883','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1221,'MANUAL BREAST PUMP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1222,'PARACETAMOL BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1881','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1223,'STETHOSCOPE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1880','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1224,'MEDIVEN S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1879','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1225,'GOODMORNING TAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1877','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1226,'KALUMA PAIN BALM 7ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1876','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1227,'KALUMA PAIN BALM 9ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1875','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1228,'SONADOL BLUE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1874','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1229,'NUTRIVITA 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1873','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1230,'FILWEL KIDS MULTIVITAMIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1872','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1231,'ETR 60 ETEROCOXIB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1871','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1232,'KARVOL INHALER CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1870','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1233,'ASHTON ORIGINAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1869','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1234,'VITA HEALTH OMEGA 3 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1866','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1235,'REMIDIN MOUTH WASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1865','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1236,'BECOACTIN 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1864','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1237,'PONTEL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1863','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1238,'PARACETAMOL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1861','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1239,'PRENAN 400G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1859','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1240,'NAN 1 400G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1858','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1241,'SONATEC MOUTH WASH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1856','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1242,'ZECUF COUGH SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1855','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1243,'RIFAMBICIN 300MG RIFACOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1854','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1244,'TRIHISTAMIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1853','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1245,'DACOLD CAPS BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1852','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1246,'SONAPEN  9ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1851','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1247,'CLINDAMYCIN 300MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1850','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1248,'DAWAHIST60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1849','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1249,'TAGERA FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1846','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1250,'GAUZE ROLL 750G',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1845','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1251,'PREDNISOLONE BLUE GEN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1844','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1252,'NEOCILOR DESLORATADINE SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1843','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1253,'BETASERC',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1842','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1254,'TAMSOLIN 0.4MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1841','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1255,'VARINIL 10MG AMLODIPINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1840','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1256,'STERILE GAUZE SWAB',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1839','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1257,'STRAPPING ZINC OXIDE 4INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1838','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1258,'INFA V',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1836','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1259,'DIAZEPAM INJ 5MJ/ML 2ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1260,'PLASIL METOCLOPROPAMIDE INJECTION 10MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1834','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1261,'CRUTCHES ELBOW PAIR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1832','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1262,'MENOFRESH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1830','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1263,'LORATADINE LORVIC SYRUP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1829','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1264,'PREDFORTE EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1827','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1265,'ESOSE 40MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1826','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1266,'DIAMICRON MR GLICLAZIDE 60MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1267,'ICON MOSQUITO REPPELLANT 62.5MLS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1824','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1268,'LORNEX-FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1822','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1269,'PRESATAN H 50',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1820','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1270,'KALUMACOF',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1271,'DOLOMED MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1817','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1272,'BUSCOPAN GEN 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1816','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1273,'ZINC OXIDE ADHESIVE PLASTER WHITE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1814','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1274,'AMINOPYLINE INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1275,'DEXOMET N',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1276,'BETOPTIC EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1277,'MYOCOR MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1278,'DOXAFIN 5MG DESLORATADINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1279,'HISTALYN EYE DROPS SODIUM CROMOGLYCATE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1280,'SOLUWAX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1281,'MASTGUARD',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1282,'FERRO B 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1283,'FERRO B 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1800','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1284,'DEXTROCERIN NASAL DROPS DEXTROSE AND GLYCERINE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1799','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1285,'AMARYL 2MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1798','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1286,'AMLOZAAR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1797','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1287,'AMLOZAAR-H',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1796','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1288,'CLOTRIMAZOLE EAR DROPS CANDID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1795','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1289,'AMLODIPINE VARINIL 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1794','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1290,'TENORIC 100MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1793','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1291,'BEUFLOX-D',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1792','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1292,'BENAGYL 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1791','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1293,'ESOMAC 40MG CIPLA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1790','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1294,'TRICART',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1789','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1295,'ZEFCOLIN 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1787','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1296,'AMOXYCLAV 457MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1786','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1297,'EMULSFYING OINTMENT 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1784','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1298,'NICORETTE NICOTINE GUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1782','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1299,'LUMBOSACRAL MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1781','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1300,'RENERVE  PLUS BT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1780','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1301,'RENERVE PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1779','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1302,'BUSCOPAN TABLETS GENER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1778','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1303,'FARM LINEMENT500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1777','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1304,'MIXTARD 70\\30',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1776','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1305,'CLOTRINE B CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1775','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1306,'PARACETAMOL 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1774','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1307,'METHYLATED SPIRIT 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1773','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1308,'HTC HERBIGOR100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1772','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1309,'SILVER SULFADIAZINE TIN 250MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1771','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1310,'VITAMIN B COMPLEX INJECTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1770','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1311,'PIRITON 60 ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1769','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1312,'AMOXYCLAV 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1766','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1313,'DACOLD SUSPENSION 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1763','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1314,'ACTION',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1762','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1315,'SONAMOJA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1761','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1316,'TRUST CLASSIC CONDOM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1760','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1317,'ZAART H',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1759','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1318,'BROMSOL 100 ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1757','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1319,'EFLARON PLUS 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1756','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1320,'FLAMACOR MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1755','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1321,'ORNIDAZOLE/DIAROBIC 500MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1754','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1322,'ARM SLING MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1753','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1323,'MALODAR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1752','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1324,'SAVLON 500ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1751','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1325,'VITA HEALTH OMEGA 3 200ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1749','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1326,'PREGNACARE PLUS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1748','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1327,'PREGNACARE ORIGNAL TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1747','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1328,'KALUMA STRONG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1746','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1329,'KALUMA INHALER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1330,'PIRITON 5LITRE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1744','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1331,'CYCLOPAM TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1743','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1332,'HYDROCORTISONE EYE DROPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1742','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1333,'BENASED PAED 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1741','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1334,'BENASED DRY 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1739','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1335,'BENASED CHESTY 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1738','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1336,'MICLOCIN CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1737','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1337,'AMOXYL 100ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1736','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1338,'DIRACIP M TABS 30S',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1733','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1339,'DIRACIP DS TABLETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1732','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1340,'COPHYDREX 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1731','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1341,'MICROFINE INSULIN SYRIGE 1ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1729','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1342,'INSULIN  SYRIGES GEN.',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1728','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1343,'MICR0FINE INSULIN SYRIGES 0.5ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1727','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1344,'RUBEM CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1726','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1345,'SEPTRIN 60ML COTRIMOX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1725','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1346,'PHARMASAL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1724','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1347,'TUMBOCID BLISTER',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1723','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1348,'NEEDLE G23',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1721','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1349,'NEEDLES G21',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1720','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1350,'DEPO INJ',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1719','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1351,'IBUPROFEN SYRUP 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1718','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1352,'LEVAMISOLE TIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1716','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1353,'ZULU',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1715','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1354,'ZULU MR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1714','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1355,'SONACOF TBS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1713','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1356,'IBUPAR 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1712','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1357,'AMOXYL 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1711','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1358,'BENAFLU 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1710','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1359,'MEDIKEEL LOSENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1709','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1360,'PARAFAST 1000MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1708','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1361,'SYRINGES 2ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1706','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1362,'I.V GIVING SETS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1704','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1363,'STOPACID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1703','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1364,'BALLET',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1365,'SONADOL XTRA',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1366,'EMPTY BOTTLES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1700','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1367,'TRIBEES FORTE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1699','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1368,'CARBIMAZOLE 5MG CARAL/ANTITHROX',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1698','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1369,'MAXITROL EYE OINTMENT',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1697','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1370,'AUGMENTIN 375',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1695','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1371,'OLANZAPINE DEPREX 5MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1694','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1372,'HEPARIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1693','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1373,'OPELE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1692','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1374,'XSONE  N',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1688','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1375,'CHLORPROMAZINE  100MG TABS COSMOS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1687','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1376,'FINOSIN',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1686','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1377,'PREGNANCY TEST STRIPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1685','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1378,'KALUMA KING LOZENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1379,'SONASIL LOZENGES',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1680','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1380,'DICLOFENAC GEL 25MG',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1679','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1381,'AMPICLO DAWA 10ML NEONATAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1657','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1382,'PHYTOMENADION INJECTION BP 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1383,'BLOOD LANCETS FLAKE TYPE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1650','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1384,'METRONIDAZOLE 400MG  BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1614','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1385,'GLYFORMIN 850MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1613','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1386,'DEXTROSE 5%',1,'single',1,NULL,NULL,NULL,3,NULL,NULL,'inclusive',1,0.0000,'1562','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1387,'BENAHIST 100ML',1,'single',1,NULL,NULL,NULL,4,NULL,NULL,'inclusive',1,0.0000,'1557','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1388,'ENAPRIL  5MG [INTAS]',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'1547','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1389,'ENAPRIL 10MG',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'1546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1390,'NEXIUM 40MG',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'1517','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1391,'ENARIL - 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1470','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1392,'ENALAPRIL 10MG GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1468','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1393,'LATEX EXAMINATION GLOVES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1408','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1394,'SURGICAL SPIRIT 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1359','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1395,'PIRITON CHROPHENIRAMINE TABS TIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1325','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1396,'SKIN TRACTION SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1320','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1397,'TOUCH AND GO TOOTHACHE SOLUTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1290','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1398,'GOODMORNING 60ML',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1285','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1399,'NORASH CREAM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1283','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1400,'DERMIKELP',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1401,'TERBINAFINE CREAM ONCOSIL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1402,'LEVOLUKAST KID',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1280','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1403,'COMPRESSION STOCKINGS MID THIGH XL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1279','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1404,'COMPRESSION STOCKING MID THIGH LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1278','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1405,'COMPRESSION STOCKING BELOW KNEE MEDIUM',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1277','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1406,'COMPRESSION STOCKING BELOW KNEE SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1276','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1407,'ANKLE SUPPORT OAC SMALL',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1275','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1408,'ANKLE SUPPORT  XL TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1274','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1409,'ANKLE SUPPORT ANKLET LARGE',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1410,'KNEE CAP LARGE TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1272','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1411,'KNEE CAP SMALL TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1412,'KNEE CAP MEDIUM TYNOR',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1270','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1413,'WOW 4INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1269','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1414,'WOW 6INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1268','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1415,'WOW 3INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1267','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1416,'WOW 2INCH',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1266','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1417,'MEFENAMIC ACID 500MG CAPS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1418,'AMOXYL 250MG BLISTER PACK',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'1262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1419,'DOXYCYCLINE CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1420,'FEMIPLAN PILLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1257','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1421,'CARTIFLEX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1422,'CIPROFLOXACIN 500MG GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1254','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1423,'ADJUST CENTS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1253','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1424,'UNIACTIN SYRUP  100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1425,'CLOBETASOL CREAM COSVATE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1426,'I.V CANULLA G22 BLUE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1427,'IVYCROM EYE DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1244','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1428,'STERAMINE 30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1243','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1429,'AVODINE 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1430,'IBUPROFEN 400MG BLISTER TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1431,'DEXAMETHASONE TABS 0.5MG BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1237','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1432,'CAPTOPRIL 25MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1433,'H.PYLORI KIT HELICOBAN KIT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1233','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1434,'VENTOLIN EVOHALER 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1435,'PLASIL METOCLOPRAMIDE TABS 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1231','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1436,'VITAMIN E  EVIT  400MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1230','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1437,'NEURO-FORTE TABS CENTAUR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1229','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1438,'DASANI 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1439,'LANSOPRAZOLE LAZOPE CAPS 30MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1224','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1440,'MICROLUT TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1223','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1441,'BROMODEL 2.5MG BROMOCRIPTINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1442,'GYNO KIT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1443,'CANDID -V6 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1220','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1444,'CANDID V-1 CLOTRIMAZOLE USP 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1218','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1445,'BUSCOPAN INJECTION 20MG/ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1446,'CHLORPROMAZINE INJECTION 50/2ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1447,'DIGOMET-125 TABS 125MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1448,'MONTECOR PLUS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1449,'POVIDONE DAWADINE  ANTISEPTIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1450,'DELASED CHESTY 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1451,'TAMOXIFEN CITRATE TABS 20MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1452,'CEFUROXIME/THEOROXIME TABS 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1453,'BENZATHINE PENICILIN 2.4MEGA PANANDUR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1454,'FLUCLOXACILLIN INJ 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1199','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1455,'AMPICLOX-DAWA 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1196','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1456,'LOBAK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1457,'FLUCONAZOLE 150',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1458,'TETRACYCLINE EYE OINTMENT 3.5G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1459,'GENTAMICIN SULPHATE EAR/EYE DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1460,'PROLOXIN EAR/EYE DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1461,'CILOXAN CIPROFLOXACIN OPTHALMIC SLN 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1462,'FLUCLOXACILLIN 250 MG CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1463,'RILIF MR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1464,'AZITHROMYCIN TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1465,'AMOXYCLAV 625MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1466,'BETA GRIPE 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1467,'SKIN TRACTION KIT CHILD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1164','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1468,'ACNESOL CREAM 25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1469,'GAUZE R0LL 1.5KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1470,'MOTESONE CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1471,'CIPLADON 1000MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1472,'PRAZITEL PRAZIQUANTEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1473,'EMETON SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1474,'BETADINE MOUTHWASH 125ML ORIGNAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1475,'MULTIVITAMIN SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1476,'IVERMECTIN TABLETS 3MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1477,'NEBANOL  POWDER 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1478,'EROSTIN SUSPENSION 60ML EBASTINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1479,'CEFUROXIME 250MG TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1480,'FANLAR TABS CURATIVE-PREVENTIVE ANTMALARIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1481,'COLDCAP ORIGINAL B.P CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1482,'CITAL SYRUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1483,'TINTURE OF IODINE 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1484,'ETORICOXIB ECOFREE 90MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1485,'SURGICAL SPIRIT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1486,'CATAFLAM 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1487,'SURGICAL GLOVES 7.5 INCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1488,'PHENOBARBITAL TABLETS COSMOS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1489,'HUMILIN 70/30 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1490,'MONTELUKAST MONTY 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1491,'SURGICAL BLADES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1492,'BISACODYL GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1493,'STREPTOMYCIN 1G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1494,'BLOOD LANCET 100S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1495,'ANUSTAT OINTMENT OINTMENT 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1496,'ONCALL GLUCOMETRE MACHINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1497,'ORS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1498,'METRONIDAZOLE 200MG LOOSE 1000S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1499,'ATROPINE INJECTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1094','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1500,'CALPOL SUSPENSION 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1501,'PROBETA N DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1502,'ZINC DISPENSABLE TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1503,'BENASED MUCOLYTIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1504,'DIAMISOLE[DILOXANIDE ANDMETRONIDOZOLE]',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1505,'BENAGAS GEL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1087','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1506,'BLOOD PRESSURE MACHINE OMRON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1507,'FLUCONAZOLE(ECOZOLE) 35ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1508,'DAKTARIN ORAL GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1509,'TRIPPLE PEN 6:3:3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1510,'CALVLON/SALVLON GERMS KILLER 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1511,'CEFIXIME 400MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1077','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1512,'CEFADROXIL 125MG/CEXIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1074','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1513,'BENAHIST  EXPECTORANT 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1073','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1514,'CATOXYMAG NSYMP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1515,'COTTON WOOL 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1516,'SCOTTS EMULSION ORANGE 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1517,'COTTON WOOL 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1069','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1518,'TELMI 40',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1519,'DISPOSABLE COLOSTOMY BAG 20PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1066','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1520,'VEGA SILDENAFIL TABS 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1521,'CASTOR OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1522,'PHENYTOIN TABLETS B.P 100MG (COATED)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1062','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1523,'ZESTORETIC 20MG LISINOPRIL HCTZ',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1524,'LAEOVATE BETAMETHASONE CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1525,'EPILIM CONTROLLED RELEASE CHRONO 300',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1057','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1526,'EPILIM 200 ENTERIC COATED TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1056','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1527,'RINS MOUTHWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1528,'MEDIVEN  CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1053','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1529,'ANUSOL OINTMENT 25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1530,'ANUSOL SUPPOSITORIES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1531,'POWEGESTIC GEL 30G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1532,'ANTI-RABIES / ABHAYRAB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1049','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1533,'CARVEDILOL 12.5 CARVAS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1047','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1534,'OXYTOCIN INJECTION 10 I.U',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1535,'ZYRTAL MR ACECLOFENAC TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1536,'FUTSIL HERBAL ANTISEPTIC 15ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1537,'FLUGONE-P 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1043','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1538,'FLUGONE-DM 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1042','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1539,'AXE  BRAND UNIVERSAL OIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1039','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1540,'DOBESIL H CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1541,'DENTINOX TEETHING GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1542,'COTTON 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1543,'REJUVA STARS CAPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1032','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1544,'LIQUID PARAFFIN MINERAL OIL 30ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1545,'BENZHEXOL TABLETS BP GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1546,'RIVOTRIL CLONAZEPAM 2MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1547,'DIHYDROCODEINE TABLETS FOR ORAL USE 30MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1548,'AMITRIPTYLINE TABLETS BP 25MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1549,'POVIDONE IODINE ANTISEPTIC 500ML SINAI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1550,'FLORANORM SACCHAROMYCES BOULARDII',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1551,'ENTAMAXIN CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1552,'NEUROBIONE FORTE GEN.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1553,'CARTIL OMEGA ADVANCED JOINT CARE FORMULA CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1554,'CARTIL FORTE GLUCOSAMINE + CHONDROITIN TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1555,'SOLVIN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1556,'BG-GLUTAMIN TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1557,'SPOT ON HOT GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1558,'CARTIFLEX FORTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1559,'NEUROVEN CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'1000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1560,'NEUROBIONE-FORTE MEPHA ORIGNAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'999','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1561,'BENAGYL - DF TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'996','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1562,'DAB0RAL 250 TABS AMINOSIDINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'995','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1563,'GABBRORAL AMINOSIDINE 250MG  TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'993','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1564,'GINSOMIN KOREAN PANAX GINSENG EXTRACT WITH MULTIVITAMINS &MINERALS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'992','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1565,'PREDNISOLONE  SYRUP SOLONE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'990','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1566,'MONTALLERG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'988','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1567,'PROMETHAZINE  TABS 25MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'987','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1568,'MOMENTO DESLORATADINE 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'986','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1569,'METHOTRIXATE UNITRIXATE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'985','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1570,'FLUGONE CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'984','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1571,'LORHISTINA TABS 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'983','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1572,'AERIUS DESLORATADINE 5MG FILM- COATED TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'982','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1573,'STUGERON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'979','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1574,'ALBENDAZOLE SUSPENSION GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'978','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1575,'PREGNIDOXINE DOXYLAMINE SUCCITE PYRIDOXINE HYDROCHLORIDE TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'977','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1576,'PODOSAL PAINT FOR TREATMENT OF ANO-GENITAL AND COMMON WARTS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'974','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1577,'AZITHROMYCIN ORAL SUSPENSION  15 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'972','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1578,'PREDNISOLONE TABS BP -BLUE COSMOS 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'971','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1579,'ETAMSYLATE SYLENT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'970','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1580,'WARE -5 SODIUM TABS WARFARIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'968','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1581,'PODOSAL OINTMENT FOR TREATMENT OF PLANTER WARTS 10GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'966','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1582,'TRANEXA 500MG TRANEXAMIC ACID TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'965','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1583,'SENSODYNE MULTICARE 40ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'963','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1584,'I.V CANULLA G20 PINK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'960','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1585,'HOMAGON CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'959','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1586,'COLDFLU CAP BLISTER PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'957','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1587,'ACICLOVIR CREAM DAVIR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'956','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1588,'FLUCOLDEX COLD + FLU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'955','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1589,'DIRACIP - SUSPENSION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'951','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1590,'AUGMENTIN  POWDER FORM 457MG/5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'950','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1591,'DABORAL SYRUP 60ML AMINOSIDINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'949','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1592,'ZINNAT  SUSPENSION 125MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'948','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1593,'ALEZE-300 ALLOPURINOL TABS  300MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'947','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1594,'ALEZE -100  ALLOPURINOL TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'946','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1595,'FLUCLOXACILLIN 125MG/5ML 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'945','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1596,'LIDOCAINE WITH ADRENALINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'944','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:29','2025-03-17 05:47:29'),(1597,'CEFUROXIME  SUSPENSION 50ML 125MG GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'941','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1598,'DUO-COTECXIN DIYHDROARTEMISININE 40/320',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'940','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1599,'PODINE MOUTHWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'939','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1600,'LOPERANIDE CAPSULES USP 2MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'937','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1601,'COTTON WOOL 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'933','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1602,'ERYTHROMYCIN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'927','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1603,'AMPICLOX 250MG/5ML ORIGNAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'925','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1604,'NICOF EXPECTORANT 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'922','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1605,'SALBUTAMOL TABS BLISTER 4MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'920','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1606,'ERYTHROX ERYTHROMYCIN 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'919','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1607,'PYRIDOXINE TABLETS BP 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'918','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1608,'FAST PARACETAMOL SUPPOSITORIES 250MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'916','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1609,'CACHET PARACETAMOL   SUPPOSITORIES 125MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'914','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1610,'AVAMYS FLUTICASONE FUROATE NASAL SPRAY SUSPENSION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'913','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1611,'ESOSE-20 TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'909','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1612,'HB RICH PLUS 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'908','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1613,'FORALIN INHALER 200 WITH DOSE INDICATOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'903','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1614,'ARTEQIUCK ARTEMISININ AND PIPERAGUINE TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'901','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1615,'ESCLAM KIT ORIGNAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'900','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1616,'BUDECORT 100MCG BUDESONIDE INHALER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'899','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1617,'PURECAL CALCIUM SYRUP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'893','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1618,'PROSFIN FINASTERIDE 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'891','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1619,'VDM-KIT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'888','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1620,'AL 24S LONART',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'887','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1621,'CIPHENE CLOMIFENE CITRATE TABS 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'886','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1622,'DUPHASTON DYDROSTERONE 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'884','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1623,'MALAFIN SULPHAMETHOXYPYRAZINE U.S.P 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'883','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1624,'CETRIZINE SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1625,'SECNIDAZOLE TABLETS 1G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'880','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1626,'KLY LUBRICATING JELLY 42G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'877','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1627,'SUSTEN 200 CAPSULES 200MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'876','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1628,'DUB-STERONE TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'874','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1629,'STERON NERETHISTERONE TABS 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'873','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1630,'3AM KIT FLUCONAZOLE TABS/G-CURE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'871','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1631,'FOLIC ACID TABLETS BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'870','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1632,'MICROGYNON ORIGNAL 30 ORIGNAL GREEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'869','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1633,'LASIX FRUSEMIDE TABLETS BP 40MG COSMOS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'868','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1634,'ASCORBIC ACID BP 250MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'867','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1635,'IBUPROFEN 200MG  BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'864','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1636,'TINIDAZOLE TABS 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'857','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1637,'NITROFURANTOIN TABS 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'853','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1638,'CARTIMOVE D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'849','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1639,'ERYTHROMYCIN TABS 250MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'848','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1640,'NO-SPA DROTAVERINE 40MG TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'845','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1641,'NORFLOXACIN NORMAX  STRIP OF 10 TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'843','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1642,'GABAPENTIN/ GABA 300MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'842','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1643,'ITRAMET ITRACONAZOLE CAPSULES 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'839','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1644,'KETOCONAZOLE TABS 200MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'837','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1645,'GRISEOFULVIN TABS 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1646,'NORFLOXACIN TABS 400MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'833','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1647,'GRISEOFULVIN TABS 250MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'832','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1648,'MYOSPAZ CHLORZOXAZONE AND PARACETAMOL TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'830','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1649,'OLFEN-100 SR DICLOFENAC SODIUM ANTI-INFLAMMATORY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'829','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1650,'MZ CAL PLUS CALCIUM SUSPENSION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'827','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1651,'EPIBALIN PREGABALIN CAPSULES 75MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'820','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1652,'FASTUM GEL 30GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'819','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1653,'DICLOFENAC SODIUM SUBSYDE-CR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1654,'AMPICLOX- CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'817','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1655,'AIRTAL 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'816','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1656,'ERYTHROMYCIN TABLETS 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'814','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1657,'LACTONE SPIRONOLACTONE BP 25MG TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1658,'SPIROLAC /SPILLAR /LACTONE SPIRONOLACTONE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1659,'LOSARTAS -HT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1660,'DIGOXIN TABLETS B.P 0.25MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1661,'CARDISPRIN ENTERIC COATED TABLETS 75MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1662,'DIURIDE - 10 TABS  10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1663,'ATORVASTATIN 20MG GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'797','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1664,'QUININE 2ML INJECTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'794','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1665,'QUININE MIXTURE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'791','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1666,'CONFERON 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'789','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1667,'MOTILIUM DOMPERIDONE 10MG ORIGNAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'788','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1668,'LEVOFLOXACIN 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'786','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1669,'BORIC ACID IN SPIRIT EAR DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'781','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1670,'AUGMENTIN TABS 625MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'780','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1671,'CHLORAMPHENICOL EYE DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'779','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1672,'DOMPERIDONE TABLETS 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'777','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1673,'AMOXYCLAV 228.5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'768','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1674,'DIGITAL THERMOMETER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'765','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1675,'AMOXYCLAV 375 TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'763','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1676,'CIPROKEN CIPROFLOXACIN EYE DROPS  USP 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'757','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1677,'PREDSOLONE EYE DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'756','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1678,'IVYDEXGENT DEXAMETHASONE &GENTAMICIN EAR/EYE DROPS 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'755','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1679,'AUGMENTIN 228MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'754','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1680,'TEARS NATURALE II ARTIFICIAL TEARS 15ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'752','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1681,'MINERAL WATER 1LITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'747','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1682,'MINERAL WATER 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'746','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1683,'IVYMOICELL EYE DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1684,'MINERAL WATER 5LITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'744','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1685,'LAEOVATE N EYE DROPS 7.5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'743','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1686,'DOBESIL CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'742','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1687,'MAXITROL EYE DROPS 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'741','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1688,'TML EYE DROPS TIMOLOL MALEATE USP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'739','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1689,'FRESHA MOUTHWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'738','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1690,'TRIMEX MUCOLYTIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'737','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1691,'ALLERGO-COMOD EYE DROPS  10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'735','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1692,'POLYTROL EYE DROPS 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'733','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1693,'VEGA SILDENAFIL 50MG TABS',1,'single',1,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,0.0000,'731','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1694,'METRONIDAZOLE 100ML SYRUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'730','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1695,'DICLOGENTA STERILE EYE DROPS 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'729','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1696,'MEDICAL ENVELOPES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'727','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1697,'CHLORAMPHENICOL  EAR DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'724','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1698,'OFLODEX (OFLOXACIN + DEXAMETHASONE) STERILE EYE/EAR DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'722','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1699,'OTOREX EAR DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'717','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1700,'LUVMAX ORAL JELLY 100MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'714','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1701,'HCTZ COSMOS TABS 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1702,'HOVITE SYRUP 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'698','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1703,'PREDNISOLONE TABS BP -WHITE COSMOS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'697','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1704,'CYPRO B PLUS TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'693','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1705,'GLUCOMET 850MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'692','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1706,'SAVLON/ ALLSEPT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'691','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1707,'GLUCOPHAGE 850MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'690','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1708,'GLYFORMIN 500 ANTIDIABETIC AGENT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'689','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1709,'SEVEN SEAS  COLD LIVER OIL CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'687','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1710,'TELMI 40H',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'686','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1711,'PIOGLUC 15MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'685','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1712,'ARTEMETHER NJECTION  80MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'684','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1713,'CONDOM CATHETER EXTERNAL USE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'683','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1714,'CREPE BANDANGE 4 INCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'682','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1715,'LIQUID P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1716,'NOGLUC GLIBENCLAMIDE TABLETS BP 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'680','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1717,'CLINICAL THERMOMETER/ANALOG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'679','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1718,'BETANASE GLIBENCLAMIDE TABLETS BP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'678','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1719,'GLUCOMET- N',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'675','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1720,'HEMOSAN CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'674','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1721,'OMEGA 3 FISH OIL VALUPAK LOOSE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'671','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1722,'KENACORT INJECTION TRIMCINOLONE ACETONIDE I.P 1ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'667','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1723,'FRUSEMIDE INJECTION B.P 20MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'665','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1724,'ELASTOPLAST/SUREPLAST/SONAPLAST',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'664','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1725,'ENO POWDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'663','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1726,'DEPO-MEDROL 80MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'662','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1727,'FLATAMEAL TABLETS - DS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'660','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1728,'HCQS HYDROXYCHLOROQUINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'659','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1729,'AMIKANEX AMIKACIN SULFATE INJECTION USP 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1730,'MARA MOJA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'657','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1731,'DIASIX FUROSEMIDE INJECTION BP 10MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'655','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1732,'I.V CANULLA G18 GREEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'653','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1733,'PARACETAMOL INJECTION 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'652','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1734,'ONCALL PLUS BLOOD GLUCOSE TEST STRIPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1735,'PPF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'648','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1736,'PANADOL EXTRA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'647','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1737,'DELUXE STUDDED',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'646','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1738,'STERILISED WATER FOR INJECTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'643','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1739,'ACTAL TUMS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'642','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1740,'PANADOL ADVANCE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'641','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1741,'DICLOFENAC INJECTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'640','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1742,'HEDEX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'638','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1743,'HYDROCORTISONE INJECTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'637','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1744,'FLUCLOXACILLIN 500MG CAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'634','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1745,'BLOOD TRANSFUSION SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'632','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1746,'ES0MAC CIPLA 40MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'631','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1747,'URINE BAG 2000ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'630','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1748,'JOINTFIX CAPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'629','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1749,'SURGICAL SPIRIT 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'625','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1750,'BENYLIN 4 FLU 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'623','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1751,'BETAPYN TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1752,'BYOFER 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'600','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1753,'SEPTRIN COTRIMOXAZOLE 100ML SUSPENSION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'596','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1754,'SCOTTS EMULSION ORIGNAL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'580','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1755,'BIOCHEM BIO-PIT 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'579','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1756,'PLASTER OF PARIS 8INCHES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'578','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1757,'CREPE BANDAGE 2 INCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'577','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1758,'NILACID 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'561','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1759,'BENASTEN B  CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'548','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1760,'SEVIN DUDU.DUST 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1761,'BENASTEN MIXI CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'545','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1762,'SEVIN DUDU.DUST 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'544','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1763,'BULKOT MIXI CREAM 20G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'543','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1764,'DAZOLE B CREAM 20G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'542','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1765,'KLENZIT -C GEL 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'541','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1766,'BETAMED BETAMETHASONE CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'540','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1767,'TETRACYCLIN SKIN OINTMEN 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'539','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1768,'EXEVATE-MF BETAMETHASOME DIPROPIONATE 20GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'537','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1769,'CLOB -B SKIN CREAM 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'536','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1770,'HYDROCORTISON CREAM 15GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'533','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1771,'BECLOMIN ANTI-INFLAMMATORY 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'531','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1772,'CLOTRIMAZOLE CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'530','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1773,'CLARITECK 50ML CLARITHROMYCIN 125MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'529','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1774,'CELECOXIB 200MG COX-B',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1775,'CLOZOLE B 10G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'527','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1776,'WHITFIELDS OINTMENT 15GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'526','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1777,'BURNOX CREAM 15GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'525','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1778,'VOLINI GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'524','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1779,'ELYVATE BETAMETHASONE VALERATE CREAM 15GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'523','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1780,'SYRINGE 20ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'522','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1781,'ANTIHIST MEPYRAMINE /HISTARGAN CREAM 20 GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'520','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1782,'SYRINGE 5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1783,'HITORAL KETOCONAZOLE  SHAMPOO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1784,'SULPHUR SKIN OINTMENT 20GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'517','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1785,'PLASTER OF PARIS BANDAGE 6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'516','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1786,'PREDNISOLONE TABLETS   WHITE GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1787,'INDOMETHACIN B.P 25GM BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1788,'CREPE BANDAGE 6 INCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1789,'METRONIDAZOLE INTRAVENOUS I.V',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1790,'KNEE CAP SUPPORT OAC XL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'498','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1791,'SKIN TRACTION KIT ADULT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'497','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1792,'MEFENAMIC ACID  BP 250MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'496','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1793,'CALCINOL 1000MG POWDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'495','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1794,'DENTAMOL ACETAMINOPHEN TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'492','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1795,'DICLOMOL SR 100TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'488','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1796,'MULTIVITAMIN  SYRUP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'487','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1797,'AMPICLOX-DAWA 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'486','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1798,'PARACETAMOL SUSPENSION 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'483','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1799,'P-ALAXIN TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'481','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1800,'RANFERON SYRUP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'479','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1801,'HAEMOBEN BLOOD BUILDER TONIC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'477','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1802,'HAEMOBEN BLOOD BUILDER TONIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'476','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1803,'FIESTA CODOMS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'475','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1804,'RANFERON CAPSULES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'474','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1805,'QUININE MIXTURE 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'473','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1806,'HCTZ COSMOS 25MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'471','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1807,'BENAGAS GEL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'469','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1808,'ALUGEL SUSPENSION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'467','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1809,'DTS -Z KIT500',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'466','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1810,'CANDID TV 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'465','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1811,'BACTIGRAS/BIOGRASS/SOFRATULLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'464','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1812,'BENAGYL -DJ 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'462','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1813,'ABZ ORIGNAL TABS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'458','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1814,'VERMOX TABLETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'456','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1815,'ALBENDAZOLE TABS GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'454','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1816,'ABZ ORIGNAL SUSPENSION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'450','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1817,'LEVAMISOLE  SYRUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'449','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1818,'CALCIUM SANDOZ 1000MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'447','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1819,'CALAMINE LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'446','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1820,'CORFLEX FORTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'444','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1821,'ASPIRIN 75MG ECOSPIRIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'443','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1822,'KISS CODOMS CLASSIC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'442','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1823,'DAWADINE ANTISEPTIC SOLUTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'441','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1824,'ULCERID  ANTACID 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'440','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1825,'POVIDONE IODINE SINAI  50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'439','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1826,'CAVINTON 5MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'438','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1827,'AVODINE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'437','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1828,'DAFLON 500MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'435','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1829,'AMOXYL 500MG  BLISTER GEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'433','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1830,'NORMAL SALINE NASAL DROPS/ SALINE DROPS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'432','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1831,'UTABON 15ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1832,'SEPTRIN COTRIMOXAZOLE 960MG TABS DS BLISTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'429','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1833,'CANDID CLOMATRIMAZOLE EAR DROPS 15ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1834,'METRONIDAZOLE 60ML SYRUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1835,'EPHEDRINE ADULT NASAL DROPS 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'422','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1836,'PARACETAMOL TABLETS TIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'421','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1837,'PIROXICAM CAPSULES 20MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'419','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1838,'MEFTAL FORTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'417','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1839,'CONSED EXPECTORANT 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'413','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1840,'NEOPEPTINE -RB DROPS 15ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'410','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1841,'CONSED EXPECTORANT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'409','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1842,'SODA MINT SODIUM BICARBONATE TABLET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'408','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1843,'TRIDEX COUGH MIXTURE 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'407','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1844,'OSSCOFF EXPECTORANT60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1845,'GLUCOPHAGE 1000MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'405','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1846,'NICOF EXPECTORANT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1847,'FLUGONE PLUS SYRUP 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1848,'FLUGONE DM SYRUP 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1849,'COLDCAP SYRUP FOR CHILDREN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1850,'SURGICAL FACE MASK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'398','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1851,'CREPE BANDANGE 3 INCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'397','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1852,'BIOSCAB BENZYL BENZOATE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'396','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1853,'ASHTON POWDER GEN.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'394','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1854,'CYCLOPAM SUSPENSION 30ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'391','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1855,'ASCORIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'390','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1856,'SALBUTAMOL SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'389','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1857,'CONSAPROM PROMETHAZINE SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'388','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1858,'SULID SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'386','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1859,'PROMETHAZINE SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'385','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1860,'LORHISTINA SYRUP 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'384','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1861,'SUSTEN 400MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'383','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1862,'MICRONEMA 20ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'382','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1863,'ENEMAX 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'380','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1864,'LACTULOSE  SYRUP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'379','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1865,'CADISTIN EXPECTORANT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'375','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1866,'TRIMEX DIABETIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'374','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1867,'BENYLIN PEAD 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'373','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1868,'AMBROX EXPECTORANT SYRUP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'371','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1869,'COSCOF C 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'370','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1870,'CALCIMAX SYRUP 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'369','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1871,'BENASED PADIATRIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'367','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1872,'DELASED PAEDIATRIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'366','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1873,'MUCOSOLVAN SYRUP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'365','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1874,'CADIPHEN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'364','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1875,'CYPRO B PLUS SYRUP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'363','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1876,'ZEDCAL ORAL SUSPENSION 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'362','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1877,'NUTRIVITA AMINO ACIDS AND VITAMINS SYRUP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'361','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1878,'NILOL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'360','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1879,'MIXAVIT MULTIVITAMIN SYRUP BALANCED FORMULA 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'359','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1880,'TRES-ORIX FORTE ORAL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'358','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1881,'TRIMETABOL ORAL SOLUTION 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'357','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1882,'ASTYMIN SYRUP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'356','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1883,'KONTAB ANTI-INFLAMATORY ENZYME PREPARATION TABS 50MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'352','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1884,'CIPRO-T(CIPROFLAXACIN/TINIDAZOLE)500/600MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'349','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1885,'BENAHIST 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'347','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1886,'AN0MEX SUPPOSITORIES',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'339','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1887,'MANIX CAPS 20S',1,'single',1,NULL,NULL,NULL,8,NULL,NULL,'inclusive',1,0.0000,'335','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1888,'CANDID V3 CLOTRIMAZOLE ANTIFUNGAL 200MG',1,'single',1,NULL,NULL,NULL,9,NULL,NULL,'inclusive',1,0.0000,'330','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1889,'EPHEDRINE NASAL DROPS\\CHILD',1,'single',1,NULL,NULL,NULL,10,NULL,NULL,'inclusive',1,0.0000,'328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1890,'NEBILET 5MG',1,'single',1,NULL,NULL,NULL,11,NULL,NULL,'inclusive',1,0.0000,'325','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1891,'PRIMOLUT N 5MG',1,'single',1,NULL,NULL,NULL,11,NULL,NULL,'inclusive',1,0.0000,'322','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1892,'CAUSTIC PENCIL 95% BLUE',1,'single',1,NULL,NULL,NULL,11,NULL,NULL,'inclusive',1,0.0000,'313','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1893,'CAUSTIC PENCIL 40% RED',1,'single',1,NULL,NULL,NULL,11,NULL,NULL,'inclusive',1,0.0000,'312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1894,'ANT D RHESUS',1,'single',1,NULL,NULL,NULL,11,NULL,NULL,'inclusive',1,0.0000,'309','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1895,'BONNISAN 120ML',1,'single',1,NULL,NULL,NULL,12,NULL,NULL,'inclusive',1,0.0000,'305','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1896,'NORMAL SALINE 500ML INFUSSION',1,'single',1,NULL,NULL,NULL,3,NULL,NULL,'inclusive',1,0.0000,'304','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1897,'DIPROFOS INJ',1,'single',1,NULL,NULL,NULL,3,NULL,NULL,'inclusive',1,0.0000,'303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1898,'SEVEN SEAS 100ML',1,'single',1,NULL,NULL,NULL,13,NULL,NULL,'inclusive',1,0.0000,'298','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1899,'OSTEOCARE VITABIOTICS TABS',1,'single',1,NULL,NULL,NULL,13,NULL,NULL,'inclusive',1,0.0000,'295','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1900,'OMEGA H3 BIOTONIC CAPSULES-VITABIOTICS',1,'single',1,NULL,NULL,NULL,13,NULL,NULL,'inclusive',1,0.0000,'294','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1901,'I.V CANULLA G24 YELLOW',1,'single',1,NULL,NULL,NULL,14,NULL,NULL,'inclusive',1,0.0000,'286','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1902,'DEXTRACIN DEXAMETHASONE EYE/EAR EYE DROPS',1,'single',1,NULL,NULL,NULL,14,NULL,NULL,'inclusive',1,0.0000,'285','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1903,'CIPROFRED EYE DROPS CIPROFLOXACINE EYE DROPS',1,'single',1,NULL,NULL,NULL,14,NULL,NULL,'inclusive',1,0.0000,'284','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1904,'P2 GENEN/ EMERGENCY PILLS',1,'single',1,NULL,NULL,NULL,15,NULL,NULL,'inclusive',1,0.0000,'282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1905,'SURGICAL SPIRIT 1L',1,'single',1,NULL,NULL,NULL,16,NULL,NULL,'inclusive',1,0.0000,'276','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1906,'ZENTEL TABS 400MG',1,'single',1,NULL,NULL,NULL,17,NULL,NULL,'inclusive',1,0.0000,'273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1907,'ZENTEL SUSPENSION 20ML',1,'single',1,NULL,NULL,NULL,17,NULL,NULL,'inclusive',1,0.0000,'272','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1908,'NEMOCID TABS',1,'single',1,NULL,NULL,NULL,17,NULL,NULL,'inclusive',1,0.0000,'269','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1909,'UNIACNE CREAM',1,'single',1,NULL,NULL,NULL,18,NULL,NULL,'inclusive',1,0.0000,'264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1910,'BENYLIN ORIGINAL 100ML',1,'single',1,NULL,NULL,NULL,4,NULL,NULL,'inclusive',1,0.0000,'260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1911,'ASCORIL 200ML',1,'single',1,NULL,NULL,NULL,4,NULL,NULL,'inclusive',1,0.0000,'256','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1912,'SOLVIN PLUS 60ML',1,'single',1,NULL,NULL,NULL,19,NULL,NULL,'inclusive',1,0.0000,'254','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1913,'RHINATHIOL PROMETHAZINE 125ML',1,'single',1,NULL,NULL,NULL,19,NULL,NULL,'inclusive',1,0.0000,'253','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1914,'COSCOF C 100ML',1,'single',1,NULL,NULL,NULL,19,NULL,NULL,'inclusive',1,0.0000,'251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1915,'BENYLIN CODEINE 100ML',1,'single',1,NULL,NULL,NULL,19,NULL,NULL,'inclusive',1,0.0000,'250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1916,'OMEGA-3  FISH OIL 1000MG GUJARAT',1,'single',1,NULL,NULL,NULL,20,NULL,NULL,'inclusive',1,0.0000,'247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1917,'COZEPAM 5 DIAZEPAM TABLETS BP 5MG',1,'single',1,NULL,NULL,NULL,20,NULL,NULL,'inclusive',1,0.0000,'246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1918,'RECARTITX FORTE GLUCOSAMINE TABS',1,'single',1,NULL,NULL,NULL,21,NULL,NULL,'inclusive',1,0.0000,'244','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1919,'CALCIPLEX TABS',1,'single',1,NULL,NULL,NULL,21,NULL,NULL,'inclusive',1,0.0000,'243','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1920,'VENTOLIN SYRUP SUGAR FREE 100ML',1,'single',1,NULL,NULL,NULL,22,NULL,NULL,'inclusive',1,0.0000,'242','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1921,'FRANOL TABS  BLISTER',1,'single',1,NULL,NULL,NULL,22,NULL,NULL,'inclusive',1,0.0000,'240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1922,'DEPOMEDROL 40MG',1,'single',1,NULL,NULL,NULL,23,NULL,NULL,'inclusive',1,0.0000,'238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1923,'BIO OIL 60ML BIG SIZE',1,'single',1,NULL,NULL,NULL,23,NULL,NULL,'inclusive',1,0.0000,'236','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1924,'BETASON G OINTMENT',1,'single',1,NULL,NULL,NULL,23,NULL,NULL,'inclusive',1,0.0000,'235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1925,'BETASON CREAM 15GM',1,'single',1,NULL,NULL,NULL,23,NULL,NULL,'inclusive',1,0.0000,'234','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1926,'UNIBROL AMINOSIDINE SYRUP',1,'single',1,NULL,NULL,NULL,24,NULL,NULL,'inclusive',1,0.0000,'233','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1927,'TRES-ORIX FORTE SOLUCION ORAL 250ML',1,'single',1,NULL,NULL,NULL,24,NULL,NULL,'inclusive',1,0.0000,'232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1928,'CYPRIN SYRUP 100ML',1,'single',1,NULL,NULL,NULL,24,NULL,NULL,'inclusive',1,0.0000,'229','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1929,'HALOPERIDOLTABLETS BP 5MG',1,'single',1,NULL,NULL,NULL,25,NULL,NULL,'inclusive',1,0.0000,'222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1930,'FLUPHENAZINE DECANOATE INJINJECTION BP 1ML',1,'single',1,NULL,NULL,NULL,25,NULL,NULL,'inclusive',1,0.0000,'221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1931,'HYDROGEN PEROXIDE BP 200ML',1,'single',1,NULL,NULL,NULL,26,NULL,NULL,'inclusive',1,0.0000,'208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1932,'BETADINE ANTISEPTIC 125ML ORIGNAL',1,'single',1,NULL,NULL,NULL,26,NULL,NULL,'inclusive',1,0.0000,'207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1933,'SARACAL SYRUP 200ML',1,'single',1,NULL,NULL,NULL,27,NULL,NULL,'inclusive',1,0.0000,'204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1934,'DELASED DRY 100ML',1,'single',1,NULL,NULL,NULL,27,NULL,NULL,'inclusive',1,0.0000,'203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1935,'BULKOT B CREAM 15G',1,'single',1,NULL,NULL,NULL,27,NULL,NULL,'inclusive',1,0.0000,'201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1936,'KETOCONAZOLE CREAM',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'197','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1937,'GRISEOVULFIN 125MG',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1938,'FLUCONAZOLE TABS 200MG DICONAZOL COSMOS',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1939,'CLOTRIMAZOLE PESSARIES 6S 100MG',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1940,'CANDID POWDER',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1941,'CANDID MOUTH PAINT 15ML',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1942,'CANDID V GEL CREAM',1,'single',1,NULL,NULL,NULL,28,NULL,NULL,'inclusive',1,0.0000,'187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1943,'HISTALIN COUGH EXPECTORANT FOR CHESTY COUGHS 60ML',1,'single',1,NULL,NULL,NULL,29,NULL,NULL,'inclusive',1,0.0000,'185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1944,'METHYLDOPA TABS 250MG',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1945,'LOSARTAS - 50',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1946,'CARDINOL 50MG ATENOLOL COSMOS',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1947,'ASCARD 75MG',1,'single',1,NULL,NULL,NULL,5,NULL,NULL,'inclusive',1,0.0000,'172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1948,'PIRITON SYRUP 100ML ORIGNAL',1,'single',1,NULL,NULL,NULL,30,NULL,NULL,'inclusive',1,0.0000,'169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1949,'ZINNAT 250MG SUSPENSION',1,'single',1,NULL,NULL,NULL,30,NULL,NULL,'inclusive',1,0.0000,'167','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1950,'BENAFLU SYRUP 100ML',1,'single',1,NULL,NULL,NULL,30,NULL,NULL,'inclusive',1,0.0000,'166','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1951,'AERIUS ORAL SOLUTION 60ML',1,'single',1,NULL,NULL,NULL,30,NULL,NULL,'inclusive',1,0.0000,'163','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1952,'NOSIC TABS',1,'single',1,NULL,NULL,NULL,31,NULL,NULL,'inclusive',1,0.0000,'161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1953,'GLUCOPHAGE 500MG',1,'single',1,NULL,NULL,NULL,32,NULL,NULL,'inclusive',1,0.0000,'153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1954,'GLUCOMET 500MG',1,'single',1,NULL,NULL,NULL,32,NULL,NULL,'inclusive',1,0.0000,'152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1955,'DIBONIS TABS CHLORPROPAMIDE TABS 250MG',1,'single',1,NULL,NULL,NULL,32,NULL,NULL,'inclusive',1,0.0000,'150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1956,'XPEN 1MEGA VIAL',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1957,'OSTEOVITE CALCIUM TABS',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1958,'LINCOMYCIN CAPSULES',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1959,'LEVOFLOXACIN 750MG ORIGNAL',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1960,'CLARITHROMYCIN 500MG TABLETS',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1961,'CIPROINTA',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1962,'CEPHALEXIN SYRUP',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'117','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1963,'CEPHALEXIN 500MG CAPS',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1964,'CEFTRIAXONE INJECTIONE',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1965,'IBUPAR TABS',1,'single',1,NULL,NULL,NULL,33,NULL,NULL,'inclusive',1,0.0000,'106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1966,'MONTELUKAST MONTY 5MG',1,'single',1,NULL,NULL,NULL,34,NULL,NULL,'inclusive',1,0.0000,'99','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1967,'ULGICID ANTIACID SUSPENSION 200ML',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'96','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1968,'SUCRAFIL O GEL 100ML',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'94','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1969,'RELCER GEL 180ML',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'92','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1970,'PANTOPRAZOLE TABS ULTOP 40MG',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'91','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1971,'OMEPRAZOLE CAPSULES',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'90','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1972,'FLATAMEAL - DS SUSPENSION 200ML',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'85','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1973,'ESOMAC 20MG CIPLA',1,'single',1,NULL,NULL,NULL,6,NULL,NULL,'inclusive',1,0.0000,'82','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1974,'DEEP HEAT RUB 35G',1,'single',1,NULL,NULL,NULL,35,NULL,NULL,'inclusive',1,0.0000,'69','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1975,'TRACK MR',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'66','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1976,'BACLOFEN BACLON 10MG',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'64','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1977,'SALIMIA PAIN KILLING LINIMENT',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'63','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1978,'PANAD0L BABY  100ML',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'60','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1979,'OLFEN 75MG SR',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'59','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1980,'LIDOCAINE INJECTION 30ML',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'53','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1981,'INFACOL SIMETICONE 50ML',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'52','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1982,'GABAPENTIN 300MG\\NEUROBA',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'45','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1983,'DENTINOX COLIC DROPS 100ML',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'33','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1984,'DEEP HEAT SPRAY 150ML',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'32','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1985,'BRUSTAN SYRUP',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'28','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1986,'BONJELA TEETHING GEL',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'27','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1987,'APC TAB BLISTER',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'25','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1988,'ADRENALINE INJ',1,'single',1,NULL,NULL,NULL,36,NULL,NULL,'inclusive',1,0.0000,'22','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1989,'UNIBROL AMINOSIDE 250MG TABS',1,'single',1,NULL,NULL,NULL,37,NULL,NULL,'inclusive',1,0.0000,'19','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30'),(1990,'DAZOLIC COMPRIMES 500MG',1,'single',1,NULL,NULL,NULL,37,NULL,NULL,'inclusive',1,0.0000,'2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-03-17 05:47:30','2025-03-17 05:47:30');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',1,1,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(2,'business_location',1,1,'2025-03-16 07:25:49','2025-03-16 07:25:49');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (25,2),(26,2),(48,2),(49,2),(50,2),(51,2),(80,2);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_service_staff` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(2,'Cashier#1','web',1,0,0,'2025-03-16 07:25:49','2025-03-16 07:25:49');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
INSERT INTO `selling_price_groups` VALUES (1,'Wholesale',NULL,1,1,NULL,'2025-03-17 05:47:47','2025-03-17 05:47:47');
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','6.2'),(2,'default_business_active_status','1'),(3,'accounting_version','0.8');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `for_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `method` varchar(191) DEFAULT NULL,
  `payment_type` varchar(191) DEFAULT NULL,
  `transaction_no` varchar(191) DEFAULT NULL,
  `card_transaction_number` varchar(191) DEFAULT NULL,
  `card_number` varchar(191) DEFAULT NULL,
  `card_type` varchar(191) DEFAULT NULL,
  `card_holder_name` varchar(191) DEFAULT NULL,
  `card_month` varchar(191) DEFAULT NULL,
  `card_year` varchar(191) DEFAULT NULL,
  `card_security` varchar(5) DEFAULT NULL,
  `cheque_number` varchar(191) DEFAULT NULL,
  `bank_account_number` varchar(191) DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT 0,
  `gateway` varchar(191) DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT 0,
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `payment_ref_no` varchar(191) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text DEFAULT NULL,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `is_kitchen_order` tinyint(1) NOT NULL DEFAULT 0,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `sub_type` varchar(20) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `sub_status` varchar(191) DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `payment_status` enum('paid','due','partial') DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) DEFAULT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `source` varchar(191) DEFAULT NULL,
  `subscription_no` varchar(191) DEFAULT NULL,
  `subscription_repeat_on` varchar(191) DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `discount_type` enum('fixed','percentage') DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT 0.0000,
  `rp_redeemed` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) DEFAULT NULL,
  `delivered_to` varchar(191) DEFAULT NULL,
  `delivery_person` bigint(20) DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `shipping_custom_field_1` varchar(191) DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) DEFAULT NULL,
  `additional_notes` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_fields_info` longtext DEFAULT NULL,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_2` varchar(191) DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_3` varchar(191) DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_4` varchar(191) DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_sub_category_id` int(11) DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `purchase_requisition_ids` text DEFAULT NULL,
  `prefer_payment_method` varchar(191) DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text DEFAULT NULL,
  `purchase_order_ids` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `service_custom_field_1` text DEFAULT NULL,
  `service_custom_field_2` text DEFAULT NULL,
  `service_custom_field_3` text DEFAULT NULL,
  `service_custom_field_4` text DEFAULT NULL,
  `service_custom_field_5` text DEFAULT NULL,
  `service_custom_field_6` text DEFAULT NULL,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT 0,
  `rp_earned` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `order_addresses` text DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  KEY `transactions_delivery_person_index` (`delivery_person`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `location_price_group` text DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) NOT NULL,
  `short_name` varchar(191) NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pc(s)','Pc(s)',0,NULL,NULL,1,NULL,'2025-03-16 07:25:49','2025-03-17 05:37:31');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) NOT NULL DEFAULT 'user',
  `surname` char(10) DEFAULT NULL,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `password` varchar(191) DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT 'en',
  `contact_no` char(15) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `available_at` datetime DEFAULT NULL COMMENT 'Service staff avilable at. Calculated from product preparation_time_in_minutes',
  `paused_at` datetime DEFAULT NULL COMMENT 'Service staff available time paused at, Will be nulled on resume.',
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT 1,
  `status` enum('active','inactive','terminated') NOT NULL DEFAULT 'active',
  `is_enable_service_staff_pin` tinyint(1) NOT NULL DEFAULT 0,
  `service_staff_pin` text DEFAULT NULL,
  `crm_contact_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT 0,
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT 0.00,
  `selected_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `dob` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') DEFAULT NULL,
  `blood_group` char(10) DEFAULT NULL,
  `contact_number` char(20) DEFAULT NULL,
  `alt_number` varchar(191) DEFAULT NULL,
  `family_number` varchar(191) DEFAULT NULL,
  `fb_link` varchar(191) DEFAULT NULL,
  `twitter_link` varchar(191) DEFAULT NULL,
  `social_media_1` varchar(191) DEFAULT NULL,
  `social_media_2` varchar(191) DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `guardian_name` varchar(191) DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `bank_details` longtext DEFAULT NULL,
  `id_proof_name` varchar(191) DEFAULT NULL,
  `id_proof_number` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_crm_contact_id_foreign` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user',NULL,'Geoffrey',NULL,'admin','geoffreykyalo@gmail.com','$2y$10$G.ZQG7Dz3meQqvehR0tFU.8rGPA43YcxHBpbHRQPXI0CDeuKqtL4O','en',NULL,NULL,NULL,1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-16 07:25:49','2025-03-16 07:25:49'),(2,'user',NULL,'Joshua',NULL,'Joshua','joshua@gmail.com','$2y$10$bSGH/tesSfCUt5AEVqeDW.v4t1Nu9RqR69en3FTQKK2PSjZha5M.q','en',NULL,NULL,NULL,1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2025-03-16 05:02:01','2025-03-16 05:02:01');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `price_type` varchar(191) NOT NULL DEFAULT 'fixed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1958 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
INSERT INTO `variation_group_prices` VALUES (1,1,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(2,2,1,14.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(3,3,1,790.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(4,4,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(5,5,1,4.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(6,6,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(7,7,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(8,8,1,1110.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(9,9,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(10,10,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(11,11,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(12,12,1,8.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(13,13,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(14,14,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(15,15,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(16,16,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(17,17,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(18,18,1,139.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(19,19,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(20,20,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(21,21,1,360.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(22,22,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(23,23,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(24,24,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(25,25,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(26,26,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(27,27,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(28,28,1,195.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(29,29,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(30,30,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(31,31,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(32,32,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(33,33,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(34,34,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(35,35,1,1000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(36,36,1,54.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(37,37,1,1399.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(38,38,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(39,39,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(40,40,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(41,41,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(42,43,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(43,44,1,1500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(44,45,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(45,46,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(46,47,1,5.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(47,48,1,4.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(48,49,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(49,50,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(50,51,1,110.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(51,52,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(52,53,1,220.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(53,54,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(54,55,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(55,56,1,2.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(56,57,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(57,58,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(58,59,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(59,60,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(60,61,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(61,62,1,18.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(62,63,1,22.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(63,64,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(64,65,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(65,66,1,29.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(66,67,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(67,68,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(68,69,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(69,70,1,0.7000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(70,71,1,22.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(71,72,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(72,73,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(73,74,1,3.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(74,75,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(75,76,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(76,77,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(77,78,1,360.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(78,79,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(79,80,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(80,81,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(81,82,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(82,84,1,59.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(83,85,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(84,86,1,24.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(85,87,1,29.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(86,88,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(87,89,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(88,90,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(89,91,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(90,92,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(91,93,1,7.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(92,94,1,110.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(93,95,1,58.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(94,96,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(95,97,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(96,98,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(97,99,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(98,100,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(99,101,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(100,102,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(101,104,1,22.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(102,105,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(103,106,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(104,107,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(105,108,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(106,109,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(107,110,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(108,111,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(109,112,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(110,113,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(111,114,1,23.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(112,115,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(113,116,1,8.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(114,117,1,17.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(115,118,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(116,119,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(117,120,1,1.4000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(118,121,1,4.3000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(119,122,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(120,123,1,33.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(121,124,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(122,125,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(123,126,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(124,127,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(125,128,1,180.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(126,129,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(127,130,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(128,131,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(129,132,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(130,133,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(131,134,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(132,135,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(133,136,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(134,137,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(135,138,1,3000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(136,139,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(137,140,1,22.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(138,141,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(139,142,1,17.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(140,143,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(141,144,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(142,145,1,800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(143,147,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(144,148,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(145,149,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(146,150,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(147,152,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(148,153,1,780.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(149,154,1,2300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(150,155,1,265.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(151,156,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(152,157,1,98.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(153,158,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(154,159,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(155,160,1,1800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(156,161,1,6.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(157,162,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(158,163,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(159,164,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(160,165,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(161,166,1,7.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(162,167,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(163,168,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(164,169,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(165,170,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(166,171,1,900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(167,172,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(168,173,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(169,174,1,1.6500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(170,175,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(171,176,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(172,177,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(173,178,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(174,179,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(175,180,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(176,181,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(177,182,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(178,183,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(179,184,1,950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(180,185,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(181,186,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(182,187,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(183,188,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(184,189,1,340.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(185,190,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(186,191,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(187,192,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(188,193,1,23.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(189,194,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(190,195,1,8.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(191,196,1,3.6000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(192,197,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(193,198,1,240.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(194,199,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(195,200,1,580.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(196,201,1,1100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(197,202,1,265.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(198,203,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(199,204,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(200,205,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(201,206,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(202,208,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(203,209,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(204,210,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(205,211,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(206,212,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(207,213,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(208,214,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(209,215,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(210,216,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(211,217,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(212,218,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(213,219,1,199.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(214,220,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(215,221,1,5.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(216,222,1,185.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(217,223,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(218,224,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(219,225,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(220,226,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(221,227,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(222,228,1,790.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(223,229,1,950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(224,230,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(225,231,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(226,232,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(227,233,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(228,234,1,2200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(229,235,1,149.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(230,236,1,149.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(231,237,1,27.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(232,238,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(233,239,1,690.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(234,240,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(235,241,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(236,242,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(237,243,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(238,244,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(239,245,1,7.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(240,246,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(241,247,1,900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(242,248,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(243,249,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(244,250,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(245,251,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(246,252,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(247,253,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(248,254,1,31.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(249,255,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(250,256,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(251,257,1,4.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(252,258,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(253,259,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(254,260,1,4.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(255,261,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(256,262,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(257,263,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(258,264,1,42.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(259,265,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(260,266,1,180.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(261,267,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(262,268,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(263,269,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(264,270,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(265,271,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(266,272,1,1100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(267,273,1,480.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(268,274,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(269,275,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(270,276,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(271,277,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(272,278,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(273,279,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(274,280,1,199.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(275,281,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(276,282,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(277,283,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(278,284,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(279,285,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(280,286,1,1.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(281,287,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(282,288,1,4.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(283,289,1,9.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(284,290,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(285,291,1,175.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(286,292,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(287,293,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(288,294,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(289,295,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(290,296,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(291,297,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(292,298,1,259.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(293,299,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(294,300,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(295,301,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(296,302,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(297,303,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(298,304,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(299,305,1,190.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(300,306,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(301,307,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(302,308,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(303,309,1,1500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(304,310,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(305,311,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(306,312,1,33.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(307,313,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(308,314,1,110.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(309,315,1,19.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(310,316,1,0.4500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(311,317,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(312,318,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(313,319,1,17.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(314,320,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(315,321,1,2.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(316,322,1,1000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(317,323,1,2750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(318,324,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(319,325,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(320,326,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(321,327,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(322,328,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(323,329,1,600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(324,330,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(325,331,1,27.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(326,332,1,37.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(327,333,1,500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(328,334,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(329,335,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(330,336,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(331,337,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(332,338,1,900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(333,339,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(334,340,1,135.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(335,341,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(336,342,1,480.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(337,343,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(338,344,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(339,345,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(340,346,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(341,347,1,2.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(342,348,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(343,349,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(344,351,1,2400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(345,352,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(346,353,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(347,354,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(348,355,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(349,356,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(350,357,1,19.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(351,358,1,2.7000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(352,359,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(353,360,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(354,361,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(355,362,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(356,363,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(357,364,1,15.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(358,365,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(359,366,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(360,367,1,1.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(361,368,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(362,369,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(363,370,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(364,371,1,170.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(365,372,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(366,373,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(367,374,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(368,375,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(369,376,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(370,377,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(371,378,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(372,379,1,5.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(373,380,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(374,381,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(375,382,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(376,383,1,380.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(377,384,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(378,385,1,500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(379,386,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(380,387,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(381,388,1,390.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(382,389,1,199.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(383,390,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(384,391,1,0.9500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(385,392,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(386,393,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(387,394,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(388,395,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(389,396,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(390,397,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(391,398,1,0.7500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(392,399,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(393,400,1,4.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(394,401,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(395,402,1,3.9900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(396,404,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(397,405,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(398,406,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(399,407,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(400,408,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(401,409,1,7.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(402,410,1,5.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(403,411,1,3.6000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(404,412,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(405,413,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(406,416,1,49.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(407,417,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(408,418,1,7.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(409,419,1,2000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(410,420,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(411,421,1,850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(412,422,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(413,423,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(414,424,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(415,425,1,800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(416,426,1,800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(417,427,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(418,428,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(419,429,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(420,430,1,680.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(421,431,1,15.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(422,432,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(423,433,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(424,434,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(425,435,1,3.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(426,436,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(427,437,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(428,438,1,49.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(429,439,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(430,440,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(431,442,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(432,443,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(433,444,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(434,445,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(435,446,1,480.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(436,447,1,380.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(437,448,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(438,449,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(439,450,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(440,451,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(441,452,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(442,453,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(443,454,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(444,455,1,780.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(445,456,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(446,457,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(447,460,1,4.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(448,462,1,110.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(449,463,1,107.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(450,464,1,32.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(451,466,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(452,467,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(453,468,1,125.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(454,469,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(455,470,1,149.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(456,471,1,0.4900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(457,472,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(458,473,1,4.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(459,474,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(460,475,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(461,476,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(462,477,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(463,478,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(464,479,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(465,480,1,1450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(466,481,1,1150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(467,482,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(468,483,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(469,484,1,255.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(470,485,1,240.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(471,486,1,195.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(472,487,1,1.9900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(473,488,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(474,489,1,290.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(475,491,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(476,492,1,600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(477,493,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(478,494,1,119.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(479,495,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(480,496,1,1250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(481,497,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(482,498,1,1.5500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(483,499,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(484,500,1,3500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(485,501,1,49.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(486,502,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(487,503,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(488,504,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(489,505,1,5000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(490,506,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(491,507,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(492,508,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(493,509,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(494,510,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(495,511,1,8.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(496,512,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(497,513,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(498,514,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(499,515,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(500,516,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(501,517,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(502,518,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(503,519,1,52.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(504,520,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(505,521,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(506,523,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(507,524,1,36.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(508,525,1,1.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(509,526,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(510,527,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(511,528,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(512,529,1,6.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(513,530,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(514,531,1,0.3800,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(515,532,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(516,533,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(517,534,1,1300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(518,535,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(519,536,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(520,537,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(521,538,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(522,539,1,330.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(523,540,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(524,541,1,4.2000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(525,542,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(526,543,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(527,544,1,5.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(528,545,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(529,546,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(530,547,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(531,548,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(532,549,1,14.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(533,550,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(534,551,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(535,552,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(536,553,1,79.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(537,554,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(538,555,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(539,556,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(540,557,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(541,558,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(542,559,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(543,560,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(544,561,1,195.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(545,562,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(546,563,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(547,564,1,115.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(548,565,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(549,566,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(550,567,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(551,568,1,175.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(552,569,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(553,570,1,1000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(554,571,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(555,572,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(556,574,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(557,575,1,385.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(558,576,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(559,577,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(560,578,1,680.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(561,579,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(562,580,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(563,581,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(564,582,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(565,583,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(566,584,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(567,585,1,23.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(568,586,1,56.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(569,588,1,1350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(570,589,1,700.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(571,590,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(572,591,1,3.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(573,592,1,2500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(574,593,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(575,594,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(576,595,1,190.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(577,596,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(578,597,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(579,598,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(580,599,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(581,600,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(582,601,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(583,602,1,17.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(584,603,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(585,604,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(586,605,1,41.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(587,606,1,2.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(588,607,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(589,608,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(590,609,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(591,610,1,1600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(592,611,1,680.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(593,612,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(594,613,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(595,614,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(596,615,1,1.9900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(597,616,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(598,617,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(599,618,1,3800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(600,619,1,9500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(601,620,1,2500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(602,621,1,1000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(603,622,1,7.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(604,623,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(605,624,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(606,625,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(607,626,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(608,627,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(609,628,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(610,629,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(611,630,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(612,631,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(613,632,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(614,633,1,5.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(615,634,1,0.9500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(616,635,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(617,636,1,3.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(618,637,1,3.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(619,638,1,8.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(620,639,1,500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(621,640,1,2880.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(622,641,1,540.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(623,642,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(624,643,1,1.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(625,644,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(626,645,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(627,646,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(628,647,1,295.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(629,648,1,430.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(630,649,1,129.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(631,650,1,2500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(632,651,1,1800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(633,652,1,1600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(634,654,1,7.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(635,655,1,1.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(636,656,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(637,657,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(638,658,1,780.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(639,659,1,850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(640,660,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(641,661,1,59.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(642,662,1,145.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(643,663,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(644,664,1,255.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(645,665,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(646,666,1,9.3000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(647,667,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(648,668,1,500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(649,669,1,1300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(650,670,1,175.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(651,671,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(652,672,1,3.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(653,673,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(654,674,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(655,675,1,1.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(656,676,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(657,677,1,19.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(658,678,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(659,679,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(660,680,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(661,681,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(662,682,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(663,683,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(664,684,1,11.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(665,685,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(666,686,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(667,687,1,7.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(668,688,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(669,689,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(670,690,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(671,691,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(672,692,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(673,693,1,4.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(674,694,1,180.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(675,695,1,159.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(676,696,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(677,697,1,6.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(678,698,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(679,699,1,1250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(680,700,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(681,701,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(682,702,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(683,703,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(684,704,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(685,705,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(686,706,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(687,707,1,140.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(688,708,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(689,709,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(690,710,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(691,711,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(692,712,1,64.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(693,713,1,190.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(694,714,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(695,715,1,145.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(696,716,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(697,717,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(698,718,1,1660.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(699,719,1,2.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(700,720,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(701,721,1,1350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(702,722,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(703,723,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(704,724,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(705,725,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(706,726,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(707,727,1,3900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(708,728,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(709,730,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(710,731,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(711,732,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(712,733,1,1250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(713,734,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(714,735,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(715,736,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(716,737,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(717,738,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(718,739,1,190.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(719,740,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(720,741,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(721,742,1,850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(722,743,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(723,744,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(724,745,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(725,746,1,630.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(726,747,1,850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(727,748,1,46.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(728,749,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(729,750,1,2.9900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(730,751,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(731,752,1,1950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(732,753,1,5800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(733,754,1,0.8500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(734,755,1,0.6500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(735,756,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(736,757,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(737,758,1,97.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(738,759,1,2500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(739,760,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(740,761,1,9.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(741,762,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(742,763,1,43.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(743,764,1,1950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(744,766,1,2800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(745,767,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(746,768,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(747,769,1,31.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(748,770,1,5.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(749,771,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(750,772,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(751,773,1,5.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(752,774,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(753,775,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(754,776,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(755,777,1,149.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(756,778,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(757,779,1,3500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(758,780,1,1.9500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(759,781,1,1.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(760,782,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(761,783,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(762,784,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(763,785,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(764,786,1,950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(765,787,1,1650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(766,788,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(767,789,1,2.9900,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(768,790,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(769,791,1,17.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(770,792,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(771,793,1,89.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(772,794,1,780.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(773,795,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(774,796,1,880.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(775,797,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(776,798,1,480.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(777,800,1,32.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(778,801,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(779,802,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(780,803,1,92.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(781,804,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(782,805,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(783,806,1,1.8500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(784,807,1,59.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(785,808,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(786,809,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(787,810,1,149.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(788,811,1,170.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(789,812,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(790,813,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(791,814,1,3.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(792,815,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(793,816,1,400.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(794,817,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(795,818,1,230.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(796,819,1,1200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(797,820,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(798,821,1,16.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(799,822,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(800,823,1,26.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(801,824,1,220.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(802,825,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(803,826,1,26.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(804,827,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(805,828,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(806,829,1,6.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(807,830,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(808,831,1,145.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(809,832,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(810,833,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(811,834,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(812,835,1,2.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(813,836,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(814,837,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(815,838,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(816,839,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(817,840,1,900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(818,841,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(819,843,1,180.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(820,844,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(821,845,1,390.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(822,846,1,17.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(823,847,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(824,848,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(825,849,1,17.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(826,850,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(827,851,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(828,852,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(829,853,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(830,854,1,169.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(831,855,1,175.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(832,856,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(833,857,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(834,858,1,14.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(835,859,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(836,860,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(837,861,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(838,862,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(839,863,1,395.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(840,864,1,1490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(841,865,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(842,866,1,5.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(843,867,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(844,868,1,19.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(845,869,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(846,870,1,200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(847,871,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(848,872,1,69.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(849,873,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(850,874,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(851,875,1,560.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(852,876,1,2900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(853,877,1,880.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(854,878,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(855,879,1,1.9500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(856,880,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(857,881,1,7.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(858,882,1,49.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(859,883,1,93.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(860,884,1,2950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(861,885,1,2850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(862,886,1,2000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(863,887,1,29.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(864,888,1,790.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(865,889,1,49.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(866,890,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(867,891,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(868,892,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(869,893,1,950.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(870,894,1,850.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(871,895,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(872,896,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(873,897,1,395.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(874,898,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(875,899,1,279.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(876,900,1,7.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(877,901,1,2600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(878,902,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(879,903,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(880,904,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(881,905,1,5.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(882,906,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(883,907,1,290.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(884,908,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(885,909,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(886,910,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(887,912,1,299.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(888,913,1,800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(889,914,1,800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(890,915,1,1500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(891,916,1,1500.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(892,917,1,2600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(893,918,1,2600.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(894,919,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(895,920,1,1550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(896,921,1,17.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(897,922,1,90.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(898,923,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(899,924,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(900,925,1,4.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(901,926,1,79.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(902,927,1,119.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(903,928,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(904,929,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(905,930,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(906,931,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(907,932,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(908,933,1,900.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(909,934,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(910,935,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(911,936,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(912,937,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(913,938,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(914,939,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(915,940,1,4.9000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(916,941,1,4.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(917,942,1,135.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(918,943,1,5.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(919,944,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(920,945,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(921,946,1,11000.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(922,947,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(923,948,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(924,949,1,260.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(925,950,1,2100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(926,951,1,36.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(927,952,1,60.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(928,953,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(929,954,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(930,955,1,3.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(931,956,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(932,957,1,8.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(933,958,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(934,959,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(935,960,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(936,961,1,95.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(937,962,1,56.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(938,963,1,300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(939,964,1,1100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(940,965,1,35.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(941,966,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(942,967,1,70.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(943,968,1,510.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(944,969,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(945,970,1,99.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(946,971,1,700.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(947,972,1,550.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(948,973,1,1350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(949,974,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(950,975,1,390.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(951,976,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(952,977,1,1350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(953,978,1,2200.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(954,979,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(955,980,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(956,981,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(957,982,1,79.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(958,983,1,79.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(959,984,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(960,985,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(961,986,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(962,987,1,1800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(963,988,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(964,989,1,25.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(965,990,1,80.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(966,991,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(967,992,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(968,993,1,79.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(969,994,1,18.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(970,995,1,290.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(971,996,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(972,997,1,730.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(973,998,1,450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(974,999,1,630.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(975,1000,1,38.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(976,1001,1,250.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(977,1002,1,750.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(978,1003,1,150.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(979,1004,1,570.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(980,1005,1,199.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(981,1006,1,290.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(982,1007,1,50.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(983,1008,1,865.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(984,1009,1,0.5500,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(985,1010,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(986,1011,1,130.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(987,1012,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(988,1013,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(989,1014,1,160.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(990,1015,1,270.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(991,1016,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(992,1017,1,13.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(993,1018,1,420.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(994,1019,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(995,1020,1,190.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(996,1021,1,19.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(997,1022,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(998,1023,1,1300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(999,1024,1,1450.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1000,1025,1,670.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1001,1026,1,6.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1002,1027,1,30.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1003,1028,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1004,1029,1,6.3000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1005,1030,1,0.6650,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1006,1031,1,890.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1007,1032,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1008,1033,1,48.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1009,1034,1,9.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1010,1035,1,78.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1011,1036,1,55.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1012,1037,1,1.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1013,1038,1,10.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1014,1039,1,85.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1015,1040,1,240.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1016,1041,1,12.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1017,1042,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1018,1043,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1019,1044,1,280.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1020,1045,1,39.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1021,1046,1,65.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1022,1047,1,650.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1023,1048,1,6.5000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1024,1049,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1025,1050,1,5.8000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1026,1051,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1027,1052,1,260.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1028,1053,1,15.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1029,1054,1,45.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1030,1055,1,5.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1031,1056,1,240.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1032,1057,1,490.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1033,1058,1,2300.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1034,1059,1,2800.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1035,1060,1,350.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1036,1062,1,480.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1037,1063,1,28.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1038,1067,1,1.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1039,1068,1,1050.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1040,1069,1,125.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1041,1070,1,20.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1042,1071,1,23.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1043,1072,1,40.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1044,1073,1,120.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1045,1074,1,69.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1046,1075,1,75.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1047,1076,1,100.0000,'fixed','2025-03-17 05:49:51','2025-03-17 05:49:51'),(1048,1077,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1049,1078,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1050,1079,1,940.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1051,1080,1,1100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1052,1081,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1053,1082,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1054,1083,1,1.2000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1055,1084,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1056,1085,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1057,1086,1,188.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1058,1087,1,480.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1059,1088,1,630.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1060,1089,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1061,1090,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1062,1091,1,12.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1063,1092,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1064,1093,1,550.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1065,1094,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1066,1095,1,140.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1067,1096,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1068,1097,1,160.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1069,1098,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1070,1099,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1071,1100,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1072,1101,1,48.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1073,1102,1,18.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1074,1103,1,1200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1075,1104,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1076,1105,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1077,1106,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1078,1107,1,1200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1079,1108,1,23.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1080,1109,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1081,1110,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1082,1111,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1083,1112,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1084,1113,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1085,1114,1,155.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1086,1115,1,900.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1087,1116,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1088,1117,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1089,1118,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1090,1119,1,6.6000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1091,1120,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1092,1121,1,240.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1093,1122,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1094,1123,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1095,1124,1,1.6000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1096,1125,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1097,1126,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1098,1127,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1099,1128,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1100,1129,1,139.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1101,1130,1,115.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1102,1131,1,80.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1103,1132,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1104,1133,1,1750.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1105,1134,1,230.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1106,1135,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1107,1136,1,13.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1108,1137,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1109,1138,1,49.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1110,1139,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1111,1140,1,49.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1112,1141,1,1000.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1113,1142,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1114,1143,1,450.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1115,1144,1,79.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1116,1145,1,79.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1117,1146,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1118,1147,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1119,1148,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1120,1149,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1121,1150,1,105.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1122,1151,1,290.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1123,1152,1,270.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1124,1153,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1125,1154,1,54.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1126,1155,1,390.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1127,1156,1,780.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1128,1157,1,8.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1129,1158,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1130,1159,1,59.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1131,1160,1,290.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1132,1161,1,2800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1133,1162,1,60.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1134,1163,1,135.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1135,1164,1,400.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1136,1165,1,199.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1137,1166,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1138,1167,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1139,1168,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1140,1169,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1141,1170,1,26.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1142,1171,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1143,1172,1,18.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1144,1173,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1145,1174,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1146,1175,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1147,1176,1,14.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1148,1177,1,185.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1149,1178,1,275.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1150,1179,1,490.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1151,1180,1,28.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1152,1181,1,12.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1153,1182,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1154,1183,1,99.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1155,1184,1,220.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1156,1185,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1157,1186,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1158,1187,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1159,1188,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1160,1189,1,1.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1161,1190,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1162,1191,1,60.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1163,1192,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1164,1193,1,165.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1165,1194,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1166,1195,1,900.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1167,1196,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1168,1197,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1169,1198,1,3.4900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1170,1199,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1171,1200,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1172,1201,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1173,1202,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1174,1203,1,2500.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1175,1204,1,1800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1176,1205,1,2600.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1177,1206,1,2700.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1178,1207,1,2900.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1179,1208,1,2500.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1180,1209,1,2800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1181,1210,1,2500.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1182,1211,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1183,1212,1,800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1184,1213,1,190.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1185,1214,1,10.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1186,1215,1,1950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1187,1216,1,1800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1188,1217,1,800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1189,1218,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1190,1219,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1191,1220,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1192,1221,1,2000.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1193,1222,1,0.6900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1194,1223,1,600.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1195,1224,1,178.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1196,1225,1,4.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1197,1226,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1198,1227,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1199,1228,1,1.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1200,1229,1,280.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1201,1230,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1202,1231,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1203,1232,1,69.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1204,1233,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1205,1234,1,680.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1206,1235,1,270.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1207,1236,1,349.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1208,1237,1,220.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1209,1238,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1210,1239,1,1450.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1211,1240,1,2000.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1212,1241,1,245.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1213,1242,1,185.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1214,1243,1,33.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1215,1244,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1216,1245,1,6.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1217,1246,1,29.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1218,1247,1,17.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1219,1248,1,39.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1220,1249,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1221,1250,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1222,1251,1,0.9500,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1223,1252,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1224,1253,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1225,1254,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1226,1255,1,10.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1227,1256,1,8.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1228,1257,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1229,1258,1,520.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1230,1259,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1231,1260,1,12.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1232,1261,1,2900.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1233,1262,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1234,1263,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1235,1264,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1236,1265,1,59.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1237,1266,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1238,1267,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1239,1268,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1240,1269,1,6.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1241,1270,1,2.4000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1242,1271,1,22.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1243,1272,1,59.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1244,1273,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1245,1274,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1246,1275,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1247,1276,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1248,1277,1,19.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1249,1278,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1250,1279,1,160.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1251,1280,1,135.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1252,1281,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1253,1282,1,48.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1254,1283,1,60.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1255,1284,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1256,1285,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1257,1286,1,60.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1258,1287,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1259,1288,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1260,1289,1,6.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1261,1290,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1262,1291,1,260.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1263,1292,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1264,1293,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1265,1294,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1266,1295,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1267,1296,1,299.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1268,1297,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1269,1298,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1270,1299,1,2500.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1271,1300,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1272,1301,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1273,1302,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1274,1303,1,125.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1275,1304,1,650.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1276,1305,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1277,1306,1,470.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1278,1307,1,750.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1279,1308,1,280.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1280,1309,1,395.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1281,1310,1,130.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1282,1311,1,21.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1283,1312,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1284,1313,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1285,1314,1,4.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1286,1315,1,3.4000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1287,1316,1,27.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1288,1317,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1289,1318,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1290,1319,1,110.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1291,1320,1,19.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1292,1321,1,150.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1293,1322,1,800.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1294,1323,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1295,1324,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1296,1325,1,700.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1297,1326,1,36.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1298,1327,1,28.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1299,1328,1,3.3000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1300,1329,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1301,1330,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1302,1331,1,16.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1303,1332,1,69.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1304,1333,1,79.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1305,1334,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1306,1335,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1307,1336,1,98.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1308,1337,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1309,1338,1,270.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1310,1339,1,277.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1311,1340,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1312,1341,1,23.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1313,1342,1,11.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1314,1343,1,23.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1315,1344,1,48.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1316,1345,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1317,1346,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1318,1347,1,1.8000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1319,1348,1,1.2900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1320,1349,1,1.2900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1321,1350,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1322,1351,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1323,1352,1,1.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1324,1353,1,33.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1325,1354,1,39.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1326,1355,1,2.8500,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1327,1356,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1328,1357,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1329,1358,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1330,1359,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1331,1360,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1332,1361,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1333,1362,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1334,1363,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1335,1364,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1336,1365,1,230.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1337,1366,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1338,1367,1,14.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1339,1368,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1340,1369,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1341,1370,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1342,1371,1,17.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1343,1372,1,590.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1344,1373,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1345,1374,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1346,1375,1,6.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1347,1376,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1348,1377,1,9.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1349,1378,1,5.3000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1350,1379,1,3.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1351,1380,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1352,1381,1,59.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1353,1382,1,80.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1354,1384,1,1.6500,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1355,1386,1,60.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1356,1387,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1357,1389,1,9.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1358,1390,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1359,1391,1,4.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1360,1392,1,2.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1361,1393,1,3.8000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1362,1394,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1363,1395,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1364,1396,1,1000.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1365,1397,1,265.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1366,1398,1,95.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1367,1399,1,390.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1368,1400,1,750.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1369,1401,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1370,1402,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1371,1403,1,2600.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1372,1404,1,2200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1373,1405,1,1700.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1374,1406,1,1500.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1375,1407,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1376,1408,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1377,1409,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1378,1410,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1379,1411,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1380,1412,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1381,1413,1,13.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1382,1414,1,18.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1383,1415,1,11.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1384,1416,1,8.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1385,1417,1,4.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1386,1418,1,2.8500,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1387,1419,1,1.9900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1388,1420,1,88.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1389,1421,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1390,1422,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1391,1423,1,1.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1392,1424,1,200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1393,1425,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1394,1426,1,16.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1395,1427,1,199.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1396,1428,1,10.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1397,1429,1,180.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1398,1430,1,1.4500,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1399,1431,1,2.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1400,1432,1,22.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1401,1433,1,780.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1402,1434,1,450.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1403,1435,1,1.2000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1404,1436,1,27.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1405,1437,1,16.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1406,1438,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1407,1439,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1408,1440,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1409,1441,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1410,1442,1,550.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1411,1443,1,400.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1412,1444,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1413,1445,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1414,1446,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1415,1447,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1416,1448,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1417,1449,1,160.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1418,1450,1,149.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1419,1451,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1420,1452,1,24.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1421,1453,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1422,1454,1,48.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1423,1455,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1424,1456,1,9.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1425,1457,1,15.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1426,1458,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1427,1459,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1428,1460,1,135.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1429,1461,1,600.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1430,1462,1,5.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1431,1463,1,33.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1432,1464,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1433,1465,1,15.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1434,1466,1,89.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1435,1467,1,1200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1436,1468,1,195.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1437,1469,1,1350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1438,1470,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1439,1471,1,49.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1440,1472,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1441,1473,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1442,1474,1,630.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1443,1475,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1444,1476,1,230.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1445,1477,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1446,1478,1,599.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1447,1479,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1448,1480,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1449,1481,1,12.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1450,1482,1,330.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1451,1483,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1452,1484,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1453,1485,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1454,1486,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1455,1487,1,28.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1456,1488,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1457,1489,1,750.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1458,1490,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1459,1491,1,6.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1460,1492,1,1.7000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1461,1493,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1462,1494,1,3.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1463,1495,1,480.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1464,1496,1,2400.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1465,1497,1,11.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1466,1498,1,690.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1467,1499,1,10.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1468,1500,1,260.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1469,1501,1,129.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1470,1502,1,2.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1471,1503,1,99.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1472,1504,1,100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1473,1505,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1474,1506,1,4400.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1475,1507,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1476,1508,1,850.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1477,1509,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1478,1510,1,39.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1479,1511,1,22.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1480,1512,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1481,1513,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1482,1514,1,300.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1483,1515,1,145.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1484,1516,1,890.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1485,1517,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1486,1518,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1487,1519,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1488,1520,1,17.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1489,1521,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1490,1522,1,3.8000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1491,1523,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1492,1524,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1493,1525,1,45.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1494,1526,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1495,1527,1,200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1496,1528,1,59.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1497,1529,1,880.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1498,1530,1,85.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1499,1531,1,250.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1500,1532,1,880.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1501,1533,1,13.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1502,1534,1,58.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1503,1535,1,42.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1504,1536,1,320.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1505,1537,1,189.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1506,1538,1,189.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1507,1539,1,129.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1508,1540,1,950.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1509,1541,1,780.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1510,1542,1,39.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1511,1543,1,25.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1512,1544,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1513,1545,1,2.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1514,1546,1,38.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1515,1547,1,30.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1516,1548,1,3.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1517,1549,1,270.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1518,1550,1,110.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1519,1551,1,240.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1520,1552,1,4.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1521,1553,1,70.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1522,1554,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1523,1555,1,350.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1524,1556,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1525,1557,1,140.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1526,1558,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1527,1559,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1528,1560,1,35.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1529,1561,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1530,1562,1,47.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1531,1563,1,75.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1532,1564,1,50.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1533,1565,1,120.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1534,1566,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1535,1567,1,1.3000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1536,1568,1,20.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1537,1569,1,26.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1538,1570,1,13.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1539,1571,1,8.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1540,1572,1,65.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1541,1573,1,26.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1542,1574,1,19.9900,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1543,1575,1,9.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1544,1576,1,1100.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1545,1577,1,55.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1546,1578,1,3.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1547,1579,1,40.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1548,1580,1,13.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1549,1581,1,1200.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1550,1582,1,46.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1551,1583,1,295.0000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1552,1584,1,16.9000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1553,1585,1,8.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1554,1586,1,7.5000,'fixed','2025-03-17 05:49:52','2025-03-17 05:49:52'),(1555,1587,1,100.0000,'fixed','2025-03-17 05:49: